/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.proto;

import io.substrait.extension.ExtensionCollector;
import io.substrait.proto.Type;
import io.substrait.type.proto.BaseProtoConverter;
import io.substrait.type.proto.BaseProtoTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeProtoConverter
extends BaseProtoConverter<Type, Integer> {
    static final Logger logger = LoggerFactory.getLogger(TypeProtoConverter.class);
    private static final BaseProtoTypes<Type, Integer> NULLABLE = new Types(Type.Nullability.NULLABILITY_NULLABLE);
    private static final BaseProtoTypes<Type, Integer> REQUIRED = new Types(Type.Nullability.NULLABILITY_REQUIRED);

    public TypeProtoConverter(ExtensionCollector extensionCollector) {
        super(extensionCollector, "Type literals cannot contain parameters or expressions.");
    }

    @Override
    public BaseProtoTypes<Type, Integer> typeContainer(boolean nullable) {
        return nullable ? NULLABLE : REQUIRED;
    }

    private static class Types
    extends BaseProtoTypes<Type, Integer> {
        public Types(Type.Nullability nullability) {
            super(nullability);
        }

        @Override
        public Type fixedChar(Integer len) {
            return this.wrap(Type.FixedChar.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public Type typeParam(String name) {
            throw new UnsupportedOperationException("It is not possible to use parameters in basic types.");
        }

        @Override
        public Integer integerParam(String name) {
            throw new UnsupportedOperationException("It is not possible to use parameters in basic types.");
        }

        @Override
        public Type varChar(Integer len) {
            return this.wrap(Type.VarChar.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public Type fixedBinary(Integer len) {
            return this.wrap(Type.FixedBinary.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public Type decimal(Integer scale, Integer precision) {
            return this.wrap(Type.Decimal.newBuilder().setScale(scale).setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public Type intervalDay(Integer precision) {
            return this.wrap(Type.IntervalDay.newBuilder().setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public Type intervalCompound(Integer precision) {
            return this.wrap(Type.IntervalCompound.newBuilder().setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public Type precisionTimestamp(Integer precision) {
            return this.wrap(Type.PrecisionTimestamp.newBuilder().setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public Type precisionTimestampTZ(Integer precision) {
            return this.wrap(Type.PrecisionTimestampTZ.newBuilder().setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public Type struct(Iterable<Type> types) {
            return this.wrap(Type.Struct.newBuilder().addAllTypes(types).setNullability(this.nullability).build());
        }

        @Override
        public Type list(Type type) {
            return this.wrap(Type.List.newBuilder().setType(type).setNullability(this.nullability).build());
        }

        @Override
        public Type map(Type key, Type value) {
            return this.wrap(Type.Map.newBuilder().setKey(key).setValue(value).setNullability(this.nullability).build());
        }

        @Override
        public Type userDefined(int ref) {
            return this.wrap(Type.UserDefined.newBuilder().setTypeReference(ref).setNullability(this.nullability).build());
        }

        @Override
        protected Type wrap(Object o) {
            Type.Builder bldr = Type.newBuilder();
            if (o instanceof Type.Boolean) {
                Type.Boolean t = (Type.Boolean)o;
                return bldr.setBool(t).build();
            }
            if (o instanceof Type.I8) {
                Type.I8 t = (Type.I8)o;
                return bldr.setI8(t).build();
            }
            if (o instanceof Type.I16) {
                Type.I16 t = (Type.I16)o;
                return bldr.setI16(t).build();
            }
            if (o instanceof Type.I32) {
                Type.I32 t = (Type.I32)o;
                return bldr.setI32(t).build();
            }
            if (o instanceof Type.I64) {
                Type.I64 t = (Type.I64)o;
                return bldr.setI64(t).build();
            }
            if (o instanceof Type.FP32) {
                Type.FP32 t = (Type.FP32)o;
                return bldr.setFp32(t).build();
            }
            if (o instanceof Type.FP64) {
                Type.FP64 t = (Type.FP64)o;
                return bldr.setFp64(t).build();
            }
            if (o instanceof Type.String) {
                Type.String t = (Type.String)o;
                return bldr.setString(t).build();
            }
            if (o instanceof Type.Binary) {
                Type.Binary t = (Type.Binary)o;
                return bldr.setBinary(t).build();
            }
            if (o instanceof Type.Timestamp) {
                Type.Timestamp t = (Type.Timestamp)o;
                return bldr.setTimestamp(t).build();
            }
            if (o instanceof Type.Date) {
                Type.Date t = (Type.Date)o;
                return bldr.setDate(t).build();
            }
            if (o instanceof Type.Time) {
                Type.Time t = (Type.Time)o;
                return bldr.setTime(t).build();
            }
            if (o instanceof Type.TimestampTZ) {
                Type.TimestampTZ t = (Type.TimestampTZ)o;
                return bldr.setTimestampTz(t).build();
            }
            if (o instanceof Type.IntervalYear) {
                Type.IntervalYear t = (Type.IntervalYear)o;
                return bldr.setIntervalYear(t).build();
            }
            if (o instanceof Type.IntervalDay) {
                Type.IntervalDay t = (Type.IntervalDay)o;
                return bldr.setIntervalDay(t).build();
            }
            if (o instanceof Type.IntervalCompound) {
                Type.IntervalCompound t = (Type.IntervalCompound)o;
                return bldr.setIntervalCompound(t).build();
            }
            if (o instanceof Type.FixedChar) {
                Type.FixedChar t = (Type.FixedChar)o;
                return bldr.setFixedChar(t).build();
            }
            if (o instanceof Type.VarChar) {
                Type.VarChar t = (Type.VarChar)o;
                return bldr.setVarchar(t).build();
            }
            if (o instanceof Type.FixedBinary) {
                Type.FixedBinary t = (Type.FixedBinary)o;
                return bldr.setFixedBinary(t).build();
            }
            if (o instanceof Type.Decimal) {
                Type.Decimal t = (Type.Decimal)o;
                return bldr.setDecimal(t).build();
            }
            if (o instanceof Type.PrecisionTimestamp) {
                Type.PrecisionTimestamp t = (Type.PrecisionTimestamp)o;
                return bldr.setPrecisionTimestamp(t).build();
            }
            if (o instanceof Type.PrecisionTimestampTZ) {
                Type.PrecisionTimestampTZ t = (Type.PrecisionTimestampTZ)o;
                return bldr.setPrecisionTimestampTz(t).build();
            }
            if (o instanceof Type.Struct) {
                Type.Struct t = (Type.Struct)o;
                return bldr.setStruct(t).build();
            }
            if (o instanceof Type.List) {
                Type.List t = (Type.List)o;
                return bldr.setList(t).build();
            }
            if (o instanceof Type.Map) {
                Type.Map t = (Type.Map)o;
                return bldr.setMap(t).build();
            }
            if (o instanceof Type.UUID) {
                Type.UUID t = (Type.UUID)o;
                return bldr.setUuid(t).build();
            }
            if (o instanceof Type.UserDefined) {
                Type.UserDefined t = (Type.UserDefined)o;
                return bldr.setUserDefined(t).build();
            }
            throw new UnsupportedOperationException("Unable to wrap type of " + o.getClass());
        }

        @Override
        protected Integer i(int integerValue) {
            return integerValue;
        }
    }
}

