/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.FieldReference;
import io.substrait.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FieldReference", generator="Immutables")
@Immutable
public final class ImmutableFieldReference
extends FieldReference {
    private final List<FieldReference.ReferenceSegment> segments;
    private final Type type;
    @Nullable
    private final Expression inputExpression;
    @Nullable
    private final Integer outerReferenceStepsOut;

    private ImmutableFieldReference(List<FieldReference.ReferenceSegment> segments, Type type, @Nullable Expression inputExpression, @Nullable Integer outerReferenceStepsOut) {
        this.segments = segments;
        this.type = type;
        this.inputExpression = inputExpression;
        this.outerReferenceStepsOut = outerReferenceStepsOut;
    }

    @Override
    public List<FieldReference.ReferenceSegment> segments() {
        return this.segments;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public Optional<Expression> inputExpression() {
        return Optional.ofNullable(this.inputExpression);
    }

    @Override
    public Optional<Integer> outerReferenceStepsOut() {
        return Optional.ofNullable(this.outerReferenceStepsOut);
    }

    public final ImmutableFieldReference withSegments(FieldReference.ReferenceSegment ... elements) {
        List<FieldReference.ReferenceSegment> newValue = ImmutableFieldReference.createUnmodifiableList(false, ImmutableFieldReference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFieldReference(newValue, this.type, this.inputExpression, this.outerReferenceStepsOut);
    }

    public final ImmutableFieldReference withSegments(Iterable<? extends FieldReference.ReferenceSegment> elements) {
        if (this.segments == elements) {
            return this;
        }
        List<FieldReference.ReferenceSegment> newValue = ImmutableFieldReference.createUnmodifiableList(false, ImmutableFieldReference.createSafeList(elements, true, false));
        return new ImmutableFieldReference(newValue, this.type, this.inputExpression, this.outerReferenceStepsOut);
    }

    public final ImmutableFieldReference withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "type");
        return new ImmutableFieldReference(this.segments, newValue, this.inputExpression, this.outerReferenceStepsOut);
    }

    public final ImmutableFieldReference withInputExpression(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "inputExpression");
        if (this.inputExpression == newValue) {
            return this;
        }
        return new ImmutableFieldReference(this.segments, this.type, newValue, this.outerReferenceStepsOut);
    }

    public final ImmutableFieldReference withInputExpression(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.inputExpression == value) {
            return this;
        }
        return new ImmutableFieldReference(this.segments, this.type, value, this.outerReferenceStepsOut);
    }

    public final ImmutableFieldReference withOuterReferenceStepsOut(int value) {
        Integer newValue = value;
        if (Objects.equals(this.outerReferenceStepsOut, newValue)) {
            return this;
        }
        return new ImmutableFieldReference(this.segments, this.type, this.inputExpression, newValue);
    }

    public final ImmutableFieldReference withOuterReferenceStepsOut(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.outerReferenceStepsOut, value)) {
            return this;
        }
        return new ImmutableFieldReference(this.segments, this.type, this.inputExpression, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldReference && this.equalTo((ImmutableFieldReference)another);
    }

    private boolean equalTo(ImmutableFieldReference another) {
        return this.segments.equals(another.segments) && this.type.equals(another.type) && Objects.equals(this.inputExpression, another.inputExpression) && Objects.equals(this.outerReferenceStepsOut, another.outerReferenceStepsOut);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.segments.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.inputExpression);
        h += (h << 5) + Objects.hashCode(this.outerReferenceStepsOut);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FieldReference{");
        builder.append("segments=").append(this.segments);
        builder.append(", ");
        builder.append("type=").append(this.type);
        if (this.inputExpression != null) {
            builder.append(", ");
            builder.append("inputExpression=").append(this.inputExpression);
        }
        if (this.outerReferenceStepsOut != null) {
            builder.append(", ");
            builder.append("outerReferenceStepsOut=").append(this.outerReferenceStepsOut);
        }
        return builder.append("}").toString();
    }

    public static ImmutableFieldReference copyOf(FieldReference instance) {
        if (instance instanceof ImmutableFieldReference) {
            return (ImmutableFieldReference)instance;
        }
        return ImmutableFieldReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FieldReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private List<FieldReference.ReferenceSegment> segments = new ArrayList<FieldReference.ReferenceSegment>();
        @Nullable
        private Type type;
        @Nullable
        private Expression inputExpression;
        @Nullable
        private Integer outerReferenceStepsOut;

        private Builder() {
        }

        public final Builder from(FieldReference instance) {
            Optional<Integer> outerReferenceStepsOutOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllSegments(instance.segments());
            this.type(instance.type());
            Optional<Expression> inputExpressionOptional = instance.inputExpression();
            if (inputExpressionOptional.isPresent()) {
                this.inputExpression(inputExpressionOptional);
            }
            if ((outerReferenceStepsOutOptional = instance.outerReferenceStepsOut()).isPresent()) {
                this.outerReferenceStepsOut(outerReferenceStepsOutOptional);
            }
            return this;
        }

        public final Builder addSegments(FieldReference.ReferenceSegment element) {
            this.segments.add(Objects.requireNonNull(element, "segments element"));
            return this;
        }

        public final Builder addSegments(FieldReference.ReferenceSegment ... elements) {
            for (FieldReference.ReferenceSegment element : elements) {
                this.segments.add(Objects.requireNonNull(element, "segments element"));
            }
            return this;
        }

        public final Builder segments(Iterable<? extends FieldReference.ReferenceSegment> elements) {
            this.segments.clear();
            return this.addAllSegments(elements);
        }

        public final Builder addAllSegments(Iterable<? extends FieldReference.ReferenceSegment> elements) {
            for (FieldReference.ReferenceSegment referenceSegment : elements) {
                this.segments.add(Objects.requireNonNull(referenceSegment, "segments element"));
            }
            return this;
        }

        public final Builder type(Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder inputExpression(Expression inputExpression) {
            this.inputExpression = Objects.requireNonNull(inputExpression, "inputExpression");
            return this;
        }

        public final Builder inputExpression(Optional<? extends Expression> inputExpression) {
            this.inputExpression = inputExpression.orElse(null);
            return this;
        }

        public final Builder outerReferenceStepsOut(int outerReferenceStepsOut) {
            this.outerReferenceStepsOut = outerReferenceStepsOut;
            return this;
        }

        public final Builder outerReferenceStepsOut(Optional<Integer> outerReferenceStepsOut) {
            this.outerReferenceStepsOut = outerReferenceStepsOut.orElse(null);
            return this;
        }

        public ImmutableFieldReference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFieldReference(ImmutableFieldReference.createUnmodifiableList(true, this.segments), this.type, this.inputExpression, this.outerReferenceStepsOut);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build FieldReference, some of required attributes are not set " + attributes;
        }
    }
}

