/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression;

import io.substrait.expression.Expression;
import org.immutables.value.Value;

@Value.Enclosing
public interface WindowBound {
    public BoundedKind boundedKind();

    @Value.Immutable
    public static class CurrentRowWindowBound
    implements WindowBound {
        @Override
        public BoundedKind boundedKind() {
            return BoundedKind.CURRENT_ROW;
        }
    }

    @Value.Immutable
    public static abstract class BoundedWindowBound
    implements WindowBound {
        @Override
        public BoundedKind boundedKind() {
            return BoundedKind.UNBOUNDED;
        }

        public abstract Direction direction();

        public abstract Expression offset();
    }

    @Value.Immutable
    public static abstract class UnboundedWindowBound
    implements WindowBound {
        @Override
        public BoundedKind boundedKind() {
            return BoundedKind.UNBOUNDED;
        }

        public abstract Direction direction();
    }

    public static enum Direction {
        PRECEDING,
        FOLLOWING;

    }

    public static enum BoundedKind {
        UNBOUNDED,
        BOUNDED,
        CURRENT_ROW;

    }
}

