/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression.proto;

import io.substrait.expression.proto.AbstractFunctionLookup;
import io.substrait.function.SimpleExtension;
import io.substrait.proto.Plan;
import io.substrait.proto.SimpleExtensionDeclaration;
import io.substrait.proto.SimpleExtensionURI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionCollector
extends AbstractFunctionLookup {
    static final Logger logger = LoggerFactory.getLogger(FunctionCollector.class);
    private final BidiMap<Integer, SimpleExtension.FunctionAnchor> funcMap = new BidiMap(this.map);
    private final BidiMap<Integer, String> uriMap = new BidiMap(new HashMap());
    private int counter = -1;

    public FunctionCollector() {
        super(new HashMap<Integer, SimpleExtension.FunctionAnchor>());
    }

    public int getFunctionReference(SimpleExtension.Function declaration) {
        Integer i = this.funcMap.reverseGet(declaration.getAnchor());
        if (i != null) {
            return i;
        }
        ++this.counter;
        this.funcMap.put(this.counter, declaration.getAnchor());
        return this.counter;
    }

    public void addFunctionsToPlan(Plan.Builder builder) {
        AtomicInteger uriPos = new AtomicInteger(1);
        HashMap<String, SimpleExtensionURI> uris = new HashMap<String, SimpleExtensionURI>();
        ArrayList<SimpleExtensionDeclaration> extensionList = new ArrayList<SimpleExtensionDeclaration>();
        for (Map.Entry e : ((BidiMap)this.funcMap).forwardMap.entrySet()) {
            SimpleExtensionURI uri = uris.computeIfAbsent(((SimpleExtension.FunctionAnchor)e.getValue()).namespace(), k -> SimpleExtensionURI.newBuilder().setExtensionUriAnchor(uriPos.getAndIncrement()).setUri((String)k).build());
            SimpleExtensionDeclaration decl = SimpleExtensionDeclaration.newBuilder().setExtensionFunction(SimpleExtensionDeclaration.ExtensionFunction.newBuilder().setFunctionAnchor((Integer)e.getKey()).setName(((SimpleExtension.FunctionAnchor)e.getValue()).key()).setExtensionUriReference(uri.getExtensionUriAnchor())).build();
            extensionList.add(decl);
        }
        builder.addAllExtensionUris(uris.values());
        builder.addAllExtensions(extensionList);
    }

    private static class BidiMap<T1, T2> {
        private final Map<T1, T2> forwardMap;
        private final Map<T2, T1> reverseMap;

        public BidiMap(Map<T1, T2> forwardMap) {
            this.forwardMap = forwardMap;
            this.reverseMap = new HashMap<T2, T1>();
        }

        public T2 get(T1 t1) {
            return this.forwardMap.get(t1);
        }

        public T1 reverseGet(T2 t2) {
            return this.reverseMap.get(t2);
        }

        public void put(T1 t1, T2 t2) {
            this.forwardMap.put(t1, t2);
            this.reverseMap.put(t2, t1);
        }
    }
}

