/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression.proto;

import io.substrait.expression.proto.AbstractFunctionLookup;
import io.substrait.function.SimpleExtension;
import io.substrait.proto.Plan;
import io.substrait.proto.SimpleExtensionDeclaration;
import io.substrait.proto.SimpleExtensionURI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableFunctionLookup
extends AbstractFunctionLookup {
    static final Logger logger = LoggerFactory.getLogger(ImmutableFunctionLookup.class);
    private int counter = -1;

    private ImmutableFunctionLookup(Map<Integer, SimpleExtension.FunctionAnchor> map) {
        super(map);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Integer, SimpleExtension.FunctionAnchor> map = new HashMap<Integer, SimpleExtension.FunctionAnchor>();

        public Builder from(Plan p) {
            HashMap<Integer, String> namespaceMap = new HashMap<Integer, String>();
            for (SimpleExtensionURI simpleExtensionURI : p.getExtensionUrisList()) {
                namespaceMap.put(simpleExtensionURI.getExtensionUriAnchor(), simpleExtensionURI.getUri());
            }
            for (SimpleExtensionDeclaration simpleExtensionDeclaration : p.getExtensionsList()) {
                SimpleExtensionDeclaration.ExtensionFunction func = simpleExtensionDeclaration.getExtensionFunction();
                int reference = func.getFunctionAnchor();
                String namespace = (String)namespaceMap.get(func.getExtensionUriReference());
                if (namespace == null) {
                    throw new IllegalStateException("Could not find extension URI of " + func.getExtensionUriReference());
                }
                String name = func.getName();
                SimpleExtension.FunctionAnchor anchor = SimpleExtension.FunctionAnchor.of(namespace, name);
                this.map.put(reference, anchor);
            }
            return this;
        }

        public ImmutableFunctionLookup build() {
            return new ImmutableFunctionLookup(Collections.unmodifiableMap(this.map));
        }
    }
}

