/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.function;

import io.substrait.function.NullableType;
import io.substrait.function.TypeExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TypeExpression", generator="Immutables")
public final class ImmutableTypeExpression {
    private ImmutableTypeExpression() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="TypeExpression.ReturnProgram.Assignment", generator="Immutables")
    @Immutable
    public static final class Assignment
    extends TypeExpression.ReturnProgram.Assignment {
        private final String name;
        private final TypeExpression expr;

        private Assignment(String name, TypeExpression expr) {
            this.name = name;
            this.expr = expr;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public TypeExpression expr() {
            return this.expr;
        }

        public final Assignment withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Assignment(newValue, this.expr);
        }

        public final Assignment withExpr(TypeExpression value) {
            if (this.expr == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "expr");
            return new Assignment(this.name, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Assignment && this.equalTo((Assignment)another);
        }

        private boolean equalTo(Assignment another) {
            return this.name.equals(another.name) && this.expr.equals(another.expr);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.expr.hashCode();
            return h;
        }

        public String toString() {
            return "Assignment{name=" + this.name + ", expr=" + this.expr + "}";
        }

        public static Assignment copyOf(TypeExpression.ReturnProgram.Assignment instance) {
            if (instance instanceof Assignment) {
                return (Assignment)instance;
            }
            return Assignment.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.ReturnProgram.Assignment", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_EXPR = 2L;
            private long initBits = 3L;
            @Nullable
            private String name;
            @Nullable
            private TypeExpression expr;

            private Builder() {
            }

            public final Builder from(TypeExpression.ReturnProgram.Assignment instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                this.expr(instance.expr());
                return this;
            }

            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder expr(TypeExpression expr) {
                this.expr = Objects.requireNonNull(expr, "expr");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public Assignment build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Assignment(this.name, this.expr);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("expr");
                }
                return "Cannot build Assignment, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.ReturnProgram", generator="Immutables")
    @Immutable
    public static final class ReturnProgram
    extends TypeExpression.ReturnProgram {
        private final List<TypeExpression.ReturnProgram.Assignment> assignments;
        private final TypeExpression finalExpression;

        private ReturnProgram(List<TypeExpression.ReturnProgram.Assignment> assignments, TypeExpression finalExpression) {
            this.assignments = assignments;
            this.finalExpression = finalExpression;
        }

        @Override
        public List<TypeExpression.ReturnProgram.Assignment> assignments() {
            return this.assignments;
        }

        @Override
        public TypeExpression finalExpression() {
            return this.finalExpression;
        }

        public final ReturnProgram withAssignments(TypeExpression.ReturnProgram.Assignment ... elements) {
            List newValue = ImmutableTypeExpression.createUnmodifiableList(false, ImmutableTypeExpression.createSafeList(Arrays.asList(elements), true, false));
            return new ReturnProgram(newValue, this.finalExpression);
        }

        public final ReturnProgram withAssignments(Iterable<? extends TypeExpression.ReturnProgram.Assignment> elements) {
            if (this.assignments == elements) {
                return this;
            }
            List newValue = ImmutableTypeExpression.createUnmodifiableList(false, ImmutableTypeExpression.createSafeList(elements, true, false));
            return new ReturnProgram(newValue, this.finalExpression);
        }

        public final ReturnProgram withFinalExpression(TypeExpression value) {
            if (this.finalExpression == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "finalExpression");
            return new ReturnProgram(this.assignments, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ReturnProgram && this.equalTo((ReturnProgram)another);
        }

        private boolean equalTo(ReturnProgram another) {
            return this.assignments.equals(another.assignments) && this.finalExpression.equals(another.finalExpression);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.assignments.hashCode();
            h += (h << 5) + this.finalExpression.hashCode();
            return h;
        }

        public String toString() {
            return "ReturnProgram{assignments=" + this.assignments + ", finalExpression=" + this.finalExpression + "}";
        }

        public static ReturnProgram copyOf(TypeExpression.ReturnProgram instance) {
            if (instance instanceof ReturnProgram) {
                return (ReturnProgram)instance;
            }
            return ReturnProgram.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.ReturnProgram", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_FINAL_EXPRESSION = 1L;
            private long initBits = 1L;
            private List<TypeExpression.ReturnProgram.Assignment> assignments = new ArrayList<TypeExpression.ReturnProgram.Assignment>();
            @Nullable
            private TypeExpression finalExpression;

            private Builder() {
            }

            public final Builder from(TypeExpression.ReturnProgram instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllAssignments(instance.assignments());
                this.finalExpression(instance.finalExpression());
                return this;
            }

            public final Builder addAssignments(TypeExpression.ReturnProgram.Assignment element) {
                this.assignments.add(Objects.requireNonNull(element, "assignments element"));
                return this;
            }

            public final Builder addAssignments(TypeExpression.ReturnProgram.Assignment ... elements) {
                for (TypeExpression.ReturnProgram.Assignment element : elements) {
                    this.assignments.add(Objects.requireNonNull(element, "assignments element"));
                }
                return this;
            }

            public final Builder assignments(Iterable<? extends TypeExpression.ReturnProgram.Assignment> elements) {
                this.assignments.clear();
                return this.addAllAssignments(elements);
            }

            public final Builder addAllAssignments(Iterable<? extends TypeExpression.ReturnProgram.Assignment> elements) {
                for (TypeExpression.ReturnProgram.Assignment assignment : elements) {
                    this.assignments.add(Objects.requireNonNull(assignment, "assignments element"));
                }
                return this;
            }

            public final Builder finalExpression(TypeExpression finalExpression) {
                this.finalExpression = Objects.requireNonNull(finalExpression, "finalExpression");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ReturnProgram build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ReturnProgram(ImmutableTypeExpression.createUnmodifiableList(true, this.assignments), this.finalExpression);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("finalExpression");
                }
                return "Cannot build ReturnProgram, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.IntegerLiteral", generator="Immutables")
    @Immutable
    public static final class IntegerLiteral
    extends TypeExpression.IntegerLiteral {
        private final int value;

        private IntegerLiteral(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }

        public final IntegerLiteral withValue(int value) {
            if (this.value == value) {
                return this;
            }
            return new IntegerLiteral(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntegerLiteral && this.equalTo((IntegerLiteral)another);
        }

        private boolean equalTo(IntegerLiteral another) {
            return this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.value;
            return h;
        }

        public String toString() {
            return "IntegerLiteral{value=" + this.value + "}";
        }

        public static IntegerLiteral copyOf(TypeExpression.IntegerLiteral instance) {
            if (instance instanceof IntegerLiteral) {
                return (IntegerLiteral)instance;
            }
            return IntegerLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.IntegerLiteral", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private long initBits = 1L;
            private int value;

            private Builder() {
            }

            public final Builder from(TypeExpression.IntegerLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.value(instance.value());
                return this;
            }

            public final Builder value(int value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IntegerLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntegerLiteral(this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build IntegerLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.IfOperation", generator="Immutables")
    @Immutable
    public static final class IfOperation
    extends TypeExpression.IfOperation {
        private final TypeExpression ifCondition;
        private final TypeExpression thenExpr;
        private final TypeExpression elseExpr;

        private IfOperation(TypeExpression ifCondition, TypeExpression thenExpr, TypeExpression elseExpr) {
            this.ifCondition = ifCondition;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
        }

        @Override
        public TypeExpression ifCondition() {
            return this.ifCondition;
        }

        @Override
        public TypeExpression thenExpr() {
            return this.thenExpr;
        }

        @Override
        public TypeExpression elseExpr() {
            return this.elseExpr;
        }

        public final IfOperation withIfCondition(TypeExpression value) {
            if (this.ifCondition == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "ifCondition");
            return new IfOperation(newValue, this.thenExpr, this.elseExpr);
        }

        public final IfOperation withThenExpr(TypeExpression value) {
            if (this.thenExpr == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "thenExpr");
            return new IfOperation(this.ifCondition, newValue, this.elseExpr);
        }

        public final IfOperation withElseExpr(TypeExpression value) {
            if (this.elseExpr == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "elseExpr");
            return new IfOperation(this.ifCondition, this.thenExpr, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IfOperation && this.equalTo((IfOperation)another);
        }

        private boolean equalTo(IfOperation another) {
            return this.ifCondition.equals(another.ifCondition) && this.thenExpr.equals(another.thenExpr) && this.elseExpr.equals(another.elseExpr);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.ifCondition.hashCode();
            h += (h << 5) + this.thenExpr.hashCode();
            h += (h << 5) + this.elseExpr.hashCode();
            return h;
        }

        public String toString() {
            return "IfOperation{ifCondition=" + this.ifCondition + ", thenExpr=" + this.thenExpr + ", elseExpr=" + this.elseExpr + "}";
        }

        public static IfOperation copyOf(TypeExpression.IfOperation instance) {
            if (instance instanceof IfOperation) {
                return (IfOperation)instance;
            }
            return IfOperation.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.IfOperation", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_IF_CONDITION = 1L;
            private static final long INIT_BIT_THEN_EXPR = 2L;
            private static final long INIT_BIT_ELSE_EXPR = 4L;
            private long initBits = 7L;
            @Nullable
            private TypeExpression ifCondition;
            @Nullable
            private TypeExpression thenExpr;
            @Nullable
            private TypeExpression elseExpr;

            private Builder() {
            }

            public final Builder from(TypeExpression.IfOperation instance) {
                Objects.requireNonNull(instance, "instance");
                this.ifCondition(instance.ifCondition());
                this.thenExpr(instance.thenExpr());
                this.elseExpr(instance.elseExpr());
                return this;
            }

            public final Builder ifCondition(TypeExpression ifCondition) {
                this.ifCondition = Objects.requireNonNull(ifCondition, "ifCondition");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder thenExpr(TypeExpression thenExpr) {
                this.thenExpr = Objects.requireNonNull(thenExpr, "thenExpr");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder elseExpr(TypeExpression elseExpr) {
                this.elseExpr = Objects.requireNonNull(elseExpr, "elseExpr");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public IfOperation build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IfOperation(this.ifCondition, this.thenExpr, this.elseExpr);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("ifCondition");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("thenExpr");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("elseExpr");
                }
                return "Cannot build IfOperation, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.NotOperation", generator="Immutables")
    @Immutable
    public static final class NotOperation
    extends TypeExpression.NotOperation {
        private final TypeExpression inner;

        private NotOperation(TypeExpression inner) {
            this.inner = inner;
        }

        @Override
        public TypeExpression inner() {
            return this.inner;
        }

        public final NotOperation withInner(TypeExpression value) {
            if (this.inner == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "inner");
            return new NotOperation(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof NotOperation && this.equalTo((NotOperation)another);
        }

        private boolean equalTo(NotOperation another) {
            return this.inner.equals(another.inner);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.inner.hashCode();
            return h;
        }

        public String toString() {
            return "NotOperation{inner=" + this.inner + "}";
        }

        public static NotOperation copyOf(TypeExpression.NotOperation instance) {
            if (instance instanceof NotOperation) {
                return (NotOperation)instance;
            }
            return NotOperation.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.NotOperation", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_INNER = 1L;
            private long initBits = 1L;
            @Nullable
            private TypeExpression inner;

            private Builder() {
            }

            public final Builder from(TypeExpression.NotOperation instance) {
                Objects.requireNonNull(instance, "instance");
                this.inner(instance.inner());
                return this;
            }

            public final Builder inner(TypeExpression inner) {
                this.inner = Objects.requireNonNull(inner, "inner");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public NotOperation build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new NotOperation(this.inner);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("inner");
                }
                return "Cannot build NotOperation, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.BinaryOperation", generator="Immutables")
    @Immutable
    public static final class BinaryOperation
    extends TypeExpression.BinaryOperation {
        private final TypeExpression.BinaryOperation.OpType opType;
        private final TypeExpression left;
        private final TypeExpression right;

        private BinaryOperation(TypeExpression.BinaryOperation.OpType opType, TypeExpression left, TypeExpression right) {
            this.opType = opType;
            this.left = left;
            this.right = right;
        }

        @Override
        public TypeExpression.BinaryOperation.OpType opType() {
            return this.opType;
        }

        @Override
        public TypeExpression left() {
            return this.left;
        }

        @Override
        public TypeExpression right() {
            return this.right;
        }

        public final BinaryOperation withOpType(TypeExpression.BinaryOperation.OpType value) {
            if (this.opType == value) {
                return this;
            }
            TypeExpression.BinaryOperation.OpType newValue = Objects.requireNonNull(value, "opType");
            if (this.opType.equals((Object)newValue)) {
                return this;
            }
            return new BinaryOperation(newValue, this.left, this.right);
        }

        public final BinaryOperation withLeft(TypeExpression value) {
            if (this.left == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "left");
            return new BinaryOperation(this.opType, newValue, this.right);
        }

        public final BinaryOperation withRight(TypeExpression value) {
            if (this.right == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "right");
            return new BinaryOperation(this.opType, this.left, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof BinaryOperation && this.equalTo((BinaryOperation)another);
        }

        private boolean equalTo(BinaryOperation another) {
            return this.opType.equals((Object)another.opType) && this.left.equals(another.left) && this.right.equals(another.right);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.opType.hashCode();
            h += (h << 5) + this.left.hashCode();
            h += (h << 5) + this.right.hashCode();
            return h;
        }

        public String toString() {
            return "BinaryOperation{opType=" + (Object)((Object)this.opType) + ", left=" + this.left + ", right=" + this.right + "}";
        }

        public static BinaryOperation copyOf(TypeExpression.BinaryOperation instance) {
            if (instance instanceof BinaryOperation) {
                return (BinaryOperation)instance;
            }
            return BinaryOperation.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.BinaryOperation", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_OP_TYPE = 1L;
            private static final long INIT_BIT_LEFT = 2L;
            private static final long INIT_BIT_RIGHT = 4L;
            private long initBits = 7L;
            @Nullable
            private TypeExpression.BinaryOperation.OpType opType;
            @Nullable
            private TypeExpression left;
            @Nullable
            private TypeExpression right;

            private Builder() {
            }

            public final Builder from(TypeExpression.BinaryOperation instance) {
                Objects.requireNonNull(instance, "instance");
                this.opType(instance.opType());
                this.left(instance.left());
                this.right(instance.right());
                return this;
            }

            public final Builder opType(TypeExpression.BinaryOperation.OpType opType) {
                this.opType = Objects.requireNonNull(opType, "opType");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder left(TypeExpression left) {
                this.left = Objects.requireNonNull(left, "left");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder right(TypeExpression right) {
                this.right = Objects.requireNonNull(right, "right");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public BinaryOperation build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new BinaryOperation(this.opType, this.left, this.right);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("opType");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("left");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("right");
                }
                return "Cannot build BinaryOperation, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.Map", generator="Immutables")
    @Immutable
    public static final class Map
    extends TypeExpression.Map {
        private final boolean nullable;
        private final TypeExpression key;
        private final TypeExpression value;

        private Map(boolean nullable, TypeExpression key, TypeExpression value) {
            this.nullable = nullable;
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public TypeExpression key() {
            return this.key;
        }

        @Override
        public TypeExpression value() {
            return this.value;
        }

        public final Map withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Map(value, this.key, this.value);
        }

        public final Map withKey(TypeExpression value) {
            if (this.key == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "key");
            return new Map(this.nullable, newValue, this.value);
        }

        public final Map withValue(TypeExpression value) {
            if (this.value == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "value");
            return new Map(this.nullable, this.key, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Map && this.equalTo((Map)another);
        }

        private boolean equalTo(Map another) {
            return this.nullable == another.nullable && this.key.equals(another.key) && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.key.hashCode();
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "Map{nullable=" + this.nullable + ", key=" + this.key + ", value=" + this.value + "}";
        }

        public static Map copyOf(TypeExpression.Map instance) {
            if (instance instanceof Map) {
                return (Map)instance;
            }
            return Map.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.Map", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_KEY = 2L;
            private static final long INIT_BIT_VALUE = 4L;
            private long initBits = 7L;
            private boolean nullable;
            @Nullable
            private TypeExpression key;
            @Nullable
            private TypeExpression value;

            private Builder() {
            }

            public final Builder from(TypeExpression.Map instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof TypeExpression.Map) {
                    instance = (TypeExpression.Map)object;
                    this.value(((TypeExpression.Map)instance).value());
                    this.key(((TypeExpression.Map)instance).key());
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder key(TypeExpression key) {
                this.key = Objects.requireNonNull(key, "key");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder value(TypeExpression value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Map build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Map(this.nullable, this.key, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("key");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build Map, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.ListType", generator="Immutables")
    @Immutable
    public static final class ListType
    extends TypeExpression.ListType {
        private final boolean nullable;
        private final TypeExpression elementType;

        private ListType(boolean nullable, TypeExpression elementType) {
            this.nullable = nullable;
            this.elementType = elementType;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public TypeExpression elementType() {
            return this.elementType;
        }

        public final ListType withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new ListType(value, this.elementType);
        }

        public final ListType withElementType(TypeExpression value) {
            if (this.elementType == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "elementType");
            return new ListType(this.nullable, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ListType && this.equalTo((ListType)another);
        }

        private boolean equalTo(ListType another) {
            return this.nullable == another.nullable && this.elementType.equals(another.elementType);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.elementType.hashCode();
            return h;
        }

        public String toString() {
            return "ListType{nullable=" + this.nullable + ", elementType=" + this.elementType + "}";
        }

        public static ListType copyOf(TypeExpression.ListType instance) {
            if (instance instanceof ListType) {
                return (ListType)instance;
            }
            return ListType.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.ListType", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_ELEMENT_TYPE = 2L;
            private long initBits = 3L;
            private boolean nullable;
            @Nullable
            private TypeExpression elementType;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(TypeExpression.ListType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof TypeExpression.ListType) {
                    instance = (TypeExpression.ListType)object;
                    this.elementType(((TypeExpression.ListType)instance).elementType());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder elementType(TypeExpression elementType) {
                this.elementType = Objects.requireNonNull(elementType, "elementType");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public ListType build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ListType(this.nullable, this.elementType);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("elementType");
                }
                return "Cannot build ListType, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.Struct", generator="Immutables")
    @Immutable
    public static final class Struct
    extends TypeExpression.Struct {
        private final boolean nullable;
        private final List<TypeExpression> fields;

        private Struct(boolean nullable, List<TypeExpression> fields) {
            this.nullable = nullable;
            this.fields = fields;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public List<TypeExpression> fields() {
            return this.fields;
        }

        public final Struct withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Struct(value, this.fields);
        }

        public final Struct withFields(TypeExpression ... elements) {
            List newValue = ImmutableTypeExpression.createUnmodifiableList(false, ImmutableTypeExpression.createSafeList(Arrays.asList(elements), true, false));
            return new Struct(this.nullable, newValue);
        }

        public final Struct withFields(Iterable<? extends TypeExpression> elements) {
            if (this.fields == elements) {
                return this;
            }
            List newValue = ImmutableTypeExpression.createUnmodifiableList(false, ImmutableTypeExpression.createSafeList(elements, true, false));
            return new Struct(this.nullable, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Struct && this.equalTo((Struct)another);
        }

        private boolean equalTo(Struct another) {
            return this.nullable == another.nullable && this.fields.equals(another.fields);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.fields.hashCode();
            return h;
        }

        public String toString() {
            return "Struct{nullable=" + this.nullable + ", fields=" + this.fields + "}";
        }

        public static Struct copyOf(TypeExpression.Struct instance) {
            if (instance instanceof Struct) {
                return (Struct)instance;
            }
            return Struct.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.Struct", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;
            private List<TypeExpression> fields = new ArrayList<TypeExpression>();

            private Builder() {
            }

            public final Builder from(TypeExpression.Struct instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof TypeExpression.Struct) {
                    instance = (TypeExpression.Struct)object;
                    this.addAllFields(((TypeExpression.Struct)instance).fields());
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addFields(TypeExpression element) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
                return this;
            }

            public final Builder addFields(TypeExpression ... elements) {
                for (TypeExpression element : elements) {
                    this.fields.add(Objects.requireNonNull(element, "fields element"));
                }
                return this;
            }

            public final Builder fields(Iterable<? extends TypeExpression> elements) {
                this.fields.clear();
                return this.addAllFields(elements);
            }

            public final Builder addAllFields(Iterable<? extends TypeExpression> elements) {
                for (TypeExpression typeExpression : elements) {
                    this.fields.add(Objects.requireNonNull(typeExpression, "fields element"));
                }
                return this;
            }

            public Struct build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Struct(this.nullable, ImmutableTypeExpression.createUnmodifiableList(true, this.fields));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Struct, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.Decimal", generator="Immutables")
    @Immutable
    public static final class Decimal
    extends TypeExpression.Decimal {
        private final boolean nullable;
        private final TypeExpression scale;
        private final TypeExpression precision;

        private Decimal(boolean nullable, TypeExpression scale, TypeExpression precision) {
            this.nullable = nullable;
            this.scale = scale;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public TypeExpression scale() {
            return this.scale;
        }

        @Override
        public TypeExpression precision() {
            return this.precision;
        }

        public final Decimal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Decimal(value, this.scale, this.precision);
        }

        public final Decimal withScale(TypeExpression value) {
            if (this.scale == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "scale");
            return new Decimal(this.nullable, newValue, this.precision);
        }

        public final Decimal withPrecision(TypeExpression value) {
            if (this.precision == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "precision");
            return new Decimal(this.nullable, this.scale, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Decimal && this.equalTo((Decimal)another);
        }

        private boolean equalTo(Decimal another) {
            return this.nullable == another.nullable && this.scale.equals(another.scale) && this.precision.equals(another.precision);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.scale.hashCode();
            h += (h << 5) + this.precision.hashCode();
            return h;
        }

        public String toString() {
            return "Decimal{nullable=" + this.nullable + ", scale=" + this.scale + ", precision=" + this.precision + "}";
        }

        public static Decimal copyOf(TypeExpression.Decimal instance) {
            if (instance instanceof Decimal) {
                return (Decimal)instance;
            }
            return Decimal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.Decimal", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_SCALE = 2L;
            private static final long INIT_BIT_PRECISION = 4L;
            private long initBits = 7L;
            private boolean nullable;
            @Nullable
            private TypeExpression scale;
            @Nullable
            private TypeExpression precision;

            private Builder() {
            }

            public final Builder from(TypeExpression.Decimal instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof TypeExpression.Decimal) {
                    instance = (TypeExpression.Decimal)object;
                    this.scale(((TypeExpression.Decimal)instance).scale());
                    this.precision(((TypeExpression.Decimal)instance).precision());
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder scale(TypeExpression scale) {
                this.scale = Objects.requireNonNull(scale, "scale");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder precision(TypeExpression precision) {
                this.precision = Objects.requireNonNull(precision, "precision");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Decimal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Decimal(this.nullable, this.scale, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("scale");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build Decimal, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.FixedBinary", generator="Immutables")
    @Immutable
    public static final class FixedBinary
    extends TypeExpression.FixedBinary {
        private final boolean nullable;
        private final TypeExpression length;

        private FixedBinary(boolean nullable, TypeExpression length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public TypeExpression length() {
            return this.length;
        }

        public final FixedBinary withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedBinary(value, this.length);
        }

        public final FixedBinary withLength(TypeExpression value) {
            if (this.length == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "length");
            return new FixedBinary(this.nullable, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedBinary && this.equalTo((FixedBinary)another);
        }

        private boolean equalTo(FixedBinary another) {
            return this.nullable == another.nullable && this.length.equals(another.length);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length.hashCode();
            return h;
        }

        public String toString() {
            return "FixedBinary{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static FixedBinary copyOf(TypeExpression.FixedBinary instance) {
            if (instance instanceof FixedBinary) {
                return (FixedBinary)instance;
            }
            return FixedBinary.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.FixedBinary", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            @Nullable
            private TypeExpression length;

            private Builder() {
            }

            public final Builder from(TypeExpression.FixedBinary instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof TypeExpression.FixedBinary) {
                    instance = (TypeExpression.FixedBinary)object;
                    this.length(((TypeExpression.FixedBinary)instance).length());
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(TypeExpression length) {
                this.length = Objects.requireNonNull(length, "length");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FixedBinary build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedBinary(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build FixedBinary, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.VarChar", generator="Immutables")
    @Immutable
    public static final class VarChar
    extends TypeExpression.VarChar {
        private final boolean nullable;
        private final TypeExpression length;

        private VarChar(boolean nullable, TypeExpression length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public TypeExpression length() {
            return this.length;
        }

        public final VarChar withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new VarChar(value, this.length);
        }

        public final VarChar withLength(TypeExpression value) {
            if (this.length == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "length");
            return new VarChar(this.nullable, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof VarChar && this.equalTo((VarChar)another);
        }

        private boolean equalTo(VarChar another) {
            return this.nullable == another.nullable && this.length.equals(another.length);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length.hashCode();
            return h;
        }

        public String toString() {
            return "VarChar{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static VarChar copyOf(TypeExpression.VarChar instance) {
            if (instance instanceof VarChar) {
                return (VarChar)instance;
            }
            return VarChar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.VarChar", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            @Nullable
            private TypeExpression length;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(TypeExpression.VarChar instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof TypeExpression.VarChar) {
                    instance = (TypeExpression.VarChar)object;
                    this.length(((TypeExpression.VarChar)instance).length());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(TypeExpression length) {
                this.length = Objects.requireNonNull(length, "length");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public VarChar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new VarChar(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build VarChar, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="TypeExpression.FixedChar", generator="Immutables")
    @Immutable
    public static final class FixedChar
    extends TypeExpression.FixedChar {
        private final boolean nullable;
        private final TypeExpression length;

        private FixedChar(boolean nullable, TypeExpression length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public TypeExpression length() {
            return this.length;
        }

        public final FixedChar withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedChar(value, this.length);
        }

        public final FixedChar withLength(TypeExpression value) {
            if (this.length == value) {
                return this;
            }
            TypeExpression newValue = Objects.requireNonNull(value, "length");
            return new FixedChar(this.nullable, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedChar && this.equalTo((FixedChar)another);
        }

        private boolean equalTo(FixedChar another) {
            return this.nullable == another.nullable && this.length.equals(another.length);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length.hashCode();
            return h;
        }

        public String toString() {
            return "FixedChar{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static FixedChar copyOf(TypeExpression.FixedChar instance) {
            if (instance instanceof FixedChar) {
                return (FixedChar)instance;
            }
            return FixedChar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TypeExpression.FixedChar", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            @Nullable
            private TypeExpression length;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(TypeExpression.FixedChar instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof TypeExpression.FixedChar) {
                    instance = (TypeExpression.FixedChar)object;
                    this.length(((TypeExpression.FixedChar)instance).length());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(TypeExpression length) {
                this.length = Objects.requireNonNull(length, "length");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FixedChar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedChar(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build FixedChar, some of required attributes are not set " + attributes;
            }
        }
    }
}

