/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.substrait.expression.Expression;
import io.substrait.function.ImmutableSimpleExtension;
import io.substrait.function.ParameterizedType;
import io.substrait.function.ToTypeString;
import io.substrait.function.TypeExpression;
import io.substrait.type.Deserializers;
import io.substrait.type.Type;
import io.substrait.type.TypeExpressionEvaluator;
import io.substrait.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Enclosing
public class SimpleExtension {
    static final Logger logger = LoggerFactory.getLogger(SimpleExtension.class);
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).registerModule((Module)new Jdk8Module()).registerModule((Module)Deserializers.MODULE);

    private SimpleExtension() {
    }

    public static ExtensionCollection loadDefaults() throws IOException {
        List<String> defaultFiles = Arrays.asList("boolean", "aggregate_generic", "aggregate_approx", "arithmetic_decimal", "arithmetic", "comparison", "datetime", "string").stream().map(c -> String.format("/functions_%s.yaml", c)).collect(Collectors.toList());
        return SimpleExtension.load(defaultFiles);
    }

    public static ExtensionCollection load(List<String> resourcePaths) throws IOException {
        if (resourcePaths.isEmpty()) {
            throw new IllegalArgumentException("Require at least one resource path.");
        }
        List extensions = resourcePaths.stream().map(path -> {
            ExtensionCollection extensionCollection;
            block8: {
                InputStream stream = ExtensionCollection.class.getResourceAsStream((String)path);
                try {
                    extensionCollection = SimpleExtension.load(path, stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return extensionCollection;
        }).collect(Collectors.toList());
        ExtensionCollection complete = (ExtensionCollection)extensions.get(0);
        for (int i = 1; i < extensions.size(); ++i) {
            complete = complete.merge((ExtensionCollection)extensions.get(i));
        }
        return complete;
    }

    private static ExtensionCollection load(String namespace, InputStream stream) {
        try {
            FunctionSignatures doc = (FunctionSignatures)MAPPER.readValue(stream, FunctionSignatures.class);
            ImmutableSimpleExtension.ExtensionCollection collection = ImmutableSimpleExtension.ExtensionCollection.builder().addAllAggregateFunctions(doc.aggregates().stream().flatMap(t -> t.resolve(namespace)).collect(Collectors.toList())).addAllScalarFunctions(doc.scalars().stream().flatMap(t -> t.resolve(namespace)).collect(Collectors.toList())).addAllWindowFunctions(doc.windows().stream().flatMap(t -> t.resolve(namespace)).collect(Collectors.toList())).build();
            logger.debug("Loaded {} aggregate functions and {} scalar functions from {}.", new Object[]{collection.aggregateFunctions().size(), collection.scalarFunctions().size(), namespace});
            return collection;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure while parsing " + namespace, ex);
        }
    }

    @Value.Immutable
    public static abstract class ExtensionCollection {
        private final Supplier<Set<String>> namespaceSupplier = Util.memoize(() -> Stream.concat(Stream.concat(this.scalarFunctions().stream().map(Function::uri), this.aggregateFunctions().stream().map(Function::uri)), this.windowFunctions().stream().map(Function::uri)).collect(Collectors.toSet()));
        private final Supplier<Map<FunctionAnchor, ScalarFunctionVariant>> scalarFunctionsLookup = Util.memoize(() -> this.scalarFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));
        private final Supplier<Map<FunctionAnchor, AggregateFunctionVariant>> aggregateFunctionsLookup = Util.memoize(() -> this.aggregateFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));
        private final Supplier<Map<FunctionAnchor, WindowFunctionVariant>> windowFunctionsLookup = Util.memoize(() -> this.windowFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));

        public abstract List<ScalarFunctionVariant> scalarFunctions();

        public abstract List<AggregateFunctionVariant> aggregateFunctions();

        public abstract List<WindowFunctionVariant> windowFunctions();

        public ScalarFunctionVariant getScalarFunction(FunctionAnchor anchor) {
            ScalarFunctionVariant variant = this.scalarFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkNamespace(anchor.namespace());
            throw new IllegalArgumentException(String.format("Unexpected scalar function with key %s. The namespace %s is loaded but no scalar function with this key found.", anchor.key(), anchor.namespace()));
        }

        private void checkNamespace(String name) {
            if (this.namespaceSupplier.get().contains(name)) {
                return;
            }
            throw new IllegalArgumentException(String.format("Received a reference for extension %s but that extension is not currently loaded.", name));
        }

        public AggregateFunctionVariant getAggregateFunction(FunctionAnchor anchor) {
            AggregateFunctionVariant variant = this.aggregateFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkNamespace(anchor.namespace());
            throw new IllegalArgumentException(String.format("Unexpected aggregate function with key %s. The namespace %s is loaded but no aggregate function with this key was found.", anchor.key(), anchor.namespace()));
        }

        public WindowFunctionVariant getWindowFunction(FunctionAnchor anchor) {
            WindowFunctionVariant variant = this.windowFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkNamespace(anchor.namespace());
            throw new IllegalArgumentException(String.format("Unexpected window aggregate function with key %s. The namespace %s is loaded but no window aggregate function with this key was found.", anchor.key(), anchor.namespace()));
        }

        public ExtensionCollection merge(ExtensionCollection extensionCollection) {
            return ImmutableSimpleExtension.ExtensionCollection.builder().addAllAggregateFunctions(this.aggregateFunctions()).addAllAggregateFunctions(extensionCollection.aggregateFunctions()).addAllScalarFunctions(this.scalarFunctions()).addAllScalarFunctions(extensionCollection.scalarFunctions()).addAllWindowFunctions(this.windowFunctions()).addAllWindowFunctions(extensionCollection.windowFunctions()).build();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.FunctionSignatures.class)
    @JsonSerialize(as=ImmutableSimpleExtension.FunctionSignatures.class)
    @Value.Immutable
    public static abstract class FunctionSignatures {
        @JsonProperty(value="scalar_functions")
        public abstract List<ScalarFunction> scalars();

        @JsonProperty(value="aggregate_functions")
        public abstract List<AggregateFunction> aggregates();

        @JsonProperty(value="window_functions")
        public abstract List<WindowFunction> windows();

        public int size() {
            return (this.scalars() == null ? 0 : this.scalars().size()) + (this.aggregates() == null ? 0 : this.aggregates().size()) + (this.windows() == null ? 0 : this.windows().size());
        }

        public Stream<Function> resolve(String uri) {
            return Stream.concat(Stream.concat(this.scalars() == null ? Stream.of(new Function[0]) : this.scalars().stream().flatMap(f -> f.resolve(uri)), this.aggregates() == null ? Stream.of(new Function[0]) : this.aggregates().stream().flatMap(f -> f.resolve(uri))), this.windows() == null ? Stream.of(new Function[0]) : this.windows().stream().flatMap(f -> f.resolve(uri)));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.WindowFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.WindowFunction.class)
    @Value.Immutable
    public static abstract class WindowFunction {
        @Nullable
        public abstract String name();

        @Nullable
        public abstract String description();

        public abstract List<WindowFunctionVariant> impls();

        public Stream<WindowFunctionVariant> resolve(String uri) {
            return this.impls().stream().map(f -> f.resolve(uri, this.name(), this.description()));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.ScalarFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.ScalarFunction.class)
    @Value.Immutable
    public static abstract class ScalarFunction {
        public abstract String name();

        @Nullable
        public abstract String description();

        public abstract List<ScalarFunctionVariant> impls();

        Stream<ScalarFunctionVariant> resolve(String uri) {
            return this.impls().stream().map(f -> f.resolve(uri, this.name(), this.description()));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.AggregateFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.AggregateFunction.class)
    @Value.Immutable
    public static abstract class AggregateFunction {
        @Nullable
        public abstract String name();

        @Nullable
        public abstract String description();

        public abstract List<AggregateFunctionVariant> impls();

        public Stream<AggregateFunctionVariant> resolve(String uri) {
            return this.impls().stream().map(f -> f.resolve(uri, this.name(), this.description()));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.WindowFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.WindowFunctionVariant.class)
    @Value.Immutable
    public static abstract class WindowFunctionVariant
    extends Function {
        @JsonProperty(value="decomposable")
        @Value.Default
        public Decomposability decomposability() {
            return Decomposability.NONE;
        }

        @Nullable
        public abstract TypeExpression intermediate();

        @JsonProperty(value="window_type")
        @Value.Default
        public WindowType windowType() {
            return WindowType.PARTITION;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        WindowFunctionVariant resolve(String uri, String name, String description) {
            return ImmutableSimpleExtension.WindowFunctionVariant.builder().uri(uri).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).decomposability(this.decomposability()).intermediate(this.intermediate()).returnType(this.returnType()).windowType(this.windowType()).build();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.AggregateFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.AggregateFunctionVariant.class)
    @Value.Immutable
    public static abstract class AggregateFunctionVariant
    extends Function {
        @JsonProperty(value="decomposable")
        @Value.Default
        public Decomposability decomposability() {
            return Decomposability.NONE;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Nullable
        public abstract TypeExpression intermediate();

        AggregateFunctionVariant resolve(String uri, String name, String description) {
            return ImmutableSimpleExtension.AggregateFunctionVariant.builder().uri(uri).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).decomposability(this.decomposability()).intermediate(this.intermediate()).returnType(this.returnType()).build();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.ScalarFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.ScalarFunctionVariant.class)
    @Value.Immutable
    public static abstract class ScalarFunctionVariant
    extends Function {
        public ScalarFunctionVariant resolve(String uri, String name, String description) {
            return ImmutableSimpleExtension.ScalarFunctionVariant.builder().uri(uri).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).returnType(this.returnType()).build();
        }
    }

    public static abstract class Function {
        private final Supplier<FunctionAnchor> anchorSupplier = Util.memoize(() -> FunctionAnchor.of(this.uri(), this.key()));
        private final Supplier<String> keySupplier = Util.memoize(() -> Function.constructKey(this.name(), this.args()));
        private final Supplier<List<Argument>> requiredArgsSupplier = Util.memoize(() -> this.args().stream().filter(Argument::required).collect(Collectors.toList()));

        @Value.Default
        public String name() {
            return "";
        }

        @Value.Default
        public String uri() {
            return "";
        }

        public abstract Optional<VariadicBehavior> variadic();

        @Nullable
        @Value.Default
        public String description() {
            return "";
        }

        public abstract List<Argument> args();

        public abstract Map<String, Option> options();

        public List<Argument> requiredArguments() {
            return this.requiredArgsSupplier.get();
        }

        public String toString() {
            return this.key();
        }

        @Value.Default
        public Nullability nullability() {
            return Nullability.MIRROR;
        }

        @Nullable
        public abstract Boolean ordered();

        public FunctionAnchor getAnchor() {
            return this.anchorSupplier.get();
        }

        @JsonProperty(value="return")
        public abstract TypeExpression returnType();

        public static String constructKeyFromTypes(String name, List<Type> arguments) {
            try {
                return name + ":" + arguments.stream().map(t -> t.accept(ToTypeString.INSTANCE)).collect(Collectors.joining("_"));
            }
            catch (UnsupportedOperationException ex) {
                throw new UnsupportedOperationException(String.format("Failure converting types of function %s.", name), ex);
            }
        }

        public static String constructKey(String name, List<Argument> arguments) {
            try {
                return name + ":" + arguments.stream().map(Argument::toTypeString).collect(Collectors.joining("_"));
            }
            catch (UnsupportedOperationException ex) {
                throw new UnsupportedOperationException(String.format("Failure converting types of function %s.", name), ex);
            }
        }

        public Util.IntRange getRange() {
            long optionalCount = this.args().stream().filter(t -> !t.required()).count();
            int max = this.variadic().map(t -> {
                OptionalInt optionalMax = t.getMax();
                IntStream stream = optionalMax.isPresent() ? IntStream.of(optionalMax.getAsInt()) : IntStream.empty();
                return stream.map(x -> this.args().size() - 1 + x + 1).findFirst().orElse(Integer.MAX_VALUE);
            }).orElse(this.args().size() + 1);
            int min = this.variadic().map(t -> this.args().size() - 1 + t.getMin()).orElse(this.requiredArguments().size());
            return Util.IntRange.of(min, max);
        }

        public void validateOutputType(List<Expression> argumentExpressions, Type outputType) {
        }

        public String key() {
            return this.keySupplier.get();
        }

        public Type resolveType(List<Type> argumentTypes) {
            return TypeExpressionEvaluator.evaluateExpression(this.returnType(), this.args(), argumentTypes);
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.VariadicBehavior.class)
    @JsonSerialize(as=ImmutableSimpleExtension.VariadicBehavior.class)
    @Value.Immutable
    public static interface VariadicBehavior {
        public int getMin();

        public OptionalInt getMax();

        default public ParameterConsistency parameterConsistency() {
            return ParameterConsistency.CONSISTENT;
        }

        public static enum ParameterConsistency {
            CONSISTENT,
            INCONSISTENT;

        }
    }

    @Value.Immutable
    public static interface FunctionAnchor {
        public String namespace();

        public String key();

        public static FunctionAnchor of(String namespace, String key) {
            return ImmutableSimpleExtension.FunctionAnchor.builder().namespace(namespace).key(key).build();
        }
    }

    public static class EnumArgument
    implements Argument {
        private final List<String> options;
        private final String name;
        private final String description;

        @JsonCreator
        public EnumArgument(@JsonProperty(value="options") List<String> options, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description) {
            this.options = options;
            this.name = name;
            this.description = description;
        }

        public List<String> options() {
            return this.options;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public boolean required() {
            return true;
        }

        @Override
        public String toTypeString() {
            return "req";
        }
    }

    public static class TypeArgument
    implements Argument {
        private ParameterizedType type;
        private String name;
        private String description;

        @JsonCreator
        public TypeArgument(@JsonProperty(value="type") ParameterizedType type, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description) {
            this.type = type;
            this.name = name;
            this.description = description;
        }

        public ParameterizedType getType() {
            return this.type;
        }

        public void setType(ParameterizedType type) {
            this.type = type;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public String toTypeString() {
            return "type";
        }

        @Override
        public boolean required() {
            return true;
        }
    }

    public static class ValueArgument
    implements Argument {
        @JsonProperty(required=true)
        ParameterizedType value;
        String name;
        boolean constant;
        String description;

        @JsonCreator
        public ValueArgument(@JsonProperty(value="value") ParameterizedType value, @JsonProperty(value="name") String name, @JsonProperty(value="constant") boolean constant, @JsonProperty(value="description") String description) {
            this.value = value;
            this.constant = constant;
            this.name = name;
            this.description = description;
        }

        public ParameterizedType value() {
            return this.value;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public String toTypeString() {
            return this.value.accept(ToTypeString.INSTANCE);
        }

        @Override
        public boolean required() {
            return true;
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.Option.class)
    @JsonSerialize(as=ImmutableSimpleExtension.Option.class)
    @Value.Immutable
    public static interface Option {
        public Optional<String> getDescription();

        public List<String> getValues();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ValueArgument.class), @JsonSubTypes.Type(value=TypeArgument.class), @JsonSubTypes.Type(value=EnumArgument.class)})
    public static interface Argument {
        public String toTypeString();

        @Nullable
        public String description();

        public boolean required();
    }

    static enum WindowType {
        PARTITION,
        STREAMING;

    }

    static enum Decomposability {
        NONE,
        ONE,
        MANY;

    }

    static enum Nullability {
        MIRROR,
        DECLARED_OUTPUT,
        DISCRETE;

    }
}

