/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.plan;

import io.substrait.plan.Plan;
import io.substrait.relation.Rel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Plan.Root", generator="Immutables")
@Immutable
public final class ImmutableRoot
extends Plan.Root {
    private final Rel input;
    private final List<String> names;

    private ImmutableRoot(Rel input, List<String> names) {
        this.input = input;
        this.names = names;
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    public final ImmutableRoot withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableRoot(newValue, this.names);
    }

    public final ImmutableRoot withNames(String ... elements) {
        List<String> newValue = ImmutableRoot.createUnmodifiableList(false, ImmutableRoot.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRoot(this.input, newValue);
    }

    public final ImmutableRoot withNames(Iterable<String> elements) {
        if (this.names == elements) {
            return this;
        }
        List<String> newValue = ImmutableRoot.createUnmodifiableList(false, ImmutableRoot.createSafeList(elements, true, false));
        return new ImmutableRoot(this.input, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoot && this.equalTo((ImmutableRoot)another);
    }

    private boolean equalTo(ImmutableRoot another) {
        return this.input.equals(another.input) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return "Root{input=" + this.input + ", names=" + this.names + "}";
    }

    public static ImmutableRoot copyOf(Plan.Root instance) {
        if (instance instanceof ImmutableRoot) {
            return (ImmutableRoot)instance;
        }
        return ImmutableRoot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Plan.Root", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private long initBits = 1L;
        @Nullable
        private Rel input;
        private List<String> names = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(Plan.Root instance) {
            Objects.requireNonNull(instance, "instance");
            this.input(instance.getInput());
            this.addAllNames(instance.getNames());
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addNames(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder addNames(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public ImmutableRoot build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRoot(this.input, ImmutableRoot.createUnmodifiableList(true, this.names));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            return "Cannot build Root, some of required attributes are not set " + attributes;
        }
    }
}

