/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.AggregateFunctionInvocation;
import io.substrait.expression.Expression;
import io.substrait.relation.ImmutableAggregate;
import io.substrait.relation.ImmutableGrouping;
import io.substrait.relation.ImmutableMeasure;
import io.substrait.relation.RelVisitor;
import io.substrait.relation.SingleInputRel;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class Aggregate
extends SingleInputRel {
    static final Logger logger = LoggerFactory.getLogger(Aggregate.class);

    public abstract List<Grouping> getGroupings();

    public abstract List<Measure> getMeasures();

    @Override
    protected Type.Struct deriveRecordType() {
        return TypeCreator.REQUIRED.struct(Stream.concat(this.getGroupings().stream().flatMap(g -> g.getExpressions().stream()).collect(Collectors.toCollection(LinkedHashSet::new)).stream().map(Expression::getType), this.getMeasures().stream().map(t -> t.getFunction().getType())));
    }

    @Override
    public <O, E extends Exception> O accept(RelVisitor<O, E> visitor) throws E {
        return visitor.visit(this);
    }

    public static ImmutableAggregate.Builder builder() {
        return ImmutableAggregate.builder();
    }

    @Value.Immutable
    public static abstract class Measure {
        public abstract AggregateFunctionInvocation getFunction();

        public abstract Optional<Expression> getPreMeasureFilter();

        public static ImmutableMeasure.Builder builder() {
            return ImmutableMeasure.builder();
        }
    }

    @Value.Immutable
    public static abstract class Grouping {
        public abstract List<Expression> getExpressions();

        public static ImmutableGrouping.Builder builder() {
            return ImmutableGrouping.builder();
        }
    }
}

