/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.relation.Fetch;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Fetch", generator="Immutables")
@Immutable
public final class ImmutableFetch
extends Fetch {
    @Nullable
    private final Rel.Remap remap;
    private final Rel input;
    private final long offset;
    @Nullable
    private final Long count;

    private ImmutableFetch(@Nullable Rel.Remap remap, Rel input, long offset, @Nullable Long count) {
        this.remap = remap;
        this.input = input;
        this.offset = offset;
        this.count = count;
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public OptionalLong getCount() {
        return this.count != null ? OptionalLong.of(this.count) : OptionalLong.empty();
    }

    public final ImmutableFetch withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableFetch(newValue, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableFetch(value, this.input, this.offset, this.count);
    }

    public final ImmutableFetch withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableFetch(this.remap, newValue, this.offset, this.count);
    }

    public final ImmutableFetch withOffset(long value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableFetch(this.remap, this.input, value, this.count);
    }

    public final ImmutableFetch withCount(long value) {
        Long newValue = value;
        if (Objects.equals(this.count, newValue)) {
            return this;
        }
        return new ImmutableFetch(this.remap, this.input, this.offset, newValue);
    }

    public final ImmutableFetch withCount(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.count, value)) {
            return this;
        }
        return new ImmutableFetch(this.remap, this.input, this.offset, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFetch && this.equalTo((ImmutableFetch)another);
    }

    private boolean equalTo(ImmutableFetch another) {
        return Objects.equals(this.remap, another.remap) && this.input.equals(another.input) && this.offset == another.offset && Objects.equals(this.count, another.count);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + Long.hashCode(this.offset);
        h += (h << 5) + Objects.hashCode(this.count);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Fetch{");
        if (this.remap != null) {
            builder.append("remap=").append(this.remap);
        }
        if (builder.length() > 6) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("offset=").append(this.offset);
        if (this.count != null) {
            builder.append(", ");
            builder.append("count=").append(this.count);
        }
        return builder.append("}").toString();
    }

    public static ImmutableFetch copyOf(Fetch instance) {
        if (instance instanceof ImmutableFetch) {
            return (ImmutableFetch)instance;
        }
        return ImmutableFetch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Fetch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_OFFSET = 2L;
        private long initBits = 3L;
        @Nullable
        private Rel.Remap remap;
        @Nullable
        private Rel input;
        private long offset;
        @Nullable
        private Long count;

        private Builder() {
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Fetch instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Rel instance;
            Optional<Rel.Remap> remapOptional;
            if (object instanceof Rel && (remapOptional = (instance = (Rel)object).getRemap()).isPresent()) {
                this.remap(remapOptional);
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                this.input(((SingleInputRel)instance).getInput());
            }
            if (object instanceof Fetch) {
                instance = (Fetch)object;
                this.offset(((Fetch)instance).getOffset());
                OptionalLong countOptional = ((Fetch)instance).getCount();
                if (countOptional.isPresent()) {
                    this.count(countOptional);
                }
            }
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder offset(long offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder count(long count) {
            this.count = count;
            return this;
        }

        public final Builder count(OptionalLong count) {
            this.count = count.isPresent() ? Long.valueOf(count.getAsLong()) : null;
            return this;
        }

        public ImmutableFetch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFetch(this.remap, this.input, this.offset, this.count);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build Fetch, some of required attributes are not set " + attributes;
        }
    }
}

