/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.relation.Filter;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Filter", generator="Immutables")
@Immutable
public final class ImmutableFilter
extends Filter {
    @Nullable
    private final Rel.Remap remap;
    private final Rel input;
    private final Expression condition;

    private ImmutableFilter(@Nullable Rel.Remap remap, Rel input, Expression condition) {
        this.remap = remap;
        this.input = input;
        this.condition = condition;
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    public final ImmutableFilter withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableFilter(newValue, this.input, this.condition);
    }

    public final ImmutableFilter withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableFilter(value, this.input, this.condition);
    }

    public final ImmutableFilter withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableFilter(this.remap, newValue, this.condition);
    }

    public final ImmutableFilter withCondition(Expression value) {
        if (this.condition == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "condition");
        return new ImmutableFilter(this.remap, this.input, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFilter && this.equalTo((ImmutableFilter)another);
    }

    private boolean equalTo(ImmutableFilter another) {
        return Objects.equals(this.remap, another.remap) && this.input.equals(another.input) && this.condition.equals(another.condition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.condition.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Filter{");
        if (this.remap != null) {
            builder.append("remap=").append(this.remap);
        }
        if (builder.length() > 7) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("condition=").append(this.condition);
        return builder.append("}").toString();
    }

    public static ImmutableFilter copyOf(Filter instance) {
        if (instance instanceof ImmutableFilter) {
            return (ImmutableFilter)instance;
        }
        return ImmutableFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Filter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_CONDITION = 2L;
        private long initBits = 3L;
        @Nullable
        private Rel.Remap remap;
        @Nullable
        private Rel input;
        @Nullable
        private Expression condition;

        private Builder() {
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Filter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Rel instance;
            Optional<Rel.Remap> remapOptional;
            if (object instanceof Rel && (remapOptional = (instance = (Rel)object).getRemap()).isPresent()) {
                this.remap(remapOptional);
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                this.input(((SingleInputRel)instance).getInput());
            }
            if (object instanceof Filter) {
                instance = (Filter)object;
                this.condition(((Filter)instance).getCondition());
            }
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder condition(Expression condition) {
            this.condition = Objects.requireNonNull(condition, "condition");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableFilter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFilter(this.remap, this.input, this.condition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("condition");
            }
            return "Cannot build Filter, some of required attributes are not set " + attributes;
        }
    }
}

