/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.relation.Rel;
import io.substrait.relation.Set;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Set", generator="Immutables")
@Immutable
public final class ImmutableSet
extends Set {
    @Nullable
    private final Rel.Remap remap;
    private final List<Rel> inputs;
    private final Set.SetOp setOp;

    private ImmutableSet(@Nullable Rel.Remap remap, List<Rel> inputs, Set.SetOp setOp) {
        this.remap = remap;
        this.inputs = inputs;
        this.setOp = setOp;
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public List<Rel> getInputs() {
        return this.inputs;
    }

    @Override
    public Set.SetOp getSetOp() {
        return this.setOp;
    }

    public final ImmutableSet withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableSet(newValue, this.inputs, this.setOp);
    }

    public final ImmutableSet withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableSet(value, this.inputs, this.setOp);
    }

    public final ImmutableSet withInputs(Rel ... elements) {
        List<Rel> newValue = ImmutableSet.createUnmodifiableList(false, ImmutableSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSet(this.remap, newValue, this.setOp);
    }

    public final ImmutableSet withInputs(Iterable<? extends Rel> elements) {
        if (this.inputs == elements) {
            return this;
        }
        List<Rel> newValue = ImmutableSet.createUnmodifiableList(false, ImmutableSet.createSafeList(elements, true, false));
        return new ImmutableSet(this.remap, newValue, this.setOp);
    }

    public final ImmutableSet withSetOp(Set.SetOp value) {
        if (this.setOp == value) {
            return this;
        }
        Set.SetOp newValue = Objects.requireNonNull(value, "setOp");
        if (this.setOp.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSet(this.remap, this.inputs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSet && this.equalTo((ImmutableSet)another);
    }

    private boolean equalTo(ImmutableSet another) {
        return Objects.equals(this.remap, another.remap) && this.inputs.equals(another.inputs) && this.setOp.equals((Object)another.setOp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + this.inputs.hashCode();
        h += (h << 5) + this.setOp.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Set{");
        if (this.remap != null) {
            builder.append("remap=").append(this.remap);
        }
        if (builder.length() > 4) {
            builder.append(", ");
        }
        builder.append("inputs=").append(this.inputs);
        builder.append(", ");
        builder.append("setOp=").append((Object)this.setOp);
        return builder.append("}").toString();
    }

    public static ImmutableSet copyOf(Set instance) {
        if (instance instanceof ImmutableSet) {
            return (ImmutableSet)instance;
        }
        return ImmutableSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Set", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SET_OP = 1L;
        private long initBits = 1L;
        @Nullable
        private Rel.Remap remap;
        private List<Rel> inputs = new ArrayList<Rel>();
        @Nullable
        private Set.SetOp setOp;

        private Builder() {
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Set instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Rel instance;
            if (object instanceof Rel) {
                instance = (Rel)object;
                this.addAllInputs(instance.getInputs());
                Optional<Rel.Remap> remapOptional = instance.getRemap();
                if (remapOptional.isPresent()) {
                    this.remap(remapOptional);
                }
            }
            if (object instanceof Set) {
                instance = (Set)object;
                this.setOp(((Set)instance).getSetOp());
            }
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder addInputs(Rel element) {
            this.inputs.add(Objects.requireNonNull(element, "inputs element"));
            return this;
        }

        public final Builder addInputs(Rel ... elements) {
            for (Rel element : elements) {
                this.inputs.add(Objects.requireNonNull(element, "inputs element"));
            }
            return this;
        }

        public final Builder inputs(Iterable<? extends Rel> elements) {
            this.inputs.clear();
            return this.addAllInputs(elements);
        }

        public final Builder addAllInputs(Iterable<? extends Rel> elements) {
            for (Rel rel : elements) {
                this.inputs.add(Objects.requireNonNull(rel, "inputs element"));
            }
            return this;
        }

        public final Builder setOp(Set.SetOp setOp) {
            this.setOp = Objects.requireNonNull(setOp, "setOp");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSet(this.remap, ImmutableSet.createUnmodifiableList(true, this.inputs), this.setOp);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("setOp");
            }
            return "Cannot build Set, some of required attributes are not set " + attributes;
        }
    }
}

