/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import io.substrait.relation.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Sort", generator="Immutables")
@Immutable
public final class ImmutableSort
extends Sort {
    @Nullable
    private final Rel.Remap remap;
    private final Rel input;
    private final List<Expression.SortField> sortFields;

    private ImmutableSort(@Nullable Rel.Remap remap, Rel input, List<Expression.SortField> sortFields) {
        this.remap = remap;
        this.input = input;
        this.sortFields = sortFields;
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public List<Expression.SortField> getSortFields() {
        return this.sortFields;
    }

    public final ImmutableSort withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableSort(newValue, this.input, this.sortFields);
    }

    public final ImmutableSort withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableSort(value, this.input, this.sortFields);
    }

    public final ImmutableSort withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableSort(this.remap, newValue, this.sortFields);
    }

    public final ImmutableSort withSortFields(Expression.SortField ... elements) {
        List<Expression.SortField> newValue = ImmutableSort.createUnmodifiableList(false, ImmutableSort.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSort(this.remap, this.input, newValue);
    }

    public final ImmutableSort withSortFields(Iterable<? extends Expression.SortField> elements) {
        if (this.sortFields == elements) {
            return this;
        }
        List<Expression.SortField> newValue = ImmutableSort.createUnmodifiableList(false, ImmutableSort.createSafeList(elements, true, false));
        return new ImmutableSort(this.remap, this.input, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSort && this.equalTo((ImmutableSort)another);
    }

    private boolean equalTo(ImmutableSort another) {
        return Objects.equals(this.remap, another.remap) && this.input.equals(another.input) && this.sortFields.equals(another.sortFields);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.sortFields.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Sort{");
        if (this.remap != null) {
            builder.append("remap=").append(this.remap);
        }
        if (builder.length() > 5) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("sortFields=").append(this.sortFields);
        return builder.append("}").toString();
    }

    public static ImmutableSort copyOf(Sort instance) {
        if (instance instanceof ImmutableSort) {
            return (ImmutableSort)instance;
        }
        return ImmutableSort.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Sort", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private long initBits = 1L;
        @Nullable
        private Rel.Remap remap;
        @Nullable
        private Rel input;
        private List<Expression.SortField> sortFields = new ArrayList<Expression.SortField>();

        private Builder() {
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Sort instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Rel instance;
            Optional<Rel.Remap> remapOptional;
            if (object instanceof Rel && (remapOptional = (instance = (Rel)object).getRemap()).isPresent()) {
                this.remap(remapOptional);
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                this.input(((SingleInputRel)instance).getInput());
            }
            if (object instanceof Sort) {
                instance = (Sort)object;
                this.addAllSortFields(((Sort)instance).getSortFields());
            }
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSortFields(Expression.SortField element) {
            this.sortFields.add(Objects.requireNonNull(element, "sortFields element"));
            return this;
        }

        public final Builder addSortFields(Expression.SortField ... elements) {
            for (Expression.SortField element : elements) {
                this.sortFields.add(Objects.requireNonNull(element, "sortFields element"));
            }
            return this;
        }

        public final Builder sortFields(Iterable<? extends Expression.SortField> elements) {
            this.sortFields.clear();
            return this.addAllSortFields(elements);
        }

        public final Builder addAllSortFields(Iterable<? extends Expression.SortField> elements) {
            for (Expression.SortField sortField : elements) {
                this.sortFields.add(Objects.requireNonNull(sortField, "sortFields element"));
            }
            return this;
        }

        public ImmutableSort build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSort(this.remap, this.input, ImmutableSort.createUnmodifiableList(true, this.sortFields));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            return "Cannot build Sort, some of required attributes are not set " + attributes;
        }
    }
}

