/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.proto.JoinRel;
import io.substrait.relation.BiRel;
import io.substrait.relation.ImmutableJoin;
import io.substrait.relation.RelVisitor;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.Optional;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Join
extends BiRel {
    public abstract Optional<Expression> getCondition();

    public abstract Optional<Expression> getPostJoinFilter();

    public abstract JoinType getJoinType();

    @Override
    protected Type.Struct deriveRecordType() {
        return TypeCreator.REQUIRED.struct(Stream.concat(this.getLeft().getRecordType().fields().stream(), this.getRight().getRecordType().fields().stream()));
    }

    @Override
    public <O, E extends Exception> O accept(RelVisitor<O, E> visitor) throws E {
        return visitor.visit(this);
    }

    public static ImmutableJoin.Builder builder() {
        return ImmutableJoin.builder();
    }

    public static enum JoinType {
        UNKNOWN(JoinRel.JoinType.JOIN_TYPE_UNSPECIFIED),
        INNER(JoinRel.JoinType.JOIN_TYPE_INNER),
        OUTER(JoinRel.JoinType.JOIN_TYPE_OUTER),
        LEFT(JoinRel.JoinType.JOIN_TYPE_LEFT),
        RIGHT(JoinRel.JoinType.JOIN_TYPE_RIGHT),
        SEMI(JoinRel.JoinType.JOIN_TYPE_SEMI),
        ANTI(JoinRel.JoinType.JOIN_TYPE_ANTI);

        private JoinRel.JoinType proto;

        private JoinType(JoinRel.JoinType proto) {
            this.proto = proto;
        }

        public JoinRel.JoinType toProto() {
            return this.proto;
        }

        public static JoinType fromProto(JoinRel.JoinType proto) {
            for (JoinType v : JoinType.values()) {
                if (v.proto != proto) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown type: " + (Object)((Object)proto));
        }
    }
}

