/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.relation.ImmutableProject;
import io.substrait.relation.RelVisitor;
import io.substrait.relation.SingleInputRel;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.List;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class Project
extends SingleInputRel {
    static final Logger logger = LoggerFactory.getLogger(Project.class);

    public abstract List<Expression> getExpressions();

    @Override
    public Type.Struct deriveRecordType() {
        Type.Struct initial = this.getInput().getRecordType();
        return TypeCreator.of(initial.nullable()).struct(Stream.concat(initial.fields().stream(), this.getExpressions().stream().map(Expression::getType)));
    }

    @Override
    public <O, E extends Exception> O accept(RelVisitor<O, E> visitor) throws E {
        return visitor.visit(this);
    }

    public static ImmutableProject.Builder builder() {
        return ImmutableProject.builder();
    }
}

