/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.AggregateFunctionInvocation;
import io.substrait.expression.Expression;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.FunctionLookup;
import io.substrait.expression.ImmutableExpression;
import io.substrait.expression.proto.ProtoExpressionConverter;
import io.substrait.function.SimpleExtension;
import io.substrait.proto.AggregateFunction;
import io.substrait.proto.AggregateRel;
import io.substrait.proto.CrossRel;
import io.substrait.proto.Expression;
import io.substrait.proto.FetchRel;
import io.substrait.proto.FilterRel;
import io.substrait.proto.JoinRel;
import io.substrait.proto.NamedStruct;
import io.substrait.proto.ProjectRel;
import io.substrait.proto.ReadRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import io.substrait.proto.SetRel;
import io.substrait.proto.SortRel;
import io.substrait.proto.Type;
import io.substrait.relation.Aggregate;
import io.substrait.relation.Cross;
import io.substrait.relation.EmptyScan;
import io.substrait.relation.Fetch;
import io.substrait.relation.Filter;
import io.substrait.relation.ImmutableGrouping;
import io.substrait.relation.ImmutableMeasure;
import io.substrait.relation.Join;
import io.substrait.relation.LocalFiles;
import io.substrait.relation.NamedScan;
import io.substrait.relation.Project;
import io.substrait.relation.Rel;
import io.substrait.relation.Set;
import io.substrait.relation.Sort;
import io.substrait.relation.VirtualTableScan;
import io.substrait.relation.files.FileOrFiles;
import io.substrait.relation.files.ImmutableFileFormat;
import io.substrait.relation.files.ImmutableFileOrFiles;
import io.substrait.type.ImmutableNamedStruct;
import io.substrait.type.ImmutableType;
import io.substrait.type.Type;
import io.substrait.type.proto.FromProto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoRelConverter {
    static final Logger logger = LoggerFactory.getLogger(ProtoRelConverter.class);
    private final FunctionLookup lookup;
    private final SimpleExtension.ExtensionCollection extensions;

    public ProtoRelConverter(FunctionLookup lookup) throws IOException {
        this(lookup, SimpleExtension.loadDefaults());
    }

    public ProtoRelConverter(FunctionLookup lookup, SimpleExtension.ExtensionCollection extensions) {
        this.lookup = lookup;
        this.extensions = extensions;
    }

    public Rel from(io.substrait.proto.Rel rel) {
        Rel.RelTypeCase relType = rel.getRelTypeCase();
        switch (relType) {
            case READ: {
                return this.newRead(rel.getRead());
            }
            case FILTER: {
                return this.newFilter(rel.getFilter());
            }
            case FETCH: {
                return this.newFetch(rel.getFetch());
            }
            case AGGREGATE: {
                return this.newAggregate(rel.getAggregate());
            }
            case SORT: {
                return this.newSort(rel.getSort());
            }
            case JOIN: {
                return this.newJoin(rel.getJoin());
            }
            case SET: {
                return this.newSet(rel.getSet());
            }
            case PROJECT: {
                return this.newProject(rel.getProject());
            }
            case CROSS: {
                return this.newCross(rel.getCross());
            }
        }
        throw new UnsupportedOperationException("Unsupported RelTypeCase of " + (Object)((Object)relType));
    }

    private Rel newRead(ReadRel rel) {
        if (rel.hasVirtualTable()) {
            return this.newVirtualTable(rel);
        }
        if (rel.hasNamedTable()) {
            return this.newNamedScan(rel);
        }
        if (rel.hasLocalFiles()) {
            return this.newLocalFiles(rel);
        }
        return this.newEmptyScan(rel);
    }

    private Filter newFilter(FilterRel rel) {
        Rel input = this.from(rel.getInput());
        return Filter.builder().input(input).condition(new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType()).from(rel.getCondition())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).build();
    }

    private io.substrait.type.NamedStruct newNamedStruct(ReadRel rel) {
        NamedStruct namedStruct = rel.getBaseSchema();
        Type.Struct struct = namedStruct.getStruct();
        return ImmutableNamedStruct.builder().names((Iterable<String>)namedStruct.getNamesList()).struct(Type.Struct.builder().fields(struct.getTypesList().stream().map(FromProto::from).collect(Collectors.toList())).nullable(FromProto.isNullable(struct.getNullability())).build()).build();
    }

    private EmptyScan newEmptyScan(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        return EmptyScan.builder().initialSchema(namedStruct).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct()).from(rel.getFilter()) : null)).build();
    }

    private NamedScan newNamedScan(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        return NamedScan.builder().initialSchema(namedStruct).names((Iterable<String>)rel.getNamedTable().getNamesList()).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct()).from(rel.getFilter()) : null)).build();
    }

    private LocalFiles newLocalFiles(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        return LocalFiles.builder().initialSchema(namedStruct).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).addAllItems(rel.getLocalFiles().getItemsList().stream().map(file -> {
            ImmutableFileOrFiles.Builder builder = ImmutableFileOrFiles.builder().partitionIndex(file.getPartitionIndex()).start(file.getStart()).length(file.getLength());
            if (file.hasParquet()) {
                builder.fileFormat(ImmutableFileFormat.ParquetReadOptions.builder().build());
            } else if (file.hasOrc()) {
                builder.fileFormat(ImmutableFileFormat.OrcReadOptions.builder().build());
            } else if (file.hasArrow()) {
                builder.fileFormat(ImmutableFileFormat.ArrowReadOptions.builder().build());
            } else if (file.hasDwrf()) {
                builder.fileFormat(ImmutableFileFormat.DwrfReadOptions.builder().build());
            } else if (file.hasExtension()) {
                builder.fileFormat(ImmutableFileFormat.Extension.builder().extension(file.getExtension()).build());
            }
            if (file.hasUriFile()) {
                builder.pathType(FileOrFiles.PathType.URI_FILE).path(file.getUriFile());
            } else if (file.hasUriFolder()) {
                builder.pathType(FileOrFiles.PathType.URI_FOLDER).path(file.getUriFolder());
            } else if (file.hasUriPath()) {
                builder.pathType(FileOrFiles.PathType.URI_PATH).path(file.getUriPath());
            } else if (file.hasUriPathGlob()) {
                builder.pathType(FileOrFiles.PathType.URI_PATH_GLOB).path(file.getUriPathGlob());
            }
            return builder.build();
        }).collect(Collectors.toList())).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct()).from(rel.getFilter()) : null)).build();
    }

    private VirtualTableScan newVirtualTable(ReadRel rel) {
        ReadRel.VirtualTable virtualTable = rel.getVirtualTable();
        ArrayList<ImmutableExpression.StructLiteral> structLiterals = new ArrayList<ImmutableExpression.StructLiteral>(virtualTable.getValuesCount());
        for (Expression.Literal.Struct struct : virtualTable.getValuesList()) {
            structLiterals.add(ImmutableExpression.StructLiteral.builder().fields(struct.getFieldsList().stream().map(ProtoExpressionConverter::from).collect(Collectors.toList())).build());
        }
        List<String> fieldNames = rel.getBaseSchema().getNamesList().stream().collect(Collectors.toList());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, ProtoExpressionConverter.EMPTY_TYPE);
        return VirtualTableScan.builder().filter(Optional.ofNullable(rel.hasFilter() ? converter.from(rel.getFilter()) : null)).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).addAllDfsNames(fieldNames).rows(structLiterals).build();
    }

    private Fetch newFetch(FetchRel rel) {
        Rel input = this.from(rel.getInput());
        return Fetch.builder().input(input).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).count(rel.getCount()).offset(rel.getOffset()).build();
    }

    private Project newProject(ProjectRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType());
        return Project.builder().input(input).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).expressions(rel.getExpressionsList().stream().map(converter::from).collect(Collectors.toList())).build();
    }

    private Aggregate newAggregate(AggregateRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType());
        ArrayList<ImmutableGrouping> groupings = new ArrayList<ImmutableGrouping>(rel.getGroupingsCount());
        for (AggregateRel.Grouping grouping : rel.getGroupingsList()) {
            groupings.add(Aggregate.Grouping.builder().expressions(grouping.getGroupingExpressionsList().stream().map(converter::from).collect(Collectors.toList())).build());
        }
        ArrayList<ImmutableMeasure> measures = new ArrayList<ImmutableMeasure>(rel.getMeasuresCount());
        FunctionArg.ProtoFrom pF = new FunctionArg.ProtoFrom(converter);
        for (AggregateRel.Measure measure : rel.getMeasuresList()) {
            AggregateFunction func = measure.getMeasure();
            SimpleExtension.AggregateFunctionVariant funcDecl = this.lookup.getAggregateFunction(func.getFunctionReference(), this.extensions);
            List args = IntStream.range(0, measure.getMeasure().getArgumentsCount()).mapToObj(i -> pF.convert(funcDecl, i, measure.getMeasure().getArguments(i))).collect(Collectors.toList());
            measures.add(Aggregate.Measure.builder().function(AggregateFunctionInvocation.builder().arguments(args).declaration(funcDecl).outputType(FromProto.from(func.getOutputType())).aggregationPhase(Expression.AggregationPhase.fromProto(func.getPhase())).invocation(func.getInvocation()).build()).preMeasureFilter(Optional.ofNullable(measure.hasFilter() ? converter.from(measure.getFilter()) : null)).build());
        }
        return Aggregate.builder().input(input).groupings(groupings).measures(measures).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).build();
    }

    private Sort newSort(SortRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType());
        return Sort.builder().input(input).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).sortFields(rel.getSortsList().stream().map(field -> Expression.SortField.builder().direction(Expression.SortDirection.fromProto(field.getDirection())).expr(converter.from(field.getExpr())).build()).collect(Collectors.toList())).build();
    }

    private Join newJoin(JoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct);
        return Join.builder().condition(converter.from(rel.getExpression())).joinType(Join.JoinType.fromProto(rel.getType())).left(left).right(right).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).postJoinFilter(Optional.ofNullable(rel.hasPostJoinFilter() ? converter.from(rel.getPostJoinFilter()) : null)).build();
    }

    private Rel newCross(CrossRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        return Cross.builder().left(left).right(right).deriveRecordType(unionedStruct).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).build();
    }

    private Set newSet(SetRel rel) {
        List inputs = rel.getInputsList().stream().map(inputRel -> this.from((io.substrait.proto.Rel)inputRel)).collect(Collectors.toList());
        return Set.builder().inputs(inputs).setOp(Set.SetOp.fromProto(rel.getOp())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).build();
    }

    private static Optional<Rel.Remap> optionalRelmap(RelCommon relCommon) {
        return Optional.ofNullable(relCommon.hasEmit() ? Rel.Remap.of(relCommon.getEmit().getOutputMappingList()) : null);
    }
}

