/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.AbstractExpressionVisitor;
import io.substrait.expression.Expression;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.ImmutableFieldReference;
import io.substrait.relation.AbstractRelVisitor;
import io.substrait.relation.Aggregate;
import io.substrait.relation.Cross;
import io.substrait.relation.Fetch;
import io.substrait.relation.Filter;
import io.substrait.relation.ImmutableAggregate;
import io.substrait.relation.ImmutableCross;
import io.substrait.relation.ImmutableFetch;
import io.substrait.relation.ImmutableFilter;
import io.substrait.relation.ImmutableJoin;
import io.substrait.relation.ImmutableProject;
import io.substrait.relation.ImmutableSet;
import io.substrait.relation.ImmutableSort;
import io.substrait.relation.Join;
import io.substrait.relation.Project;
import io.substrait.relation.Rel;
import io.substrait.relation.Set;
import io.substrait.relation.Sort;
import io.substrait.type.ImmutableType;
import io.substrait.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class RelCopyOnWriteVisitor
extends AbstractRelVisitor<Optional<Rel>, RuntimeException> {
    public static <T> Optional<List<T>> transformList(List<T> items, Function<T, Optional<T>> transform) {
        List<T> transformedItems = items;
        for (int i = 0; i < items.size(); ++i) {
            T item = items.get(i);
            Optional<T> transformedItem = transform.apply(item);
            if (!transformedItem.isPresent()) continue;
            if (transformedItems == items) {
                transformedItems = new ArrayList<T>(items);
            }
            transformedItems.set(i, transformedItem.get());
        }
        return transformedItems == items ? Optional.empty() : Optional.of(transformedItems);
    }

    private Optional<List<Expression>> transformExpressions(List<Expression> oldExpressions) {
        return RelCopyOnWriteVisitor.transformList(oldExpressions, t -> this.visitExpression((Expression)t));
    }

    private Optional<List<FunctionArg>> transformFuncArgs(List<FunctionArg> oldExpressions) {
        return RelCopyOnWriteVisitor.transformList(oldExpressions, t -> {
            if (t instanceof Expression) {
                return this.visitExpression((Expression)t).flatMap(ex -> Optional.of(ex));
            }
            return Optional.of(t);
        });
    }

    private static boolean allEmpty(Optional<?> ... optionals) {
        for (Optional<?> optional : optionals) {
            if (!optional.isPresent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<Rel> visitFallback(Rel rel) {
        return Optional.empty();
    }

    @Override
    public Optional<Rel> visit(Aggregate aggregate) throws RuntimeException {
        return aggregate.getInput().accept(this).map(input -> ImmutableAggregate.builder().from(aggregate).input((Rel)input).build());
    }

    @Override
    public Optional<Rel> visit(Fetch fetch) throws RuntimeException {
        return fetch.getInput().accept(this).map(input -> ImmutableFetch.builder().from(fetch).input((Rel)input).build());
    }

    @Override
    public Optional<Rel> visit(Filter filter) throws RuntimeException {
        Optional<Rel> input = filter.getInput().accept(this);
        Optional<Expression> condition = this.visitExpression(filter.getCondition());
        if (RelCopyOnWriteVisitor.allEmpty(input, condition)) {
            return Optional.empty();
        }
        return Optional.of(ImmutableFilter.builder().from(filter).input(input.orElse(filter.getInput())).condition(condition.orElse(filter.getCondition())).build());
    }

    @Override
    public Optional<Rel> visit(Join join) throws RuntimeException {
        Optional<Rel> left = join.getLeft().accept(this);
        Optional<Rel> right = join.getRight().accept(this);
        Optional condition = join.getCondition().flatMap(t -> this.visitExpression((Expression)t));
        Optional postFilter = join.getPostJoinFilter().flatMap(t -> this.visitExpression((Expression)t));
        if (RelCopyOnWriteVisitor.allEmpty(left, right, condition, postFilter)) {
            return Optional.empty();
        }
        return Optional.of(ImmutableJoin.builder().from(join).left(left.orElse(join.getLeft())).right(right.orElse(join.getRight())).condition(Optional.ofNullable(condition.orElseGet(() -> join.getCondition().orElse(null)))).postJoinFilter(Optional.ofNullable(postFilter.orElseGet(() -> join.getPostJoinFilter().orElse(null)))).build());
    }

    @Override
    public Optional<Rel> visit(Set set) throws RuntimeException {
        return RelCopyOnWriteVisitor.transformList(set.getInputs(), t -> t.accept(this)).map(u -> ImmutableSet.builder().from(set).inputs((Iterable<? extends Rel>)u).setOp(set.getSetOp()).build());
    }

    @Override
    public Optional<Rel> visit(Project project) throws RuntimeException {
        Optional<Rel> input = project.getInput().accept(this);
        Optional<List<Expression>> expressions = this.transformExpressions(project.getExpressions());
        if (RelCopyOnWriteVisitor.allEmpty(input, expressions)) {
            return Optional.empty();
        }
        return Optional.of(ImmutableProject.builder().from(project).input(input.orElse(project.getInput())).expressions((Iterable<? extends Expression>)expressions.orElse(project.getExpressions())).build());
    }

    @Override
    public Optional<Rel> visit(Sort sort) throws RuntimeException {
        return sort.getInput().accept(this).map(input -> ImmutableSort.builder().from(sort).input((Rel)input).build());
    }

    @Override
    public Optional<Rel> visit(Cross cross) throws RuntimeException {
        Optional<Rel> left = cross.getLeft().accept(this);
        Optional<Rel> right = cross.getRight().accept(this);
        if (RelCopyOnWriteVisitor.allEmpty(left, right)) {
            return Optional.empty();
        }
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(left.orElse(cross.getLeft()).getRecordType()).from(right.orElse(cross.getRight()).getRecordType()).build();
        return Optional.of(ImmutableCross.builder().from(cross).left(left.orElse(cross.getLeft())).right(right.orElse(cross.getRight())).deriveRecordType(unionedStruct).build());
    }

    private Optional<Expression> visitExpression(Expression expression) {
        AbstractExpressionVisitor<Optional<Expression>, RuntimeException> visitor = new AbstractExpressionVisitor<Optional<Expression>, RuntimeException>(){

            @Override
            public Optional<Expression> visitFallback(Expression expr) {
                return Optional.empty();
            }

            @Override
            public Optional<Expression> visit(Expression.Switch expr) throws RuntimeException {
                Optional<Expression> defaultClause = expr.defaultClause().accept(this);
                Optional<List<Expression.SwitchClause>> switchClauses = RelCopyOnWriteVisitor.transformList(expr.switchClauses(), t -> t.then().accept(this).map(u -> Expression.SwitchClause.builder().from((Expression.SwitchClause)t).then((Expression)u).build()));
                if (RelCopyOnWriteVisitor.allEmpty(new Optional[]{defaultClause, switchClauses})) {
                    return Optional.empty();
                }
                return Optional.of(Expression.Switch.builder().from(expr).defaultClause(defaultClause.orElse(expr.defaultClause())).switchClauses((Iterable<? extends Expression.SwitchClause>)switchClauses.orElse(expr.switchClauses())).build());
            }

            @Override
            public Optional<Expression> visit(Expression.IfThen expr) throws RuntimeException {
                Optional<List<Expression.IfClause>> ifClauses = RelCopyOnWriteVisitor.transformList(expr.ifClauses(), t -> t.condition().accept(this).map(u -> Expression.IfClause.builder().from((Expression.IfClause)t).condition((Expression)u).build()));
                Optional<List<Expression.IfClause>> ifThenClauses = RelCopyOnWriteVisitor.transformList(ifClauses.orElse(expr.ifClauses()), t -> t.then().accept(this).map(u -> Expression.IfClause.builder().from((Expression.IfClause)t).then((Expression)u).build()));
                Optional<Expression> elseClause = expr.elseClause().accept(this);
                if (RelCopyOnWriteVisitor.allEmpty(new Optional[]{ifClauses, ifThenClauses, elseClause})) {
                    return Optional.empty();
                }
                return Optional.of(Expression.IfThen.builder().from(expr).ifClauses((Iterable<? extends Expression.IfClause>)ifThenClauses.orElse(expr.ifClauses())).elseClause(elseClause.orElse(expr.elseClause())).build());
            }

            @Override
            public Optional<Expression> visit(Expression.ScalarFunctionInvocation expr) throws RuntimeException {
                return RelCopyOnWriteVisitor.this.transformFuncArgs(expr.arguments()).map(t -> Expression.ScalarFunctionInvocation.builder().from(expr).arguments((Iterable<? extends FunctionArg>)t).build());
            }

            @Override
            public Optional<Expression> visit(Expression.Cast expr) throws RuntimeException {
                return expr.input().accept(this).map(t -> Expression.Cast.builder().from(expr).input((Expression)t).build());
            }

            @Override
            public Optional<Expression> visit(Expression.SingleOrList expr) throws RuntimeException {
                Optional<Expression> condition = expr.condition().accept(this);
                Optional options = RelCopyOnWriteVisitor.this.transformExpressions(expr.options());
                if (RelCopyOnWriteVisitor.allEmpty(new Optional[]{condition, options})) {
                    return Optional.empty();
                }
                return Optional.of(Expression.SingleOrList.builder().from(expr).condition(condition.orElse(expr.condition())).options((Iterable<? extends Expression>)options.orElse(expr.options())).build());
            }

            @Override
            public Optional<Expression> visit(Expression.MultiOrList expr) throws RuntimeException {
                Optional options = RelCopyOnWriteVisitor.this.transformExpressions(expr.conditions());
                Optional<List<Expression.MultiOrListRecord>> multiOrListRecords = RelCopyOnWriteVisitor.transformList(expr.optionCombinations(), t -> RelCopyOnWriteVisitor.this.transformExpressions(t.values()).map(u -> Expression.MultiOrListRecord.builder().values((Iterable<? extends Expression>)u).build()));
                if (RelCopyOnWriteVisitor.allEmpty(new Optional[]{options, multiOrListRecords})) {
                    return Optional.empty();
                }
                return Optional.of(Expression.MultiOrList.builder().from(expr).optionCombinations((Iterable<? extends Expression.MultiOrListRecord>)multiOrListRecords.orElse(expr.optionCombinations())).build());
            }

            @Override
            public Optional<Expression> visit(FieldReference expr) throws RuntimeException {
                return expr.inputExpression().flatMap(t -> t.accept(this)).map(t -> ImmutableFieldReference.builder().inputExpression(Optional.ofNullable(t)).build());
            }

            @Override
            public Optional<Expression> visit(Expression.SetPredicate expr) throws RuntimeException {
                return expr.tuples().accept(RelCopyOnWriteVisitor.this).map(t -> Expression.SetPredicate.builder().from(expr).tuples((Rel)t).build());
            }

            @Override
            public Optional<Expression> visit(Expression.ScalarSubquery expr) throws RuntimeException {
                return expr.input().accept(RelCopyOnWriteVisitor.this).map(t -> Expression.ScalarSubquery.builder().from(expr).input((Rel)t).build());
            }

            @Override
            public Optional<Expression> visit(Expression.InPredicate expr) throws RuntimeException {
                return expr.haystack().accept(RelCopyOnWriteVisitor.this).map(t -> Expression.InPredicate.builder().from(expr).haystack((Rel)t).build());
            }
        };
        return expression.accept(visitor);
    }
}

