/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation.files;

import io.substrait.relation.files.FileFormat;
import io.substrait.relation.files.FileOrFiles;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FileOrFiles", generator="Immutables")
@Immutable
public final class ImmutableFileOrFiles
implements FileOrFiles {
    @Nullable
    private final FileOrFiles.PathType pathType;
    @Nullable
    private final String path;
    private final long partitionIndex;
    private final long start;
    private final long length;
    @Nullable
    private final FileFormat fileFormat;

    private ImmutableFileOrFiles(@Nullable FileOrFiles.PathType pathType, @Nullable String path, long partitionIndex, long start, long length, @Nullable FileFormat fileFormat) {
        this.pathType = pathType;
        this.path = path;
        this.partitionIndex = partitionIndex;
        this.start = start;
        this.length = length;
        this.fileFormat = fileFormat;
    }

    @Override
    public Optional<FileOrFiles.PathType> pathType() {
        return Optional.ofNullable(this.pathType);
    }

    @Override
    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    @Override
    public long getPartitionIndex() {
        return this.partitionIndex;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Optional<FileFormat> getFileFormat() {
        return Optional.ofNullable(this.fileFormat);
    }

    public final ImmutableFileOrFiles withPathType(FileOrFiles.PathType value) {
        FileOrFiles.PathType newValue = Objects.requireNonNull(value, "pathType");
        if (this.pathType == newValue) {
            return this;
        }
        return new ImmutableFileOrFiles(newValue, this.path, this.partitionIndex, this.start, this.length, this.fileFormat);
    }

    public final ImmutableFileOrFiles withPathType(Optional<? extends FileOrFiles.PathType> optional) {
        FileOrFiles.PathType value = optional.orElse(null);
        if (Objects.equals((Object)this.pathType, (Object)value)) {
            return this;
        }
        return new ImmutableFileOrFiles(value, this.path, this.partitionIndex, this.start, this.length, this.fileFormat);
    }

    public final ImmutableFileOrFiles withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (Objects.equals(this.path, newValue)) {
            return this;
        }
        return new ImmutableFileOrFiles(this.pathType, newValue, this.partitionIndex, this.start, this.length, this.fileFormat);
    }

    public final ImmutableFileOrFiles withPath(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.path, value)) {
            return this;
        }
        return new ImmutableFileOrFiles(this.pathType, value, this.partitionIndex, this.start, this.length, this.fileFormat);
    }

    public final ImmutableFileOrFiles withPartitionIndex(long value) {
        if (this.partitionIndex == value) {
            return this;
        }
        return new ImmutableFileOrFiles(this.pathType, this.path, value, this.start, this.length, this.fileFormat);
    }

    public final ImmutableFileOrFiles withStart(long value) {
        if (this.start == value) {
            return this;
        }
        return new ImmutableFileOrFiles(this.pathType, this.path, this.partitionIndex, value, this.length, this.fileFormat);
    }

    public final ImmutableFileOrFiles withLength(long value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableFileOrFiles(this.pathType, this.path, this.partitionIndex, this.start, value, this.fileFormat);
    }

    public final ImmutableFileOrFiles withFileFormat(FileFormat value) {
        FileFormat newValue = Objects.requireNonNull(value, "fileFormat");
        if (this.fileFormat == newValue) {
            return this;
        }
        return new ImmutableFileOrFiles(this.pathType, this.path, this.partitionIndex, this.start, this.length, newValue);
    }

    public final ImmutableFileOrFiles withFileFormat(Optional<? extends FileFormat> optional) {
        FileFormat value = optional.orElse(null);
        if (this.fileFormat == value) {
            return this;
        }
        return new ImmutableFileOrFiles(this.pathType, this.path, this.partitionIndex, this.start, this.length, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileOrFiles && this.equalTo((ImmutableFileOrFiles)another);
    }

    private boolean equalTo(ImmutableFileOrFiles another) {
        return Objects.equals((Object)this.pathType, (Object)another.pathType) && Objects.equals(this.path, another.path) && this.partitionIndex == another.partitionIndex && this.start == another.start && this.length == another.length && Objects.equals(this.fileFormat, another.fileFormat);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.pathType);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Long.hashCode(this.partitionIndex);
        h += (h << 5) + Long.hashCode(this.start);
        h += (h << 5) + Long.hashCode(this.length);
        h += (h << 5) + Objects.hashCode(this.fileFormat);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FileOrFiles{");
        if (this.pathType != null) {
            builder.append("pathType=").append((Object)this.pathType);
        }
        if (this.path != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("path=").append(this.path);
        }
        if (builder.length() > 12) {
            builder.append(", ");
        }
        builder.append("partitionIndex=").append(this.partitionIndex);
        builder.append(", ");
        builder.append("start=").append(this.start);
        builder.append(", ");
        builder.append("length=").append(this.length);
        if (this.fileFormat != null) {
            builder.append(", ");
            builder.append("fileFormat=").append(this.fileFormat);
        }
        return builder.append("}").toString();
    }

    public static ImmutableFileOrFiles copyOf(FileOrFiles instance) {
        if (instance instanceof ImmutableFileOrFiles) {
            return (ImmutableFileOrFiles)instance;
        }
        return ImmutableFileOrFiles.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileOrFiles", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PARTITION_INDEX = 1L;
        private static final long INIT_BIT_START = 2L;
        private static final long INIT_BIT_LENGTH = 4L;
        private long initBits = 7L;
        @Nullable
        private FileOrFiles.PathType pathType;
        @Nullable
        private String path;
        private long partitionIndex;
        private long start;
        private long length;
        @Nullable
        private FileFormat fileFormat;

        private Builder() {
        }

        public final Builder from(FileOrFiles instance) {
            Optional<String> pathOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<FileOrFiles.PathType> pathTypeOptional = instance.pathType();
            if (pathTypeOptional.isPresent()) {
                this.pathType(pathTypeOptional);
            }
            if ((pathOptional = instance.getPath()).isPresent()) {
                this.path(pathOptional);
            }
            this.partitionIndex(instance.getPartitionIndex());
            this.start(instance.getStart());
            this.length(instance.getLength());
            Optional<FileFormat> fileFormatOptional = instance.getFileFormat();
            if (fileFormatOptional.isPresent()) {
                this.fileFormat(fileFormatOptional);
            }
            return this;
        }

        public final Builder pathType(FileOrFiles.PathType pathType) {
            this.pathType = Objects.requireNonNull(pathType, "pathType");
            return this;
        }

        public final Builder pathType(Optional<? extends FileOrFiles.PathType> pathType) {
            this.pathType = pathType.orElse(null);
            return this;
        }

        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            return this;
        }

        public final Builder path(Optional<String> path) {
            this.path = path.orElse(null);
            return this;
        }

        public final Builder partitionIndex(long partitionIndex) {
            this.partitionIndex = partitionIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder start(long start) {
            this.start = start;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder length(long length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat");
            return this;
        }

        public final Builder fileFormat(Optional<? extends FileFormat> fileFormat) {
            this.fileFormat = fileFormat.orElse(null);
            return this;
        }

        public ImmutableFileOrFiles build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileOrFiles(this.pathType, this.path, this.partitionIndex, this.start, this.length, this.fileFormat);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("partitionIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("start");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build FileOrFiles, some of required attributes are not set " + attributes;
        }
    }
}

