/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type;

import io.substrait.function.NullableType;
import io.substrait.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Type", generator="Immutables")
public final class ImmutableType {
    private ImmutableType() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Type.Map", generator="Immutables")
    @Immutable
    public static final class Map
    extends Type.Map {
        private final boolean nullable;
        private final Type key;
        private final Type value;

        private Map(boolean nullable, Type key, Type value) {
            this.nullable = nullable;
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Type key() {
            return this.key;
        }

        @Override
        public Type value() {
            return this.value;
        }

        public final Map withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Map(value, this.key, this.value);
        }

        public final Map withKey(Type value) {
            if (this.key == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "key");
            return new Map(this.nullable, newValue, this.value);
        }

        public final Map withValue(Type value) {
            if (this.value == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "value");
            return new Map(this.nullable, this.key, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Map && this.equalTo((Map)another);
        }

        private boolean equalTo(Map another) {
            return this.nullable == another.nullable && this.key.equals(another.key) && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.key.hashCode();
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "Map{nullable=" + this.nullable + ", key=" + this.key + ", value=" + this.value + "}";
        }

        public static Map copyOf(Type.Map instance) {
            if (instance instanceof Map) {
                return (Map)instance;
            }
            return Map.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Map", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_KEY = 2L;
            private static final long INIT_BIT_VALUE = 4L;
            private long initBits = 7L;
            private boolean nullable;
            @Nullable
            private Type key;
            @Nullable
            private Type value;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Map instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof Type.Map) {
                    instance = (Type.Map)object;
                    this.value(((Type.Map)instance).value());
                    this.key(((Type.Map)instance).key());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder key(Type key) {
                this.key = Objects.requireNonNull(key, "key");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder value(Type value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Map build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Map(this.nullable, this.key, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("key");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build Map, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.ListType", generator="Immutables")
    @Immutable
    public static final class ListType
    extends Type.ListType {
        private final boolean nullable;
        private final Type elementType;

        private ListType(boolean nullable, Type elementType) {
            this.nullable = nullable;
            this.elementType = elementType;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Type elementType() {
            return this.elementType;
        }

        public final ListType withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new ListType(value, this.elementType);
        }

        public final ListType withElementType(Type value) {
            if (this.elementType == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "elementType");
            return new ListType(this.nullable, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ListType && this.equalTo((ListType)another);
        }

        private boolean equalTo(ListType another) {
            return this.nullable == another.nullable && this.elementType.equals(another.elementType);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.elementType.hashCode();
            return h;
        }

        public String toString() {
            return "ListType{nullable=" + this.nullable + ", elementType=" + this.elementType + "}";
        }

        public static ListType copyOf(Type.ListType instance) {
            if (instance instanceof ListType) {
                return (ListType)instance;
            }
            return ListType.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.ListType", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_ELEMENT_TYPE = 2L;
            private long initBits = 3L;
            private boolean nullable;
            @Nullable
            private Type elementType;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.ListType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof Type.ListType) {
                    instance = (Type.ListType)object;
                    this.elementType(((Type.ListType)instance).elementType());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder elementType(Type elementType) {
                this.elementType = Objects.requireNonNull(elementType, "elementType");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public ListType build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ListType(this.nullable, this.elementType);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("elementType");
                }
                return "Cannot build ListType, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Struct", generator="Immutables")
    @Immutable
    public static final class Struct
    extends Type.Struct {
        private final boolean nullable;
        private final List<Type> fields;

        private Struct(boolean nullable, List<Type> fields) {
            this.nullable = nullable;
            this.fields = fields;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public List<Type> fields() {
            return this.fields;
        }

        public final Struct withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Struct(value, this.fields);
        }

        public final Struct withFields(Type ... elements) {
            List newValue = ImmutableType.createUnmodifiableList(false, ImmutableType.createSafeList(Arrays.asList(elements), true, false));
            return new Struct(this.nullable, newValue);
        }

        public final Struct withFields(Iterable<? extends Type> elements) {
            if (this.fields == elements) {
                return this;
            }
            List newValue = ImmutableType.createUnmodifiableList(false, ImmutableType.createSafeList(elements, true, false));
            return new Struct(this.nullable, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Struct && this.equalTo((Struct)another);
        }

        private boolean equalTo(Struct another) {
            return this.nullable == another.nullable && this.fields.equals(another.fields);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.fields.hashCode();
            return h;
        }

        public String toString() {
            return "Struct{nullable=" + this.nullable + ", fields=" + this.fields + "}";
        }

        public static Struct copyOf(Type.Struct instance) {
            if (instance instanceof Struct) {
                return (Struct)instance;
            }
            return Struct.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Struct", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;
            private List<Type> fields = new ArrayList<Type>();

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Struct instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof Type.Struct) {
                    instance = (Type.Struct)object;
                    this.addAllFields(((Type.Struct)instance).fields());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addFields(Type element) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
                return this;
            }

            public final Builder addFields(Type ... elements) {
                for (Type element : elements) {
                    this.fields.add(Objects.requireNonNull(element, "fields element"));
                }
                return this;
            }

            public final Builder fields(Iterable<? extends Type> elements) {
                this.fields.clear();
                return this.addAllFields(elements);
            }

            public final Builder addAllFields(Iterable<? extends Type> elements) {
                for (Type type : elements) {
                    this.fields.add(Objects.requireNonNull(type, "fields element"));
                }
                return this;
            }

            public Struct build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Struct(this.nullable, ImmutableType.createUnmodifiableList(true, this.fields));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Struct, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Decimal", generator="Immutables")
    @Immutable
    public static final class Decimal
    extends Type.Decimal {
        private final boolean nullable;
        private final int scale;
        private final int precision;

        private Decimal(boolean nullable, int scale, int precision) {
            this.nullable = nullable;
            this.scale = scale;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int scale() {
            return this.scale;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final Decimal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Decimal(value, this.scale, this.precision);
        }

        public final Decimal withScale(int value) {
            if (this.scale == value) {
                return this;
            }
            return new Decimal(this.nullable, value, this.precision);
        }

        public final Decimal withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new Decimal(this.nullable, this.scale, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Decimal && this.equalTo((Decimal)another);
        }

        private boolean equalTo(Decimal another) {
            return this.nullable == another.nullable && this.scale == another.scale && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.scale;
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "Decimal{nullable=" + this.nullable + ", scale=" + this.scale + ", precision=" + this.precision + "}";
        }

        public static Decimal copyOf(Type.Decimal instance) {
            if (instance instanceof Decimal) {
                return (Decimal)instance;
            }
            return Decimal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Decimal", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_SCALE = 2L;
            private static final long INIT_BIT_PRECISION = 4L;
            private long initBits = 7L;
            private boolean nullable;
            private int scale;
            private int precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Decimal instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof Type.Decimal) {
                    instance = (Type.Decimal)object;
                    this.scale(((Type.Decimal)instance).scale());
                    this.precision(((Type.Decimal)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder scale(int scale) {
                this.scale = scale;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Decimal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Decimal(this.nullable, this.scale, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("scale");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build Decimal, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.FixedBinary", generator="Immutables")
    @Immutable
    public static final class FixedBinary
    extends Type.FixedBinary {
        private final boolean nullable;
        private final int length;

        private FixedBinary(boolean nullable, int length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int length() {
            return this.length;
        }

        public final FixedBinary withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedBinary(value, this.length);
        }

        public final FixedBinary withLength(int value) {
            if (this.length == value) {
                return this;
            }
            return new FixedBinary(this.nullable, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedBinary && this.equalTo((FixedBinary)another);
        }

        private boolean equalTo(FixedBinary another) {
            return this.nullable == another.nullable && this.length == another.length;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length;
            return h;
        }

        public String toString() {
            return "FixedBinary{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static FixedBinary copyOf(Type.FixedBinary instance) {
            if (instance instanceof FixedBinary) {
                return (FixedBinary)instance;
            }
            return FixedBinary.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.FixedBinary", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int length;

            private Builder() {
            }

            public final Builder from(Type.FixedBinary instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof Type.FixedBinary) {
                    instance = (Type.FixedBinary)object;
                    this.length(((Type.FixedBinary)instance).length());
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(int length) {
                this.length = length;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FixedBinary build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedBinary(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build FixedBinary, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.VarChar", generator="Immutables")
    @Immutable
    public static final class VarChar
    extends Type.VarChar {
        private final boolean nullable;
        private final int length;

        private VarChar(boolean nullable, int length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int length() {
            return this.length;
        }

        public final VarChar withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new VarChar(value, this.length);
        }

        public final VarChar withLength(int value) {
            if (this.length == value) {
                return this;
            }
            return new VarChar(this.nullable, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof VarChar && this.equalTo((VarChar)another);
        }

        private boolean equalTo(VarChar another) {
            return this.nullable == another.nullable && this.length == another.length;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length;
            return h;
        }

        public String toString() {
            return "VarChar{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static VarChar copyOf(Type.VarChar instance) {
            if (instance instanceof VarChar) {
                return (VarChar)instance;
            }
            return VarChar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.VarChar", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int length;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.VarChar instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof Type.VarChar) {
                    instance = (Type.VarChar)object;
                    this.length(((Type.VarChar)instance).length());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(int length) {
                this.length = length;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public VarChar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new VarChar(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build VarChar, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.FixedChar", generator="Immutables")
    @Immutable
    public static final class FixedChar
    extends Type.FixedChar {
        private final boolean nullable;
        private final int length;

        private FixedChar(boolean nullable, int length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int length() {
            return this.length;
        }

        public final FixedChar withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedChar(value, this.length);
        }

        public final FixedChar withLength(int value) {
            if (this.length == value) {
                return this;
            }
            return new FixedChar(this.nullable, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedChar && this.equalTo((FixedChar)another);
        }

        private boolean equalTo(FixedChar another) {
            return this.nullable == another.nullable && this.length == another.length;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length;
            return h;
        }

        public String toString() {
            return "FixedChar{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static FixedChar copyOf(Type.FixedChar instance) {
            if (instance instanceof FixedChar) {
                return (FixedChar)instance;
            }
            return FixedChar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.FixedChar", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int length;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.FixedChar instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                NullableType instance;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
                if (object instanceof Type.FixedChar) {
                    instance = (Type.FixedChar)object;
                    this.length(((Type.FixedChar)instance).length());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(int length) {
                this.length = length;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FixedChar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedChar(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build FixedChar, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.UUID", generator="Immutables")
    @Immutable
    public static final class UUID
    extends Type.UUID {
        private final boolean nullable;

        private UUID(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final UUID withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new UUID(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof UUID && this.equalTo((UUID)another);
        }

        private boolean equalTo(UUID another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "UUID{nullable=" + this.nullable + "}";
        }

        public static UUID copyOf(Type.UUID instance) {
            if (instance instanceof UUID) {
                return (UUID)instance;
            }
            return UUID.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.UUID", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.UUID instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public UUID build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new UUID(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build UUID, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.IntervalDay", generator="Immutables")
    @Immutable
    public static final class IntervalDay
    extends Type.IntervalDay {
        private final boolean nullable;

        private IntervalDay(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final IntervalDay withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalDay(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalDay && this.equalTo((IntervalDay)another);
        }

        private boolean equalTo(IntervalDay another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "IntervalDay{nullable=" + this.nullable + "}";
        }

        public static IntervalDay copyOf(Type.IntervalDay instance) {
            if (instance instanceof IntervalDay) {
                return (IntervalDay)instance;
            }
            return IntervalDay.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.IntervalDay", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.IntervalDay instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IntervalDay build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalDay(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build IntervalDay, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.IntervalYear", generator="Immutables")
    @Immutable
    public static final class IntervalYear
    extends Type.IntervalYear {
        private final boolean nullable;

        private IntervalYear(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final IntervalYear withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalYear(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalYear && this.equalTo((IntervalYear)another);
        }

        private boolean equalTo(IntervalYear another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "IntervalYear{nullable=" + this.nullable + "}";
        }

        public static IntervalYear copyOf(Type.IntervalYear instance) {
            if (instance instanceof IntervalYear) {
                return (IntervalYear)instance;
            }
            return IntervalYear.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.IntervalYear", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.IntervalYear instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IntervalYear build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalYear(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build IntervalYear, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Timestamp", generator="Immutables")
    @Immutable
    public static final class Timestamp
    extends Type.Timestamp {
        private final boolean nullable;

        private Timestamp(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Timestamp withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Timestamp(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Timestamp && this.equalTo((Timestamp)another);
        }

        private boolean equalTo(Timestamp another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Timestamp{nullable=" + this.nullable + "}";
        }

        public static Timestamp copyOf(Type.Timestamp instance) {
            if (instance instanceof Timestamp) {
                return (Timestamp)instance;
            }
            return Timestamp.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Timestamp", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Timestamp instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Timestamp build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Timestamp(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Timestamp, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.TimestampTZ", generator="Immutables")
    @Immutable
    public static final class TimestampTZ
    extends Type.TimestampTZ {
        private final boolean nullable;

        private TimestampTZ(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final TimestampTZ withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new TimestampTZ(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TimestampTZ && this.equalTo((TimestampTZ)another);
        }

        private boolean equalTo(TimestampTZ another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "TimestampTZ{nullable=" + this.nullable + "}";
        }

        public static TimestampTZ copyOf(Type.TimestampTZ instance) {
            if (instance instanceof TimestampTZ) {
                return (TimestampTZ)instance;
            }
            return TimestampTZ.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.TimestampTZ", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.TimestampTZ instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public TimestampTZ build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TimestampTZ(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build TimestampTZ, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Time", generator="Immutables")
    @Immutable
    public static final class Time
    extends Type.Time {
        private final boolean nullable;

        private Time(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Time withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Time(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Time && this.equalTo((Time)another);
        }

        private boolean equalTo(Time another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Time{nullable=" + this.nullable + "}";
        }

        public static Time copyOf(Type.Time instance) {
            if (instance instanceof Time) {
                return (Time)instance;
            }
            return Time.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Time", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Time instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Time build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Time(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Time, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Date", generator="Immutables")
    @Immutable
    public static final class Date
    extends Type.Date {
        private final boolean nullable;

        private Date(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Date withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Date(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Date && this.equalTo((Date)another);
        }

        private boolean equalTo(Date another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Date{nullable=" + this.nullable + "}";
        }

        public static Date copyOf(Type.Date instance) {
            if (instance instanceof Date) {
                return (Date)instance;
            }
            return Date.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Date", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Date instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Date build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Date(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Date, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Binary", generator="Immutables")
    @Immutable
    public static final class Binary
    extends Type.Binary {
        private final boolean nullable;

        private Binary(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Binary withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Binary(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Binary && this.equalTo((Binary)another);
        }

        private boolean equalTo(Binary another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Binary{nullable=" + this.nullable + "}";
        }

        public static Binary copyOf(Type.Binary instance) {
            if (instance instanceof Binary) {
                return (Binary)instance;
            }
            return Binary.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Binary", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Binary instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Binary build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Binary(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Binary, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Str", generator="Immutables")
    @Immutable
    public static final class Str
    extends Type.Str {
        private final boolean nullable;

        private Str(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Str withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Str(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Str && this.equalTo((Str)another);
        }

        private boolean equalTo(Str another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Str{nullable=" + this.nullable + "}";
        }

        public static Str copyOf(Type.Str instance) {
            if (instance instanceof Str) {
                return (Str)instance;
            }
            return Str.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Str", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Str instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Str build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Str(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Str, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.FP64", generator="Immutables")
    @Immutable
    public static final class FP64
    extends Type.FP64 {
        private final boolean nullable;

        private FP64(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final FP64 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FP64(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FP64 && this.equalTo((FP64)another);
        }

        private boolean equalTo(FP64 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "FP64{nullable=" + this.nullable + "}";
        }

        public static FP64 copyOf(Type.FP64 instance) {
            if (instance instanceof FP64) {
                return (FP64)instance;
            }
            return FP64.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.FP64", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.FP64 instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public FP64 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FP64(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build FP64, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.FP32", generator="Immutables")
    @Immutable
    public static final class FP32
    extends Type.FP32 {
        private final boolean nullable;

        private FP32(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final FP32 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FP32(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FP32 && this.equalTo((FP32)another);
        }

        private boolean equalTo(FP32 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "FP32{nullable=" + this.nullable + "}";
        }

        public static FP32 copyOf(Type.FP32 instance) {
            if (instance instanceof FP32) {
                return (FP32)instance;
            }
            return FP32.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.FP32", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.FP32 instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public FP32 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FP32(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build FP32, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.I64", generator="Immutables")
    @Immutable
    public static final class I64
    extends Type.I64 {
        private final boolean nullable;

        private I64(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final I64 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I64(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I64 && this.equalTo((I64)another);
        }

        private boolean equalTo(I64 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "I64{nullable=" + this.nullable + "}";
        }

        public static I64 copyOf(Type.I64 instance) {
            if (instance instanceof I64) {
                return (I64)instance;
            }
            return I64.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.I64", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.I64 instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I64 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I64(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build I64, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.I32", generator="Immutables")
    @Immutable
    public static final class I32
    extends Type.I32 {
        private final boolean nullable;

        private I32(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final I32 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I32(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I32 && this.equalTo((I32)another);
        }

        private boolean equalTo(I32 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "I32{nullable=" + this.nullable + "}";
        }

        public static I32 copyOf(Type.I32 instance) {
            if (instance instanceof I32) {
                return (I32)instance;
            }
            return I32.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.I32", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.I32 instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I32 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I32(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build I32, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.I16", generator="Immutables")
    @Immutable
    public static final class I16
    extends Type.I16 {
        private final boolean nullable;

        private I16(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final I16 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I16(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I16 && this.equalTo((I16)another);
        }

        private boolean equalTo(I16 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "I16{nullable=" + this.nullable + "}";
        }

        public static I16 copyOf(Type.I16 instance) {
            if (instance instanceof I16) {
                return (I16)instance;
            }
            return I16.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.I16", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.I16 instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I16 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I16(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build I16, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.I8", generator="Immutables")
    @Immutable
    public static final class I8
    extends Type.I8 {
        private final boolean nullable;

        private I8(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final I8 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I8(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I8 && this.equalTo((I8)another);
        }

        private boolean equalTo(I8 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "I8{nullable=" + this.nullable + "}";
        }

        public static I8 copyOf(Type.I8 instance) {
            if (instance instanceof I8) {
                return (I8)instance;
            }
            return I8.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.I8", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.I8 instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I8 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I8(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build I8, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Bool", generator="Immutables")
    @Immutable
    public static final class Bool
    extends Type.Bool {
        private final boolean nullable;

        private Bool(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Bool withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Bool(value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Bool && this.equalTo((Bool)another);
        }

        private boolean equalTo(Bool another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Bool{nullable=" + this.nullable + "}";
        }

        public static Bool copyOf(Type.Bool instance) {
            if (instance instanceof Bool) {
                return (Bool)instance;
            }
            return Bool.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Bool", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Type.Bool instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof NullableType) {
                    NullableType instance = (NullableType)object;
                    this.nullable(instance.nullable());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Bool build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Bool(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Bool, some of required attributes are not set " + attributes;
            }
        }
    }
}

