/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type;

import io.substrait.type.Type;
import io.substrait.type.TypeVisitor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTypeVisitor
implements TypeVisitor<String, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(StringTypeVisitor.class);

    private String n(Type type) {
        return type.nullable() ? "?" : "";
    }

    @Override
    public String visit(Type.Bool type) throws RuntimeException {
        return "boolean" + this.n(type);
    }

    @Override
    public String visit(Type.I8 type) throws RuntimeException {
        return "i8" + this.n(type);
    }

    @Override
    public String visit(Type.I16 type) throws RuntimeException {
        return "i16" + this.n(type);
    }

    @Override
    public String visit(Type.I32 type) throws RuntimeException {
        return "i32" + this.n(type);
    }

    @Override
    public String visit(Type.I64 type) throws RuntimeException {
        return "i64" + this.n(type);
    }

    @Override
    public String visit(Type.FP32 type) throws RuntimeException {
        return "fp32" + this.n(type);
    }

    @Override
    public String visit(Type.FP64 type) throws RuntimeException {
        return "fp64" + this.n(type);
    }

    @Override
    public String visit(Type.Str type) throws RuntimeException {
        return "string" + this.n(type);
    }

    @Override
    public String visit(Type.Binary type) throws RuntimeException {
        return "binary" + this.n(type);
    }

    @Override
    public String visit(Type.Date type) throws RuntimeException {
        return "date" + this.n(type);
    }

    @Override
    public String visit(Type.Time type) throws RuntimeException {
        return "time" + this.n(type);
    }

    @Override
    public String visit(Type.TimestampTZ type) throws RuntimeException {
        return "timestamp_tz" + this.n(type);
    }

    @Override
    public String visit(Type.Timestamp type) throws RuntimeException {
        return "timestamp" + this.n(type);
    }

    @Override
    public String visit(Type.IntervalYear type) throws RuntimeException {
        return "interval_year" + this.n(type);
    }

    @Override
    public String visit(Type.IntervalDay type) throws RuntimeException {
        return "interval_day" + this.n(type);
    }

    @Override
    public String visit(Type.UUID type) throws RuntimeException {
        return "uuid" + this.n(type);
    }

    @Override
    public String visit(Type.FixedChar type) throws RuntimeException {
        return String.format("char<%d>%s", type.length(), this.n(type));
    }

    @Override
    public String visit(Type.VarChar type) throws RuntimeException {
        return String.format("varchar<%d>%s", type.length(), this.n(type));
    }

    @Override
    public String visit(Type.FixedBinary type) throws RuntimeException {
        return String.format("fixedbinary<%d>%s", type.length(), this.n(type));
    }

    @Override
    public String visit(Type.Decimal type) throws RuntimeException {
        return String.format("decimal<%d,%d>%s", type.precision(), type.scale(), this.n(type));
    }

    @Override
    public String visit(Type.Struct type) throws RuntimeException {
        return String.format("struct<%s>%s", type.fields().stream().map(t -> t.accept(this)).collect(Collectors.joining(", ")), this.n(type));
    }

    @Override
    public String visit(Type.ListType type) throws RuntimeException {
        return String.format("list<%s>%s", type.elementType().accept(this), this.n(type));
    }

    @Override
    public String visit(Type.Map type) throws RuntimeException {
        return String.format("map<%s,%s>%s", type.key().accept(this), type.value().accept(this), this.n(type));
    }
}

