/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type;

import io.substrait.type.Type;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TypeCreator {
    public static final TypeCreator REQUIRED = new TypeCreator(false);
    public static final TypeCreator NULLABLE = new TypeCreator(true);
    protected final boolean nullable;
    public final Type BOOLEAN;
    public final Type I8;
    public final Type I16;
    public final Type I32;
    public final Type I64;
    public final Type FP32;
    public final Type FP64;
    public final Type STRING;
    public final Type BINARY;
    public final Type TIMESTAMP;
    public final Type TIMESTAMP_TZ;
    public final Type DATE;
    public final Type TIME;
    public final Type INTERVAL_DAY;
    public final Type INTERVAL_YEAR;
    public final Type UUID;

    protected TypeCreator(boolean nullable) {
        this.nullable = nullable;
        this.BOOLEAN = Type.Bool.builder().nullable(nullable).build();
        this.I8 = Type.I8.builder().nullable(nullable).build();
        this.I16 = Type.I16.builder().nullable(nullable).build();
        this.I32 = Type.I32.builder().nullable(nullable).build();
        this.I64 = Type.I64.builder().nullable(nullable).build();
        this.FP32 = Type.FP32.builder().nullable(nullable).build();
        this.FP64 = Type.FP64.builder().nullable(nullable).build();
        this.STRING = Type.Str.builder().nullable(nullable).build();
        this.BINARY = Type.Binary.builder().nullable(nullable).build();
        this.TIMESTAMP = Type.Timestamp.builder().nullable(nullable).build();
        this.TIMESTAMP_TZ = Type.TimestampTZ.builder().nullable(nullable).build();
        this.DATE = Type.Date.builder().nullable(nullable).build();
        this.TIME = Type.Time.builder().nullable(nullable).build();
        this.INTERVAL_DAY = Type.IntervalDay.builder().nullable(nullable).build();
        this.INTERVAL_YEAR = Type.IntervalYear.builder().nullable(nullable).build();
        this.UUID = Type.UUID.builder().nullable(nullable).build();
    }

    public Type fixedChar(int len) {
        return Type.FixedChar.builder().nullable(this.nullable).length(len).build();
    }

    public final Type varChar(int len) {
        return Type.VarChar.builder().nullable(this.nullable).length(len).build();
    }

    public final Type fixedBinary(int len) {
        return Type.FixedBinary.builder().nullable(this.nullable).length(len).build();
    }

    public final Type decimal(int precision, int scale) {
        return Type.Decimal.builder().nullable(this.nullable).precision(precision).scale(scale).build();
    }

    public final Type.Struct struct(Type ... types) {
        return Type.Struct.builder().nullable(this.nullable).addFields(types).build();
    }

    public Type.Struct struct(Iterable<? extends Type> types) {
        return Type.Struct.builder().nullable(this.nullable).addAllFields(types).build();
    }

    public Type.Struct struct(Stream<? extends Type> types) {
        return Type.Struct.builder().nullable(this.nullable).addAllFields(types.collect(Collectors.toList())).build();
    }

    public Type list(Type type) {
        return Type.ListType.builder().nullable(this.nullable).elementType(type).build();
    }

    public Type map(Type key, Type value) {
        return Type.Map.builder().nullable(this.nullable).key(key).value(value).build();
    }

    public static TypeCreator of(boolean nullability) {
        return nullability ? NULLABLE : REQUIRED;
    }
}

