/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.proto;

import io.substrait.function.NullableType;
import io.substrait.function.TypeExpressionVisitor;
import io.substrait.type.Type;
import io.substrait.type.proto.BaseProtoTypes;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseProtoConverter<T, I>
extends TypeExpressionVisitor.TypeExpressionThrowsVisitor<T, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(BaseProtoConverter.class);

    public abstract BaseProtoTypes<T, I> typeContainer(boolean var1);

    public BaseProtoConverter(String unsupportedMessage) {
        super(unsupportedMessage);
    }

    public final BaseProtoTypes<T, I> typeContainer(NullableType literal) {
        return this.typeContainer(literal.nullable());
    }

    @Override
    public final T visit(Type.Bool expr) {
        return this.typeContainer((NullableType)expr).BOOLEAN;
    }

    @Override
    public final T visit(Type.I8 expr) {
        return this.typeContainer((NullableType)expr).I8;
    }

    @Override
    public final T visit(Type.I16 expr) {
        return this.typeContainer((NullableType)expr).I16;
    }

    @Override
    public final T visit(Type.I32 expr) {
        return this.typeContainer((NullableType)expr).I32;
    }

    @Override
    public final T visit(Type.I64 expr) {
        return this.typeContainer((NullableType)expr).I64;
    }

    @Override
    public final T visit(Type.FP32 expr) {
        return this.typeContainer((NullableType)expr).FP32;
    }

    @Override
    public final T visit(Type.FP64 expr) {
        return this.typeContainer((NullableType)expr).FP64;
    }

    @Override
    public final T visit(Type.Str expr) {
        return this.typeContainer((NullableType)expr).STRING;
    }

    @Override
    public final T visit(Type.Binary expr) {
        return this.typeContainer((NullableType)expr).BINARY;
    }

    @Override
    public final T visit(Type.Date expr) {
        return this.typeContainer((NullableType)expr).DATE;
    }

    @Override
    public final T visit(Type.Time expr) {
        return this.typeContainer((NullableType)expr).TIME;
    }

    @Override
    public final T visit(Type.TimestampTZ expr) {
        return this.typeContainer((NullableType)expr).TIMESTAMP_TZ;
    }

    @Override
    public final T visit(Type.Timestamp expr) {
        return this.typeContainer((NullableType)expr).TIMESTAMP;
    }

    @Override
    public final T visit(Type.IntervalYear expr) {
        return this.typeContainer((NullableType)expr).INTERVAL_YEAR;
    }

    @Override
    public final T visit(Type.IntervalDay expr) {
        return this.typeContainer((NullableType)expr).INTERVAL_DAY;
    }

    @Override
    public final T visit(Type.UUID expr) {
        return this.typeContainer((NullableType)expr).UUID;
    }

    @Override
    public final T visit(Type.FixedChar expr) {
        return this.typeContainer(expr).fixedChar(expr.length());
    }

    @Override
    public final T visit(Type.VarChar expr) {
        return this.typeContainer(expr).varChar(expr.length());
    }

    @Override
    public final T visit(Type.FixedBinary expr) {
        return this.typeContainer(expr).fixedBinary(expr.length());
    }

    @Override
    public final T visit(Type.Decimal expr) {
        return this.typeContainer(expr).decimal(expr.scale(), expr.precision());
    }

    @Override
    public final T visit(Type.Struct expr) {
        return this.typeContainer(expr).struct(expr.fields().stream().map(t -> t.accept(this)).collect(Collectors.toList()));
    }

    @Override
    public final T visit(Type.ListType expr) {
        return this.typeContainer(expr).list(expr.elementType().accept(this));
    }

    @Override
    public final T visit(Type.Map expr) {
        return this.typeContainer(expr).map(expr.key().accept(this), expr.value().accept(this));
    }
}

