/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.proto;

import io.substrait.function.ParameterizedType;
import io.substrait.function.TypeExpression;
import io.substrait.function.TypeExpressionVisitor;
import io.substrait.proto.ParameterizedType;
import io.substrait.proto.Type;
import io.substrait.type.proto.BaseProtoConverter;
import io.substrait.type.proto.BaseProtoTypes;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterizedProtoConverter
extends BaseProtoConverter<ParameterizedType, ParameterizedType.IntegerOption> {
    static final Logger logger = LoggerFactory.getLogger(ParameterizedProtoConverter.class);
    private static final BaseProtoTypes<ParameterizedType, ParameterizedType.IntegerOption> PARAMETERIZED_NULLABLE = new ParameterizedTypes(Type.Nullability.NULLABILITY_NULLABLE);
    private static final BaseProtoTypes<ParameterizedType, ParameterizedType.IntegerOption> PARAMETERIZED_REQUIRED = new ParameterizedTypes(Type.Nullability.NULLABILITY_REQUIRED);

    public ParameterizedProtoConverter() {
        super("Parameterized types cannot include return type expressions.");
    }

    @Override
    public BaseProtoTypes<ParameterizedType, ParameterizedType.IntegerOption> typeContainer(boolean nullable) {
        return nullable ? PARAMETERIZED_NULLABLE : PARAMETERIZED_REQUIRED;
    }

    public ParameterizedType.IntegerOption i(TypeExpression num) {
        return num.accept(new IntegerVisitor());
    }

    @Override
    public ParameterizedType visit(ParameterizedType.FixedChar expr) throws RuntimeException {
        return (ParameterizedType)this.typeContainer(expr).fixedChar(expr.length().value());
    }

    @Override
    public ParameterizedType visit(ParameterizedType.VarChar expr) throws RuntimeException {
        return (ParameterizedType)this.typeContainer(expr).varChar(expr.length().value());
    }

    @Override
    public ParameterizedType visit(ParameterizedType.FixedBinary expr) throws RuntimeException {
        return (ParameterizedType)this.typeContainer(expr).fixedBinary(expr.length().value());
    }

    @Override
    public ParameterizedType visit(ParameterizedType.Decimal expr) throws RuntimeException {
        return (ParameterizedType)this.typeContainer(expr).decimal(this.i(expr.precision()), this.i(expr.scale()));
    }

    @Override
    public ParameterizedType visit(ParameterizedType.Struct expr) throws RuntimeException {
        return (ParameterizedType)this.typeContainer(expr).struct(expr.fields().stream().map(f -> f.accept(this)).collect(Collectors.toList()));
    }

    @Override
    public ParameterizedType visit(ParameterizedType.ListType expr) throws RuntimeException {
        return this.typeContainer(expr).list(expr.name().accept(this));
    }

    @Override
    public ParameterizedType visit(ParameterizedType.Map expr) throws RuntimeException {
        return this.typeContainer(expr).map(expr.key().accept(this), expr.value().accept(this));
    }

    @Override
    public ParameterizedType visit(ParameterizedType.StringLiteral stringLiteral) throws RuntimeException {
        return ParameterizedType.newBuilder().setTypeParameter(ParameterizedType.TypeParameter.newBuilder().setName(stringLiteral.value())).build();
    }

    private static class IntegerVisitor
    extends TypeExpressionVisitor.TypeExpressionThrowsVisitor<ParameterizedType.IntegerOption, RuntimeException> {
        public IntegerVisitor() {
            super("Parameterized integer locations should only include integer names or literals.");
        }

        @Override
        public ParameterizedType.IntegerOption visit(TypeExpression.IntegerLiteral literal) {
            return ParameterizedType.IntegerOption.newBuilder().setLiteral(literal.value()).build();
        }

        @Override
        public ParameterizedType.IntegerOption visit(ParameterizedType.StringLiteral stringLiteral) throws RuntimeException {
            return ParameterizedType.IntegerOption.newBuilder().setParameter(ParameterizedType.IntegerParameter.newBuilder().setName(stringLiteral.value())).build();
        }
    }

    public static class ParameterizedTypes
    extends BaseProtoTypes<ParameterizedType, ParameterizedType.IntegerOption> {
        public ParameterizedTypes(Type.Nullability nullability) {
            super(nullability);
        }

        @Override
        public ParameterizedType fixedChar(ParameterizedType.IntegerOption len) {
            return this.wrap(ParameterizedType.ParameterizedFixedChar.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public ParameterizedType typeParam(String name) {
            return ParameterizedType.newBuilder().setTypeParameter(ParameterizedType.TypeParameter.newBuilder().setName(name)).build();
        }

        @Override
        public ParameterizedType.IntegerOption integerParam(String name) {
            return ParameterizedType.IntegerOption.newBuilder().setParameter(ParameterizedType.IntegerParameter.newBuilder().setName(name)).build();
        }

        @Override
        protected ParameterizedType.IntegerOption i(int len) {
            return ParameterizedType.IntegerOption.newBuilder().setLiteral(len).build();
        }

        private static ParameterizedType.IntegerOption i(String param) {
            return ParameterizedType.IntegerOption.newBuilder().setParameter(ParameterizedType.IntegerParameter.newBuilder().setName(param)).build();
        }

        @Override
        public ParameterizedType varChar(ParameterizedType.IntegerOption len) {
            return this.wrap(ParameterizedType.ParameterizedVarChar.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public ParameterizedType fixedBinary(ParameterizedType.IntegerOption len) {
            return this.wrap(ParameterizedType.ParameterizedFixedBinary.newBuilder().setLength(len).setNullability(this.nullability).build());
        }

        @Override
        public ParameterizedType decimal(ParameterizedType.IntegerOption scale, ParameterizedType.IntegerOption precision) {
            return this.wrap(ParameterizedType.ParameterizedDecimal.newBuilder().setScale(scale).setPrecision(precision).setNullability(this.nullability).build());
        }

        @Override
        public ParameterizedType struct(Iterable<ParameterizedType> types) {
            return this.wrap(ParameterizedType.ParameterizedStruct.newBuilder().addAllTypes(types).setNullability(this.nullability).build());
        }

        @Override
        public ParameterizedType list(ParameterizedType type) {
            return this.wrap(ParameterizedType.ParameterizedList.newBuilder().setType(type).setNullability(Type.Nullability.NULLABILITY_NULLABLE).build());
        }

        @Override
        public ParameterizedType map(ParameterizedType key, ParameterizedType value) {
            return this.wrap(ParameterizedType.ParameterizedMap.newBuilder().setKey(key).setValue(value).setNullability(Type.Nullability.NULLABILITY_NULLABLE).build());
        }

        @Override
        protected ParameterizedType wrap(Object o) {
            ParameterizedType.Builder bldr = ParameterizedType.newBuilder();
            if (o instanceof Type.Boolean) {
                Type.Boolean t = (Type.Boolean)o;
                return bldr.setBool(t).build();
            }
            if (o instanceof Type.I8) {
                Type.I8 t = (Type.I8)o;
                return bldr.setI8(t).build();
            }
            if (o instanceof Type.I16) {
                Type.I16 t = (Type.I16)o;
                return bldr.setI16(t).build();
            }
            if (o instanceof Type.I32) {
                Type.I32 t = (Type.I32)o;
                return bldr.setI32(t).build();
            }
            if (o instanceof Type.I64) {
                Type.I64 t = (Type.I64)o;
                return bldr.setI64(t).build();
            }
            if (o instanceof Type.FP32) {
                Type.FP32 t = (Type.FP32)o;
                return bldr.setFp32(t).build();
            }
            if (o instanceof Type.FP64) {
                Type.FP64 t = (Type.FP64)o;
                return bldr.setFp64(t).build();
            }
            if (o instanceof Type.String) {
                Type.String t = (Type.String)o;
                return bldr.setString(t).build();
            }
            if (o instanceof Type.Binary) {
                Type.Binary t = (Type.Binary)o;
                return bldr.setBinary(t).build();
            }
            if (o instanceof Type.Timestamp) {
                Type.Timestamp t = (Type.Timestamp)o;
                return bldr.setTimestamp(t).build();
            }
            if (o instanceof Type.Date) {
                Type.Date t = (Type.Date)o;
                return bldr.setDate(t).build();
            }
            if (o instanceof Type.Time) {
                Type.Time t = (Type.Time)o;
                return bldr.setTime(t).build();
            }
            if (o instanceof Type.TimestampTZ) {
                Type.TimestampTZ t = (Type.TimestampTZ)o;
                return bldr.setTimestampTz(t).build();
            }
            if (o instanceof Type.IntervalYear) {
                Type.IntervalYear t = (Type.IntervalYear)o;
                return bldr.setIntervalYear(t).build();
            }
            if (o instanceof Type.IntervalDay) {
                Type.IntervalDay t = (Type.IntervalDay)o;
                return bldr.setIntervalDay(t).build();
            }
            if (o instanceof ParameterizedType.ParameterizedFixedChar) {
                ParameterizedType.ParameterizedFixedChar t = (ParameterizedType.ParameterizedFixedChar)o;
                return bldr.setFixedChar(t).build();
            }
            if (o instanceof ParameterizedType.ParameterizedVarChar) {
                ParameterizedType.ParameterizedVarChar t = (ParameterizedType.ParameterizedVarChar)o;
                return bldr.setVarchar(t).build();
            }
            if (o instanceof ParameterizedType.ParameterizedFixedBinary) {
                ParameterizedType.ParameterizedFixedBinary t = (ParameterizedType.ParameterizedFixedBinary)o;
                return bldr.setFixedBinary(t).build();
            }
            if (o instanceof ParameterizedType.ParameterizedDecimal) {
                ParameterizedType.ParameterizedDecimal t = (ParameterizedType.ParameterizedDecimal)o;
                return bldr.setDecimal(t).build();
            }
            if (o instanceof ParameterizedType.ParameterizedStruct) {
                ParameterizedType.ParameterizedStruct t = (ParameterizedType.ParameterizedStruct)o;
                return bldr.setStruct(t).build();
            }
            if (o instanceof ParameterizedType.ParameterizedList) {
                ParameterizedType.ParameterizedList t = (ParameterizedType.ParameterizedList)o;
                return bldr.setList(t).build();
            }
            if (o instanceof ParameterizedType.ParameterizedMap) {
                ParameterizedType.ParameterizedMap t = (ParameterizedType.ParameterizedMap)o;
                return bldr.setMap(t).build();
            }
            if (o instanceof Type.UUID) {
                Type.UUID t = (Type.UUID)o;
                return bldr.setUuid(t).build();
            }
            throw new UnsupportedOperationException("Unable to wrap type of " + o.getClass());
        }
    }
}

