/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extendedexpression;

import io.substrait.expression.Expression;
import io.substrait.extendedexpression.ExtendedExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ExtendedExpression.ExpressionReference", generator="Immutables")
public final class ImmutableExpressionReference
extends ExtendedExpression.ExpressionReference {
    private final List<String> outputNames;
    private final Expression expression;

    private ImmutableExpressionReference(List<String> outputNames, Expression expression) {
        this.outputNames = outputNames;
        this.expression = expression;
    }

    @Override
    public List<String> getOutputNames() {
        return this.outputNames;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public final ImmutableExpressionReference withOutputNames(String ... elements) {
        List<String> newValue = ImmutableExpressionReference.createUnmodifiableList(false, ImmutableExpressionReference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExpressionReference(newValue, this.expression);
    }

    public final ImmutableExpressionReference withOutputNames(Iterable<String> elements) {
        if (this.outputNames == elements) {
            return this;
        }
        List<String> newValue = ImmutableExpressionReference.createUnmodifiableList(false, ImmutableExpressionReference.createSafeList(elements, true, false));
        return new ImmutableExpressionReference(newValue, this.expression);
    }

    public final ImmutableExpressionReference withExpression(Expression value) {
        if (this.expression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "expression");
        return new ImmutableExpressionReference(this.outputNames, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExpressionReference && this.equalsByValue((ImmutableExpressionReference)another);
    }

    private boolean equalsByValue(ImmutableExpressionReference another) {
        return this.outputNames.equals(another.outputNames) && this.expression.equals(another.expression);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.outputNames.hashCode();
        h += (h << 5) + this.expression.hashCode();
        return h;
    }

    public String toString() {
        return "ExpressionReference{outputNames=" + this.outputNames + ", expression=" + this.expression + "}";
    }

    public static ImmutableExpressionReference copyOf(ExtendedExpression.ExpressionReference instance) {
        if (instance instanceof ImmutableExpressionReference) {
            return (ImmutableExpressionReference)instance;
        }
        return ImmutableExpressionReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ExtendedExpression.ExpressionReference", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EXPRESSION = 1L;
        private long initBits = 1L;
        private List<String> outputNames = new ArrayList<String>();
        private Expression expression;

        private Builder() {
        }

        public final Builder from(ExtendedExpression.ExpressionReference instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(ExtendedExpression.ExpressionReferenceBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ExtendedExpression.ExpressionReferenceBase instance;
            long bits = 0L;
            if (object instanceof ExtendedExpression.ExpressionReference) {
                instance = (ExtendedExpression.ExpressionReference)object;
                this.expression(((ExtendedExpression.ExpressionReference)instance).getExpression());
            }
            if (object instanceof ExtendedExpression.ExpressionReferenceBase) {
                instance = (ExtendedExpression.ExpressionReferenceBase)object;
                this.addAllOutputNames(instance.getOutputNames());
            }
        }

        public final Builder addOutputNames(String element) {
            this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            return this;
        }

        public final Builder addOutputNames(String ... elements) {
            for (String element : elements) {
                this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            }
            return this;
        }

        public final Builder outputNames(Iterable<String> elements) {
            this.outputNames.clear();
            return this.addAllOutputNames(elements);
        }

        public final Builder addAllOutputNames(Iterable<String> elements) {
            for (String element : elements) {
                this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            }
            return this;
        }

        public final Builder expression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableExpressionReference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExpressionReference(ImmutableExpressionReference.createUnmodifiableList(true, this.outputNames), this.expression);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expression");
            }
            return "Cannot build ExpressionReference, some of required attributes are not set " + attributes;
        }
    }
}

