/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.plan;

import io.substrait.extension.ExtensionCollector;
import io.substrait.plan.Plan;
import io.substrait.proto.Plan;
import io.substrait.proto.PlanRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelRoot;
import io.substrait.proto.Version;
import io.substrait.relation.RelProtoConverter;
import java.util.ArrayList;

public class PlanProtoConverter {
    public io.substrait.proto.Plan toProto(Plan plan) {
        ArrayList<PlanRel> planRels = new ArrayList<PlanRel>();
        ExtensionCollector functionCollector = new ExtensionCollector();
        for (Plan.Root root : plan.getRoots()) {
            Rel input = new RelProtoConverter(functionCollector).toProto(root.getInput());
            planRels.add(PlanRel.newBuilder().setRoot(RelRoot.newBuilder().setInput(input).addAllNames(root.getNames())).build());
        }
        Plan.Builder builder = io.substrait.proto.Plan.newBuilder().addAllRelations(planRels).addAllExpectedTypeUrls(plan.getExpectedTypeUrls());
        functionCollector.addExtensionsToPlan(builder);
        if (plan.getAdvancedExtension().isPresent()) {
            builder.setAdvancedExtensions(plan.getAdvancedExtension().get());
        }
        Version.Builder versionBuilder = Version.newBuilder().setMajorNumber(plan.getVersion().getMajor()).setMinorNumber(plan.getVersion().getMinor()).setPatchNumber(plan.getVersion().getPatch());
        plan.getVersion().getGitHash().ifPresent(gh -> versionBuilder.setGitHash((String)gh));
        plan.getVersion().getProducer().ifPresent(p -> versionBuilder.setProducer((String)p));
        builder.setVersion(versionBuilder);
        return builder.build();
    }
}

