/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.plan;

import io.substrait.extension.ExtensionLookup;
import io.substrait.extension.ImmutableExtensionLookup;
import io.substrait.extension.SimpleExtension;
import io.substrait.plan.ImmutableRoot;
import io.substrait.plan.ImmutableVersion;
import io.substrait.plan.Plan;
import io.substrait.proto.PlanRel;
import io.substrait.proto.RelRoot;
import io.substrait.relation.ProtoRelConverter;
import io.substrait.relation.Rel;
import java.util.ArrayList;
import java.util.Optional;

public class ProtoPlanConverter {
    protected final SimpleExtension.ExtensionCollection extensionCollection;

    public ProtoPlanConverter() {
        this(SimpleExtension.loadDefaults());
    }

    public ProtoPlanConverter(SimpleExtension.ExtensionCollection extensionCollection) {
        this.extensionCollection = extensionCollection;
    }

    protected ProtoRelConverter getProtoRelConverter(ExtensionLookup functionLookup) {
        return new ProtoRelConverter(functionLookup, this.extensionCollection);
    }

    public Plan from(io.substrait.proto.Plan plan) {
        ImmutableExtensionLookup functionLookup = ImmutableExtensionLookup.builder().from(plan).build();
        ProtoRelConverter relConverter = this.getProtoRelConverter(functionLookup);
        ArrayList<ImmutableRoot> roots = new ArrayList<ImmutableRoot>();
        for (PlanRel planRel : plan.getRelationsList()) {
            RelRoot root = planRel.getRoot();
            Rel rel = relConverter.from(root.getInput());
            roots.add(Plan.Root.builder().input(rel).names((Iterable<String>)root.getNamesList()).build());
        }
        ImmutableVersion.Builder versionBuilder = ImmutableVersion.builder().major(plan.getVersion().getMajorNumber()).minor(plan.getVersion().getMinorNumber()).patch(plan.getVersion().getPatchNumber());
        if (!plan.getVersion().getGitHash().isEmpty()) {
            versionBuilder.gitHash(Optional.of(plan.getVersion().getGitHash()));
        }
        if (!plan.getVersion().getProducer().isEmpty()) {
            versionBuilder.producer(Optional.of(plan.getVersion().getProducer()));
        }
        return Plan.builder().roots(roots).expectedTypeUrls((Iterable<String>)plan.getExpectedTypeUrlsList()).advancedExtension(Optional.ofNullable(plan.hasAdvancedExtensions() ? plan.getAdvancedExtensions() : null)).version(versionBuilder.build()).build();
    }
}

