/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression;

import io.substrait.expression.ImmutableWindowBound;
import org.immutables.value.Value;

@Value.Enclosing
public interface WindowBound {
    public static final CurrentRow CURRENT_ROW = ImmutableWindowBound.CurrentRow.builder().build();
    public static final Unbounded UNBOUNDED = ImmutableWindowBound.Unbounded.builder().build();

    public <R, E extends Throwable> R accept(WindowBoundVisitor<R, E> var1);

    @Value.Immutable
    public static abstract class CurrentRow
    implements WindowBound {
        @Override
        public <R, E extends Throwable> R accept(WindowBoundVisitor<R, E> visitor) {
            return visitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Unbounded
    implements WindowBound {
        @Override
        public <R, E extends Throwable> R accept(WindowBoundVisitor<R, E> visitor) {
            return visitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Following
    implements WindowBound {
        public abstract long offset();

        public static Following of(long offset) {
            return ImmutableWindowBound.Following.builder().offset(offset).build();
        }

        @Override
        public <R, E extends Throwable> R accept(WindowBoundVisitor<R, E> visitor) {
            return visitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Preceding
    implements WindowBound {
        public abstract long offset();

        public static Preceding of(long offset) {
            return ImmutableWindowBound.Preceding.builder().offset(offset).build();
        }

        @Override
        public <R, E extends Throwable> R accept(WindowBoundVisitor<R, E> visitor) {
            return visitor.visit(this);
        }
    }

    public static interface WindowBoundVisitor<R, E extends Throwable> {
        public R visit(Preceding var1);

        public R visit(Following var1);

        public R visit(CurrentRow var1);

        public R visit(Unbounded var1);
    }
}

