/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import io.substrait.extension.AdvancedExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="AdvancedExtension", generator="Immutables")
public final class ImmutableAdvancedExtension<O extends AdvancedExtension.Optimization, E extends AdvancedExtension.Enhancement>
extends AdvancedExtension<O, E> {
    private final List<O> optimizations;
    private final E enhancement;

    private ImmutableAdvancedExtension(List<O> optimizations, E enhancement) {
        this.optimizations = optimizations;
        this.enhancement = enhancement;
    }

    @Override
    public List<O> getOptimizations() {
        return this.optimizations;
    }

    @Override
    public Optional<E> getEnhancement() {
        return Optional.ofNullable(this.enhancement);
    }

    @SafeVarargs
    public final ImmutableAdvancedExtension<O, E> withOptimizations(O ... elements) {
        List<O> newValue = ImmutableAdvancedExtension.createUnmodifiableList(false, ImmutableAdvancedExtension.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAdvancedExtension<O, E>(newValue, this.enhancement);
    }

    public final ImmutableAdvancedExtension<O, E> withOptimizations(Iterable<? extends O> elements) {
        if (this.optimizations == elements) {
            return this;
        }
        List<? extends O> newValue = ImmutableAdvancedExtension.createUnmodifiableList(false, ImmutableAdvancedExtension.createSafeList(elements, true, false));
        return new ImmutableAdvancedExtension<O, E>(newValue, this.enhancement);
    }

    public final ImmutableAdvancedExtension<O, E> withEnhancement(E value) {
        AdvancedExtension.Enhancement newValue = (AdvancedExtension.Enhancement)Objects.requireNonNull(value, "enhancement");
        if (this.enhancement == newValue) {
            return this;
        }
        return new ImmutableAdvancedExtension<O, AdvancedExtension.Enhancement>(this.optimizations, newValue);
    }

    public final ImmutableAdvancedExtension<O, E> withEnhancement(Optional<? extends E> optional) {
        AdvancedExtension.Enhancement value = optional.orElse(null);
        if (this.enhancement == value) {
            return this;
        }
        return new ImmutableAdvancedExtension<O, AdvancedExtension.Enhancement>(this.optimizations, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdvancedExtension && this.equalsByValue((ImmutableAdvancedExtension)another);
    }

    private boolean equalsByValue(ImmutableAdvancedExtension<?, ?> another) {
        return this.optimizations.equals(another.optimizations) && Objects.equals(this.enhancement, another.enhancement);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.optimizations.hashCode();
        h += (h << 5) + Objects.hashCode(this.enhancement);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AdvancedExtension{");
        builder.append("optimizations=").append(this.optimizations);
        if (this.enhancement != null) {
            builder.append(", ");
            builder.append("enhancement=").append(this.enhancement);
        }
        return builder.append("}").toString();
    }

    public static <O extends AdvancedExtension.Optimization, E extends AdvancedExtension.Enhancement> ImmutableAdvancedExtension<O, E> copyOf(AdvancedExtension<O, E> instance) {
        if (instance instanceof ImmutableAdvancedExtension) {
            return (ImmutableAdvancedExtension)instance;
        }
        return ImmutableAdvancedExtension.builder().from(instance).build();
    }

    public static <O extends AdvancedExtension.Optimization, E extends AdvancedExtension.Enhancement> Builder<O, E> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    /* synthetic */ ImmutableAdvancedExtension(List x0, AdvancedExtension.Enhancement x1, 1 x2) {
        this(x0, x1);
    }

    @Generated(from="AdvancedExtension", generator="Immutables")
    public static final class Builder<O extends AdvancedExtension.Optimization, E extends AdvancedExtension.Enhancement> {
        private List<O> optimizations = new ArrayList<O>();
        private E enhancement;

        private Builder() {
        }

        public final Builder<O, E> from(AdvancedExtension<O, E> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllOptimizations(instance.getOptimizations());
            Optional<E> enhancementOptional = instance.getEnhancement();
            if (enhancementOptional.isPresent()) {
                this.enhancement(enhancementOptional);
            }
            return this;
        }

        public final Builder<O, E> addOptimizations(O element) {
            this.optimizations.add((AdvancedExtension.Optimization)Objects.requireNonNull(element, "optimizations element"));
            return this;
        }

        @SafeVarargs
        public final Builder<O, E> addOptimizations(O ... elements) {
            for (O element : elements) {
                this.optimizations.add((AdvancedExtension.Optimization)Objects.requireNonNull(element, "optimizations element"));
            }
            return this;
        }

        public final Builder<O, E> optimizations(Iterable<? extends O> elements) {
            this.optimizations.clear();
            return this.addAllOptimizations(elements);
        }

        public final Builder<O, E> addAllOptimizations(Iterable<? extends O> elements) {
            for (AdvancedExtension.Optimization element : elements) {
                this.optimizations.add(Objects.requireNonNull(element, "optimizations element"));
            }
            return this;
        }

        public final Builder<O, E> enhancement(E enhancement) {
            this.enhancement = (AdvancedExtension.Enhancement)Objects.requireNonNull(enhancement, "enhancement");
            return this;
        }

        public final Builder<O, E> enhancement(Optional<? extends E> enhancement) {
            this.enhancement = enhancement.orElse(null);
            return this;
        }

        public ImmutableAdvancedExtension<O, E> build() {
            return new ImmutableAdvancedExtension(ImmutableAdvancedExtension.createUnmodifiableList(true, this.optimizations), (AdvancedExtension.Enhancement)this.enhancement, null);
        }
    }
}

