/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.util.VisitationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class CopyOnWriteUtils {
    public static boolean allEmpty(Optional<?> ... optionals) {
        return Arrays.stream(optionals).noneMatch(Optional::isPresent);
    }

    public static <T> Optional<T> or(Optional<T> left, Supplier<? extends Optional<T>> right) {
        if (left.isPresent()) {
            return left;
        }
        return right.get();
    }

    public static <I, C extends VisitationContext, E extends Exception> Optional<List<I>> transformList(List<I> items, C context, TransformFunction<I, C, E> transform) throws E {
        ArrayList<I> newItems = new ArrayList<I>();
        boolean listUpdated = false;
        for (I item : items) {
            Optional<I> newItem = transform.apply(item, context);
            if (newItem.isPresent()) {
                newItems.add(newItem.get());
                listUpdated = true;
                continue;
            }
            newItems.add(item);
        }
        return listUpdated ? Optional.of(newItems) : Optional.empty();
    }

    @FunctionalInterface
    public static interface TransformFunction<T, C extends VisitationContext, E extends Exception> {
        public Optional<T> apply(T var1, C var2) throws E;
    }
}

