/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.proto.JoinRel;
import io.substrait.relation.BiRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.ImmutableJoin;
import io.substrait.relation.RelVisitor;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import io.substrait.util.VisitationContext;
import java.util.Optional;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Join
extends BiRel
implements HasExtension {
    public abstract Optional<Expression> getCondition();

    public abstract Optional<Expression> getPostJoinFilter();

    public abstract JoinType getJoinType();

    @Override
    protected Type.Struct deriveRecordType() {
        Stream<Type> leftTypes = this.getLeftTypes();
        Stream<Type> rightTypes = this.getRightTypes();
        return TypeCreator.REQUIRED.struct(Stream.concat(leftTypes, rightTypes));
    }

    private Stream<Type> getLeftTypes() {
        switch (this.getJoinType()) {
            case RIGHT: 
            case OUTER: 
            case RIGHT_SINGLE: {
                return this.getLeft().getRecordType().fields().stream().map(TypeCreator::asNullable);
            }
            case RIGHT_SEMI: 
            case RIGHT_ANTI: {
                return Stream.of(new Type[0]);
            }
            case RIGHT_MARK: {
                return Stream.of(TypeCreator.REQUIRED.BOOLEAN);
            }
        }
        return this.getLeft().getRecordType().fields().stream();
    }

    private Stream<Type> getRightTypes() {
        switch (this.getJoinType()) {
            case OUTER: 
            case LEFT: 
            case LEFT_SINGLE: {
                return this.getRight().getRecordType().fields().stream().map(TypeCreator::asNullable);
            }
            case SEMI: 
            case ANTI: 
            case LEFT_SEMI: 
            case LEFT_ANTI: {
                return Stream.of(new Type[0]);
            }
            case LEFT_MARK: {
                return Stream.of(TypeCreator.REQUIRED.BOOLEAN);
            }
        }
        return this.getRight().getRecordType().fields().stream();
    }

    @Override
    public <O, C extends VisitationContext, E extends Exception> O accept(RelVisitor<O, C, E> visitor, C context) throws E {
        return visitor.visit(this, context);
    }

    public static ImmutableJoin.Builder builder() {
        return ImmutableJoin.builder();
    }

    public static enum JoinType {
        UNKNOWN(JoinRel.JoinType.JOIN_TYPE_UNSPECIFIED),
        INNER(JoinRel.JoinType.JOIN_TYPE_INNER),
        OUTER(JoinRel.JoinType.JOIN_TYPE_OUTER),
        LEFT(JoinRel.JoinType.JOIN_TYPE_LEFT),
        RIGHT(JoinRel.JoinType.JOIN_TYPE_RIGHT),
        LEFT_SEMI(JoinRel.JoinType.JOIN_TYPE_LEFT_SEMI),
        LEFT_ANTI(JoinRel.JoinType.JOIN_TYPE_LEFT_ANTI),
        LEFT_SINGLE(JoinRel.JoinType.JOIN_TYPE_LEFT_SINGLE),
        RIGHT_SEMI(JoinRel.JoinType.JOIN_TYPE_RIGHT_SEMI),
        RIGHT_ANTI(JoinRel.JoinType.JOIN_TYPE_RIGHT_ANTI),
        RIGHT_SINGLE(JoinRel.JoinType.JOIN_TYPE_RIGHT_SINGLE),
        LEFT_MARK(JoinRel.JoinType.JOIN_TYPE_LEFT_MARK),
        RIGHT_MARK(JoinRel.JoinType.JOIN_TYPE_RIGHT_MARK),
        SEMI(JoinRel.JoinType.JOIN_TYPE_LEFT_SEMI),
        ANTI(JoinRel.JoinType.JOIN_TYPE_LEFT_ANTI);

        private JoinRel.JoinType proto;

        private JoinType(JoinRel.JoinType proto) {
            this.proto = proto;
        }

        public JoinRel.JoinType toProto() {
            return this.proto;
        }

        public static JoinType fromProto(JoinRel.JoinType proto) {
            for (JoinType v : JoinType.values()) {
                if (v.proto != proto) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown type: " + (Object)((Object)proto));
        }
    }
}

