/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation.physical;

import io.substrait.expression.Expression;
import io.substrait.expression.FieldReference;
import io.substrait.proto.MergeJoinRel;
import io.substrait.relation.BiRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.RelVisitor;
import io.substrait.relation.physical.ImmutableMergeJoin;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import io.substrait.util.VisitationContext;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public abstract class MergeJoin
extends BiRel
implements HasExtension {
    public abstract List<FieldReference> getLeftKeys();

    public abstract List<FieldReference> getRightKeys();

    public abstract JoinType getJoinType();

    public abstract Optional<Expression> getPostJoinFilter();

    @Override
    protected Type.Struct deriveRecordType() {
        Stream<Type> leftTypes = this.getLeftTypes();
        Stream<Type> rightTypes = this.getRightTypes();
        return TypeCreator.REQUIRED.struct(Stream.concat(leftTypes, rightTypes));
    }

    private Stream<Type> getLeftTypes() {
        switch (this.getJoinType()) {
            case LEFT: 
            case OUTER: {
                return this.getRight().getRecordType().fields().stream().map(TypeCreator::asNullable);
            }
            case LEFT_ANTI: 
            case LEFT_SEMI: {
                return Stream.empty();
            }
        }
        return this.getRight().getRecordType().fields().stream();
    }

    private Stream<Type> getRightTypes() {
        switch (this.getJoinType()) {
            case LEFT: 
            case OUTER: {
                return this.getRight().getRecordType().fields().stream().map(TypeCreator::asNullable);
            }
            case LEFT_ANTI: 
            case LEFT_SEMI: {
                return Stream.empty();
            }
        }
        return this.getRight().getRecordType().fields().stream();
    }

    @Override
    public <O, C extends VisitationContext, E extends Exception> O accept(RelVisitor<O, C, E> visitor, C context) throws E {
        return visitor.visit(this, context);
    }

    public static ImmutableMergeJoin.Builder builder() {
        return ImmutableMergeJoin.builder();
    }

    public static enum JoinType {
        UNKNOWN(MergeJoinRel.JoinType.JOIN_TYPE_UNSPECIFIED),
        INNER(MergeJoinRel.JoinType.JOIN_TYPE_INNER),
        OUTER(MergeJoinRel.JoinType.JOIN_TYPE_OUTER),
        LEFT(MergeJoinRel.JoinType.JOIN_TYPE_LEFT),
        RIGHT(MergeJoinRel.JoinType.JOIN_TYPE_RIGHT),
        LEFT_SEMI(MergeJoinRel.JoinType.JOIN_TYPE_LEFT_SEMI),
        RIGHT_SEMI(MergeJoinRel.JoinType.JOIN_TYPE_RIGHT_SEMI),
        LEFT_ANTI(MergeJoinRel.JoinType.JOIN_TYPE_LEFT_ANTI),
        RIGHT_ANTI(MergeJoinRel.JoinType.JOIN_TYPE_RIGHT_ANTI);

        private MergeJoinRel.JoinType proto;

        private JoinType(MergeJoinRel.JoinType proto) {
            this.proto = proto;
        }

        public static JoinType fromProto(MergeJoinRel.JoinType proto) {
            for (JoinType v : JoinType.values()) {
                if (v.proto != proto) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown type: " + (Object)((Object)proto));
        }

        public MergeJoinRel.JoinType toProto() {
            return this.proto;
        }
    }
}

