/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type;

import io.substrait.function.NullableType;
import io.substrait.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Type", generator="Immutables")
public final class ImmutableType {
    private ImmutableType() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Type.UserDefined", generator="Immutables")
    public static final class UserDefined
    extends Type.UserDefined {
        private final boolean nullable;
        private final String urn;
        private final String name;

        private UserDefined(boolean nullable, String urn, String name) {
            this.nullable = nullable;
            this.urn = urn;
            this.name = name;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public String urn() {
            return this.urn;
        }

        @Override
        public String name() {
            return this.name;
        }

        public final UserDefined withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new UserDefined(value, this.urn, this.name);
        }

        public final UserDefined withUrn(String value) {
            String newValue = Objects.requireNonNull(value, "urn");
            if (this.urn.equals(newValue)) {
                return this;
            }
            return new UserDefined(this.nullable, newValue, this.name);
        }

        public final UserDefined withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new UserDefined(this.nullable, this.urn, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof UserDefined && this.equalsByValue((UserDefined)another);
        }

        private boolean equalsByValue(UserDefined another) {
            return this.nullable == another.nullable && this.urn.equals(another.urn) && this.name.equals(another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.urn.hashCode();
            h += (h << 5) + this.name.hashCode();
            return h;
        }

        public String toString() {
            return "UserDefined{nullable=" + this.nullable + ", urn=" + this.urn + ", name=" + this.name + "}";
        }

        public static UserDefined copyOf(Type.UserDefined instance) {
            if (instance instanceof UserDefined) {
                return (UserDefined)instance;
            }
            return UserDefined.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.UserDefined", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_URN = 2L;
            private static final long INIT_BIT_NAME = 4L;
            private long initBits = 7L;
            private boolean nullable;
            private String urn;
            private String name;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.UserDefined instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.UserDefined) {
                    instance = (Type.UserDefined)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.urn(((Type.UserDefined)instance).urn());
                    this.name(((Type.UserDefined)instance).name());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder urn(String urn) {
                this.urn = Objects.requireNonNull(urn, "urn");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public UserDefined build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new UserDefined(this.nullable, this.urn, this.name);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("urn");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build UserDefined, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Map", generator="Immutables")
    public static final class Map
    extends Type.Map {
        private final boolean nullable;
        private final Type key;
        private final Type value;

        private Map(boolean nullable, Type key, Type value) {
            this.nullable = nullable;
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Type key() {
            return this.key;
        }

        @Override
        public Type value() {
            return this.value;
        }

        public final Map withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Map(value, this.key, this.value);
        }

        public final Map withKey(Type value) {
            if (this.key == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "key");
            return new Map(this.nullable, newValue, this.value);
        }

        public final Map withValue(Type value) {
            if (this.value == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "value");
            return new Map(this.nullable, this.key, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Map && this.equalsByValue((Map)another);
        }

        private boolean equalsByValue(Map another) {
            return this.nullable == another.nullable && this.key.equals(another.key) && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.key.hashCode();
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "Map{nullable=" + this.nullable + ", key=" + this.key + ", value=" + this.value + "}";
        }

        public static Map copyOf(Type.Map instance) {
            if (instance instanceof Map) {
                return (Map)instance;
            }
            return Map.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Map", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_KEY = 2L;
            private static final long INIT_BIT_VALUE = 4L;
            private long initBits = 7L;
            private boolean nullable;
            private Type key;
            private Type value;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.Map instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.Map) {
                    instance = (Type.Map)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Type.Map)instance).value());
                    this.key(((Type.Map)instance).key());
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder key(Type key) {
                this.key = Objects.requireNonNull(key, "key");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder value(Type value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Map build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Map(this.nullable, this.key, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("key");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build Map, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.ListType", generator="Immutables")
    public static final class ListType
    extends Type.ListType {
        private final boolean nullable;
        private final Type elementType;

        private ListType(boolean nullable, Type elementType) {
            this.nullable = nullable;
            this.elementType = elementType;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Type elementType() {
            return this.elementType;
        }

        public final ListType withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new ListType(value, this.elementType);
        }

        public final ListType withElementType(Type value) {
            if (this.elementType == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "elementType");
            return new ListType(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ListType && this.equalsByValue((ListType)another);
        }

        private boolean equalsByValue(ListType another) {
            return this.nullable == another.nullable && this.elementType.equals(another.elementType);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.elementType.hashCode();
            return h;
        }

        public String toString() {
            return "ListType{nullable=" + this.nullable + ", elementType=" + this.elementType + "}";
        }

        public static ListType copyOf(Type.ListType instance) {
            if (instance instanceof ListType) {
                return (ListType)instance;
            }
            return ListType.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.ListType", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_ELEMENT_TYPE = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private Type elementType;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.ListType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.ListType) {
                    instance = (Type.ListType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.elementType(((Type.ListType)instance).elementType());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder elementType(Type elementType) {
                this.elementType = Objects.requireNonNull(elementType, "elementType");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public ListType build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ListType(this.nullable, this.elementType);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("elementType");
                }
                return "Cannot build ListType, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Struct", generator="Immutables")
    public static final class Struct
    extends Type.Struct {
        private final boolean nullable;
        private final List<Type> fields;

        private Struct(boolean nullable, List<Type> fields) {
            this.nullable = nullable;
            this.fields = fields;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public List<Type> fields() {
            return this.fields;
        }

        public final Struct withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Struct(value, this.fields);
        }

        public final Struct withFields(Type ... elements) {
            List newValue = ImmutableType.createUnmodifiableList(false, ImmutableType.createSafeList(Arrays.asList(elements), true, false));
            return new Struct(this.nullable, newValue);
        }

        public final Struct withFields(Iterable<? extends Type> elements) {
            if (this.fields == elements) {
                return this;
            }
            List newValue = ImmutableType.createUnmodifiableList(false, ImmutableType.createSafeList(elements, true, false));
            return new Struct(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Struct && this.equalsByValue((Struct)another);
        }

        private boolean equalsByValue(Struct another) {
            return this.nullable == another.nullable && this.fields.equals(another.fields);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.fields.hashCode();
            return h;
        }

        public String toString() {
            return "Struct{nullable=" + this.nullable + ", fields=" + this.fields + "}";
        }

        public static Struct copyOf(Type.Struct instance) {
            if (instance instanceof Struct) {
                return (Struct)instance;
            }
            return Struct.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Struct", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;
            private List<Type> fields = new ArrayList<Type>();

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.Struct instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.Struct) {
                    instance = (Type.Struct)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.addAllFields(((Type.Struct)instance).fields());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addFields(Type element) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
                return this;
            }

            public final Builder addFields(Type ... elements) {
                for (Type element : elements) {
                    this.fields.add(Objects.requireNonNull(element, "fields element"));
                }
                return this;
            }

            public final Builder fields(Iterable<? extends Type> elements) {
                this.fields.clear();
                return this.addAllFields(elements);
            }

            public final Builder addAllFields(Iterable<? extends Type> elements) {
                for (Type type : elements) {
                    this.fields.add(Objects.requireNonNull(type, "fields element"));
                }
                return this;
            }

            public Struct build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Struct(this.nullable, ImmutableType.createUnmodifiableList(true, this.fields));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Struct, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.PrecisionTimestampTZ", generator="Immutables")
    public static final class PrecisionTimestampTZ
    extends Type.PrecisionTimestampTZ {
        private final boolean nullable;
        private final int precision;

        private PrecisionTimestampTZ(boolean nullable, int precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final PrecisionTimestampTZ withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new PrecisionTimestampTZ(value, this.precision);
        }

        public final PrecisionTimestampTZ withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new PrecisionTimestampTZ(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PrecisionTimestampTZ && this.equalsByValue((PrecisionTimestampTZ)another);
        }

        private boolean equalsByValue(PrecisionTimestampTZ another) {
            return this.nullable == another.nullable && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "PrecisionTimestampTZ{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static PrecisionTimestampTZ copyOf(Type.PrecisionTimestampTZ instance) {
            if (instance instanceof PrecisionTimestampTZ) {
                return (PrecisionTimestampTZ)instance;
            }
            return PrecisionTimestampTZ.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.PrecisionTimestampTZ", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.PrecisionTimestampTZ instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.PrecisionTimestampTZ) {
                    instance = (Type.PrecisionTimestampTZ)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((Type.PrecisionTimestampTZ)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PrecisionTimestampTZ build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PrecisionTimestampTZ(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build PrecisionTimestampTZ, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.PrecisionTimestamp", generator="Immutables")
    public static final class PrecisionTimestamp
    extends Type.PrecisionTimestamp {
        private final boolean nullable;
        private final int precision;

        private PrecisionTimestamp(boolean nullable, int precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final PrecisionTimestamp withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new PrecisionTimestamp(value, this.precision);
        }

        public final PrecisionTimestamp withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new PrecisionTimestamp(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PrecisionTimestamp && this.equalsByValue((PrecisionTimestamp)another);
        }

        private boolean equalsByValue(PrecisionTimestamp another) {
            return this.nullable == another.nullable && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "PrecisionTimestamp{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static PrecisionTimestamp copyOf(Type.PrecisionTimestamp instance) {
            if (instance instanceof PrecisionTimestamp) {
                return (PrecisionTimestamp)instance;
            }
            return PrecisionTimestamp.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.PrecisionTimestamp", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.PrecisionTimestamp instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.PrecisionTimestamp) {
                    instance = (Type.PrecisionTimestamp)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((Type.PrecisionTimestamp)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PrecisionTimestamp build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PrecisionTimestamp(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build PrecisionTimestamp, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.PrecisionTime", generator="Immutables")
    public static final class PrecisionTime
    extends Type.PrecisionTime {
        private final boolean nullable;
        private final int precision;

        private PrecisionTime(boolean nullable, int precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final PrecisionTime withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new PrecisionTime(value, this.precision);
        }

        public final PrecisionTime withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new PrecisionTime(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PrecisionTime && this.equalsByValue((PrecisionTime)another);
        }

        private boolean equalsByValue(PrecisionTime another) {
            return this.nullable == another.nullable && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "PrecisionTime{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static PrecisionTime copyOf(Type.PrecisionTime instance) {
            if (instance instanceof PrecisionTime) {
                return (PrecisionTime)instance;
            }
            return PrecisionTime.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.PrecisionTime", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.PrecisionTime instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.PrecisionTime) {
                    instance = (Type.PrecisionTime)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((Type.PrecisionTime)instance).precision());
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PrecisionTime build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PrecisionTime(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build PrecisionTime, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Decimal", generator="Immutables")
    public static final class Decimal
    extends Type.Decimal {
        private final boolean nullable;
        private final int scale;
        private final int precision;

        private Decimal(boolean nullable, int scale, int precision) {
            this.nullable = nullable;
            this.scale = scale;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int scale() {
            return this.scale;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final Decimal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Decimal(value, this.scale, this.precision);
        }

        public final Decimal withScale(int value) {
            if (this.scale == value) {
                return this;
            }
            return new Decimal(this.nullable, value, this.precision);
        }

        public final Decimal withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new Decimal(this.nullable, this.scale, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Decimal && this.equalsByValue((Decimal)another);
        }

        private boolean equalsByValue(Decimal another) {
            return this.nullable == another.nullable && this.scale == another.scale && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.scale;
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "Decimal{nullable=" + this.nullable + ", scale=" + this.scale + ", precision=" + this.precision + "}";
        }

        public static Decimal copyOf(Type.Decimal instance) {
            if (instance instanceof Decimal) {
                return (Decimal)instance;
            }
            return Decimal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Decimal", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_SCALE = 2L;
            private static final long INIT_BIT_PRECISION = 4L;
            private long initBits = 7L;
            private boolean nullable;
            private int scale;
            private int precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.Decimal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.Decimal) {
                    instance = (Type.Decimal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.scale(((Type.Decimal)instance).scale());
                    this.precision(((Type.Decimal)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder scale(int scale) {
                this.scale = scale;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Decimal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Decimal(this.nullable, this.scale, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("scale");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build Decimal, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.FixedBinary", generator="Immutables")
    public static final class FixedBinary
    extends Type.FixedBinary {
        private final boolean nullable;
        private final int length;

        private FixedBinary(boolean nullable, int length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int length() {
            return this.length;
        }

        public final FixedBinary withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedBinary(value, this.length);
        }

        public final FixedBinary withLength(int value) {
            if (this.length == value) {
                return this;
            }
            return new FixedBinary(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedBinary && this.equalsByValue((FixedBinary)another);
        }

        private boolean equalsByValue(FixedBinary another) {
            return this.nullable == another.nullable && this.length == another.length;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length;
            return h;
        }

        public String toString() {
            return "FixedBinary{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static FixedBinary copyOf(Type.FixedBinary instance) {
            if (instance instanceof FixedBinary) {
                return (FixedBinary)instance;
            }
            return FixedBinary.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.FixedBinary", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int length;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.FixedBinary instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.FixedBinary) {
                    instance = (Type.FixedBinary)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.length(((Type.FixedBinary)instance).length());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(int length) {
                this.length = length;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FixedBinary build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedBinary(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build FixedBinary, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.VarChar", generator="Immutables")
    public static final class VarChar
    extends Type.VarChar {
        private final boolean nullable;
        private final int length;

        private VarChar(boolean nullable, int length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int length() {
            return this.length;
        }

        public final VarChar withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new VarChar(value, this.length);
        }

        public final VarChar withLength(int value) {
            if (this.length == value) {
                return this;
            }
            return new VarChar(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof VarChar && this.equalsByValue((VarChar)another);
        }

        private boolean equalsByValue(VarChar another) {
            return this.nullable == another.nullable && this.length == another.length;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length;
            return h;
        }

        public String toString() {
            return "VarChar{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static VarChar copyOf(Type.VarChar instance) {
            if (instance instanceof VarChar) {
                return (VarChar)instance;
            }
            return VarChar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.VarChar", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int length;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.VarChar instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.VarChar) {
                    instance = (Type.VarChar)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.length(((Type.VarChar)instance).length());
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(int length) {
                this.length = length;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public VarChar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new VarChar(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build VarChar, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.FixedChar", generator="Immutables")
    public static final class FixedChar
    extends Type.FixedChar {
        private final boolean nullable;
        private final int length;

        private FixedChar(boolean nullable, int length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int length() {
            return this.length;
        }

        public final FixedChar withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedChar(value, this.length);
        }

        public final FixedChar withLength(int value) {
            if (this.length == value) {
                return this;
            }
            return new FixedChar(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedChar && this.equalsByValue((FixedChar)another);
        }

        private boolean equalsByValue(FixedChar another) {
            return this.nullable == another.nullable && this.length == another.length;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length;
            return h;
        }

        public String toString() {
            return "FixedChar{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static FixedChar copyOf(Type.FixedChar instance) {
            if (instance instanceof FixedChar) {
                return (FixedChar)instance;
            }
            return FixedChar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.FixedChar", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int length;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.FixedChar instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.FixedChar) {
                    instance = (Type.FixedChar)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.length(((Type.FixedChar)instance).length());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(int length) {
                this.length = length;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FixedChar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedChar(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build FixedChar, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.UUID", generator="Immutables")
    public static final class UUID
    extends Type.UUID {
        private final boolean nullable;

        private UUID(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final UUID withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new UUID(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof UUID && this.equalsByValue((UUID)another);
        }

        private boolean equalsByValue(UUID another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "UUID{nullable=" + this.nullable + "}";
        }

        public static UUID copyOf(Type.UUID instance) {
            if (instance instanceof UUID) {
                return (UUID)instance;
            }
            return UUID.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.UUID", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(Type.UUID instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof Type.UUID) {
                    instance = (Type.UUID)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public UUID build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new UUID(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build UUID, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.IntervalCompound", generator="Immutables")
    public static final class IntervalCompound
    extends Type.IntervalCompound {
        private final boolean nullable;
        private final int precision;

        private IntervalCompound(boolean nullable, int precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final IntervalCompound withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalCompound(value, this.precision);
        }

        public final IntervalCompound withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new IntervalCompound(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalCompound && this.equalsByValue((IntervalCompound)another);
        }

        private boolean equalsByValue(IntervalCompound another) {
            return this.nullable == another.nullable && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "IntervalCompound{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static IntervalCompound copyOf(Type.IntervalCompound instance) {
            if (instance instanceof IntervalCompound) {
                return (IntervalCompound)instance;
            }
            return IntervalCompound.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.IntervalCompound", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.IntervalCompound instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.IntervalCompound) {
                    instance = (Type.IntervalCompound)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((Type.IntervalCompound)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public IntervalCompound build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalCompound(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build IntervalCompound, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.IntervalDay", generator="Immutables")
    public static final class IntervalDay
    extends Type.IntervalDay {
        private final boolean nullable;
        private final int precision;

        private IntervalDay(boolean nullable, int precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final IntervalDay withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalDay(value, this.precision);
        }

        public final IntervalDay withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new IntervalDay(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalDay && this.equalsByValue((IntervalDay)another);
        }

        private boolean equalsByValue(IntervalDay another) {
            return this.nullable == another.nullable && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "IntervalDay{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static IntervalDay copyOf(Type.IntervalDay instance) {
            if (instance instanceof IntervalDay) {
                return (IntervalDay)instance;
            }
            return IntervalDay.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.IntervalDay", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private int precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.IntervalDay instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.IntervalDay) {
                    instance = (Type.IntervalDay)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((Type.IntervalDay)instance).precision());
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public IntervalDay build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalDay(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build IntervalDay, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.IntervalYear", generator="Immutables")
    public static final class IntervalYear
    extends Type.IntervalYear {
        private final boolean nullable;

        private IntervalYear(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final IntervalYear withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalYear(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalYear && this.equalsByValue((IntervalYear)another);
        }

        private boolean equalsByValue(IntervalYear another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "IntervalYear{nullable=" + this.nullable + "}";
        }

        public static IntervalYear copyOf(Type.IntervalYear instance) {
            if (instance instanceof IntervalYear) {
                return (IntervalYear)instance;
            }
            return IntervalYear.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.IntervalYear", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.IntervalYear instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.IntervalYear) {
                    instance = (Type.IntervalYear)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IntervalYear build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalYear(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build IntervalYear, some of required attributes are not set " + attributes;
            }
        }
    }

    @Deprecated
    @Generated(from="Type.Timestamp", generator="Immutables")
    public static final class Timestamp
    extends Type.Timestamp {
        private final boolean nullable;

        private Timestamp(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Timestamp withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Timestamp(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Timestamp && this.equalsByValue((Timestamp)another);
        }

        private boolean equalsByValue(Timestamp another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Timestamp{nullable=" + this.nullable + "}";
        }

        public static Timestamp copyOf(Type.Timestamp instance) {
            if (instance instanceof Timestamp) {
                return (Timestamp)instance;
            }
            return Timestamp.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Timestamp", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(Type.Timestamp instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof Type.Timestamp) {
                    instance = (Type.Timestamp)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Timestamp build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Timestamp(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Timestamp, some of required attributes are not set " + attributes;
            }
        }
    }

    @Deprecated
    @Generated(from="Type.TimestampTZ", generator="Immutables")
    public static final class TimestampTZ
    extends Type.TimestampTZ {
        private final boolean nullable;

        private TimestampTZ(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final TimestampTZ withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new TimestampTZ(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TimestampTZ && this.equalsByValue((TimestampTZ)another);
        }

        private boolean equalsByValue(TimestampTZ another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "TimestampTZ{nullable=" + this.nullable + "}";
        }

        public static TimestampTZ copyOf(Type.TimestampTZ instance) {
            if (instance instanceof TimestampTZ) {
                return (TimestampTZ)instance;
            }
            return TimestampTZ.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.TimestampTZ", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.TimestampTZ instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.TimestampTZ) {
                    instance = (Type.TimestampTZ)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public TimestampTZ build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TimestampTZ(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build TimestampTZ, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Time", generator="Immutables")
    public static final class Time
    extends Type.Time {
        private final boolean nullable;

        private Time(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Time withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Time(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Time && this.equalsByValue((Time)another);
        }

        private boolean equalsByValue(Time another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Time{nullable=" + this.nullable + "}";
        }

        public static Time copyOf(Type.Time instance) {
            if (instance instanceof Time) {
                return (Time)instance;
            }
            return Time.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Time", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.Time instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.Time) {
                    instance = (Type.Time)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Time build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Time(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Time, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Date", generator="Immutables")
    public static final class Date
    extends Type.Date {
        private final boolean nullable;

        private Date(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Date withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Date(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Date && this.equalsByValue((Date)another);
        }

        private boolean equalsByValue(Date another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Date{nullable=" + this.nullable + "}";
        }

        public static Date copyOf(Type.Date instance) {
            if (instance instanceof Date) {
                return (Date)instance;
            }
            return Date.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Date", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.Date instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.Date) {
                    instance = (Type.Date)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Date build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Date(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Date, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Binary", generator="Immutables")
    public static final class Binary
    extends Type.Binary {
        private final boolean nullable;

        private Binary(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Binary withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Binary(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Binary && this.equalsByValue((Binary)another);
        }

        private boolean equalsByValue(Binary another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Binary{nullable=" + this.nullable + "}";
        }

        public static Binary copyOf(Type.Binary instance) {
            if (instance instanceof Binary) {
                return (Binary)instance;
            }
            return Binary.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Binary", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.Binary instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.Binary) {
                    instance = (Type.Binary)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Binary build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Binary(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Binary, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Str", generator="Immutables")
    public static final class Str
    extends Type.Str {
        private final boolean nullable;

        private Str(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Str withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Str(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Str && this.equalsByValue((Str)another);
        }

        private boolean equalsByValue(Str another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Str{nullable=" + this.nullable + "}";
        }

        public static Str copyOf(Type.Str instance) {
            if (instance instanceof Str) {
                return (Str)instance;
            }
            return Str.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Str", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.Str instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.Str) {
                    instance = (Type.Str)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Str build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Str(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Str, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.FP64", generator="Immutables")
    public static final class FP64
    extends Type.FP64 {
        private final boolean nullable;

        private FP64(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final FP64 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FP64(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FP64 && this.equalsByValue((FP64)another);
        }

        private boolean equalsByValue(FP64 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "FP64{nullable=" + this.nullable + "}";
        }

        public static FP64 copyOf(Type.FP64 instance) {
            if (instance instanceof FP64) {
                return (FP64)instance;
            }
            return FP64.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.FP64", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.FP64 instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.FP64) {
                    instance = (Type.FP64)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public FP64 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FP64(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build FP64, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.FP32", generator="Immutables")
    public static final class FP32
    extends Type.FP32 {
        private final boolean nullable;

        private FP32(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final FP32 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FP32(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FP32 && this.equalsByValue((FP32)another);
        }

        private boolean equalsByValue(FP32 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "FP32{nullable=" + this.nullable + "}";
        }

        public static FP32 copyOf(Type.FP32 instance) {
            if (instance instanceof FP32) {
                return (FP32)instance;
            }
            return FP32.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.FP32", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.FP32 instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.FP32) {
                    instance = (Type.FP32)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public FP32 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FP32(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build FP32, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.I64", generator="Immutables")
    public static final class I64
    extends Type.I64 {
        private final boolean nullable;

        private I64(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final I64 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I64(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I64 && this.equalsByValue((I64)another);
        }

        private boolean equalsByValue(I64 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "I64{nullable=" + this.nullable + "}";
        }

        public static I64 copyOf(Type.I64 instance) {
            if (instance instanceof I64) {
                return (I64)instance;
            }
            return I64.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.I64", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(Type.I64 instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof Type.I64) {
                    instance = (Type.I64)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I64 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I64(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build I64, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.I32", generator="Immutables")
    public static final class I32
    extends Type.I32 {
        private final boolean nullable;

        private I32(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final I32 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I32(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I32 && this.equalsByValue((I32)another);
        }

        private boolean equalsByValue(I32 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "I32{nullable=" + this.nullable + "}";
        }

        public static I32 copyOf(Type.I32 instance) {
            if (instance instanceof I32) {
                return (I32)instance;
            }
            return I32.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.I32", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.I32 instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.I32) {
                    instance = (Type.I32)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I32 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I32(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build I32, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.I16", generator="Immutables")
    public static final class I16
    extends Type.I16 {
        private final boolean nullable;

        private I16(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final I16 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I16(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I16 && this.equalsByValue((I16)another);
        }

        private boolean equalsByValue(I16 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "I16{nullable=" + this.nullable + "}";
        }

        public static I16 copyOf(Type.I16 instance) {
            if (instance instanceof I16) {
                return (I16)instance;
            }
            return I16.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.I16", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.I16 instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.I16) {
                    instance = (Type.I16)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I16 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I16(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build I16, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.I8", generator="Immutables")
    public static final class I8
    extends Type.I8 {
        private final boolean nullable;

        private I8(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final I8 withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I8(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I8 && this.equalsByValue((I8)another);
        }

        private boolean equalsByValue(I8 another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "I8{nullable=" + this.nullable + "}";
        }

        public static I8 copyOf(Type.I8 instance) {
            if (instance instanceof I8) {
                return (I8)instance;
            }
            return I8.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.I8", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.I8 instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.I8) {
                    instance = (Type.I8)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I8 build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I8(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build I8, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="Type.Bool", generator="Immutables")
    public static final class Bool
    extends Type.Bool {
        private final boolean nullable;

        private Bool(boolean nullable) {
            this.nullable = nullable;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public final Bool withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Bool(value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Bool && this.equalsByValue((Bool)another);
        }

        private boolean equalsByValue(Bool another) {
            return this.nullable == another.nullable;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            return h;
        }

        public String toString() {
            return "Bool{nullable=" + this.nullable + "}";
        }

        public static Bool copyOf(Type.Bool instance) {
            if (instance instanceof Bool) {
                return (Bool)instance;
            }
            return Bool.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Type.Bool", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type.Bool instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Type instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type.Bool) {
                    instance = (Type.Bool)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Type) {
                    instance = (Type)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Bool build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Bool(this.nullable);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Bool, some of required attributes are not set " + attributes;
            }
        }
    }
}

