/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type.proto;

import io.substrait.extension.ExtensionLookup;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.Type;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import java.util.stream.Collectors;

public class ProtoTypeConverter {
    private final ExtensionLookup lookup;
    private final SimpleExtension.ExtensionCollection extensions;

    public ProtoTypeConverter(ExtensionLookup lookup, SimpleExtension.ExtensionCollection extensions) {
        this.lookup = lookup;
        this.extensions = extensions;
    }

    public Type from(io.substrait.proto.Type type) {
        switch (type.getKindCase()) {
            case BOOL: {
                return ProtoTypeConverter.n((Type.Nullability)type.getBool().getNullability()).BOOLEAN;
            }
            case I8: {
                return ProtoTypeConverter.n((Type.Nullability)type.getI8().getNullability()).I8;
            }
            case I16: {
                return ProtoTypeConverter.n((Type.Nullability)type.getI16().getNullability()).I16;
            }
            case I32: {
                return ProtoTypeConverter.n((Type.Nullability)type.getI32().getNullability()).I32;
            }
            case I64: {
                return ProtoTypeConverter.n((Type.Nullability)type.getI64().getNullability()).I64;
            }
            case FP32: {
                return ProtoTypeConverter.n((Type.Nullability)type.getFp32().getNullability()).FP32;
            }
            case FP64: {
                return ProtoTypeConverter.n((Type.Nullability)type.getFp64().getNullability()).FP64;
            }
            case STRING: {
                return ProtoTypeConverter.n((Type.Nullability)type.getString().getNullability()).STRING;
            }
            case BINARY: {
                return ProtoTypeConverter.n((Type.Nullability)type.getBinary().getNullability()).BINARY;
            }
            case TIMESTAMP: {
                return ProtoTypeConverter.n((Type.Nullability)type.getTimestamp().getNullability()).TIMESTAMP;
            }
            case DATE: {
                return ProtoTypeConverter.n((Type.Nullability)type.getDate().getNullability()).DATE;
            }
            case TIME: {
                return ProtoTypeConverter.n((Type.Nullability)type.getTime().getNullability()).TIME;
            }
            case INTERVAL_YEAR: {
                return ProtoTypeConverter.n((Type.Nullability)type.getIntervalYear().getNullability()).INTERVAL_YEAR;
            }
            case INTERVAL_DAY: {
                return ProtoTypeConverter.n(type.getIntervalDay().getNullability()).intervalDay(type.getIntervalDay().hasPrecision() ? type.getIntervalDay().getPrecision() : 6);
            }
            case INTERVAL_COMPOUND: {
                return ProtoTypeConverter.n(type.getIntervalCompound().getNullability()).intervalCompound(type.getIntervalCompound().getPrecision());
            }
            case TIMESTAMP_TZ: {
                return ProtoTypeConverter.n((Type.Nullability)type.getTimestampTz().getNullability()).TIMESTAMP_TZ;
            }
            case UUID: {
                return ProtoTypeConverter.n((Type.Nullability)type.getUuid().getNullability()).UUID;
            }
            case FIXED_CHAR: {
                return ProtoTypeConverter.n(type.getFixedChar().getNullability()).fixedChar(type.getFixedChar().getLength());
            }
            case VARCHAR: {
                return ProtoTypeConverter.n(type.getVarchar().getNullability()).varChar(type.getVarchar().getLength());
            }
            case FIXED_BINARY: {
                return ProtoTypeConverter.n(type.getFixedBinary().getNullability()).fixedBinary(type.getFixedBinary().getLength());
            }
            case DECIMAL: {
                return ProtoTypeConverter.n(type.getDecimal().getNullability()).decimal(type.getDecimal().getPrecision(), type.getDecimal().getScale());
            }
            case PRECISION_TIME: {
                return ProtoTypeConverter.n(type.getPrecisionTime().getNullability()).precisionTime(type.getPrecisionTime().getPrecision());
            }
            case PRECISION_TIMESTAMP: {
                return ProtoTypeConverter.n(type.getPrecisionTimestamp().getNullability()).precisionTimestamp(type.getPrecisionTimestamp().getPrecision());
            }
            case PRECISION_TIMESTAMP_TZ: {
                return ProtoTypeConverter.n(type.getPrecisionTimestampTz().getNullability()).precisionTimestampTZ(type.getPrecisionTimestampTz().getPrecision());
            }
            case STRUCT: {
                return ProtoTypeConverter.n(type.getStruct().getNullability()).struct(type.getStruct().getTypesList().stream().map(this::from).collect(Collectors.toList()));
            }
            case LIST: {
                return this.fromList(type.getList());
            }
            case MAP: {
                return this.fromMap(type.getMap());
            }
            case USER_DEFINED: {
                Type.UserDefined userDefined = type.getUserDefined();
                SimpleExtension.Type t = this.lookup.getType(userDefined.getTypeReference(), this.extensions);
                return ProtoTypeConverter.n(userDefined.getNullability()).userDefined(t.urn(), t.name());
            }
            case USER_DEFINED_TYPE_REFERENCE: {
                throw new UnsupportedOperationException("Unsupported user defined reference: " + type);
            }
            case KIND_NOT_SET: {
                throw new UnsupportedOperationException("Type is not set: " + type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)type.getKindCase()));
    }

    public Type.ListType fromList(Type.List list) {
        return ProtoTypeConverter.n(list.getNullability()).list(this.from(list.getType()));
    }

    public Type.Map fromMap(Type.Map map) {
        return ProtoTypeConverter.n(map.getNullability()).map(this.from(map.getKey()), this.from(map.getValue()));
    }

    public static boolean isNullable(Type.Nullability nullability) {
        return Type.Nullability.NULLABILITY_NULLABLE == nullability;
    }

    private static TypeCreator n(Type.Nullability n) {
        return n == Type.Nullability.NULLABILITY_NULLABLE ? TypeCreator.NULLABLE : TypeCreator.REQUIRED;
    }
}

