/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.relation.AbstractReadRel;
import io.substrait.relation.ImmutableVirtualTableScan;
import io.substrait.relation.RelVisitor;
import io.substrait.type.Type;
import io.substrait.type.TypeVisitor;
import io.substrait.util.VisitationContext;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public abstract class VirtualTableScan
extends AbstractReadRel {
    public abstract List<Expression.StructLiteral> getRows();

    @Value.Check
    protected void check() {
        List<String> names = this.getInitialSchema().names();
        assert (names.size() == NamedFieldCountingTypeVisitor.countNames(this.getInitialSchema().struct()).intValue());
        List<Expression.StructLiteral> rows = this.getRows();
        assert (rows.size() > 0 && names.stream().noneMatch(s -> s == null) && rows.stream().noneMatch(r -> r == null) && rows.stream().allMatch(r -> NamedFieldCountingTypeVisitor.countNames(r.getType()).intValue() == names.size()));
        for (Expression.StructLiteral row : rows) {
            this.validateRowConformsToSchema(row);
        }
    }

    private void validateRowConformsToSchema(Expression.StructLiteral row) {
        Type.Struct schemaStruct = this.getInitialSchema().struct();
        List<Type> schemaFieldTypes = schemaStruct.fields();
        List<Expression.Literal> rowFields = row.fields();
        assert (rowFields.size() == schemaFieldTypes.size()) : String.format("Row field count (%d) does not match schema field count (%d)", rowFields.size(), schemaFieldTypes.size());
        for (int i = 0; i < rowFields.size(); ++i) {
            Type rowFieldType = rowFields.get(i).getType();
            Type schemaFieldType = schemaFieldTypes.get(i);
            assert (rowFieldType.equals(schemaFieldType)) : String.format("Row field type (%s) does not match schema field type (%s)", rowFieldType, schemaFieldType);
        }
    }

    @Override
    public <O, C extends VisitationContext, E extends Exception> O accept(RelVisitor<O, C, E> visitor, C context) throws E {
        return visitor.visit(this, context);
    }

    public static ImmutableVirtualTableScan.Builder builder() {
        return ImmutableVirtualTableScan.builder();
    }

    private static class NamedFieldCountingTypeVisitor
    implements TypeVisitor<Integer, RuntimeException> {
        private static final NamedFieldCountingTypeVisitor VISITOR = new NamedFieldCountingTypeVisitor();

        private NamedFieldCountingTypeVisitor() {
        }

        private static Integer countNames(Type type) {
            return type.accept(VISITOR);
        }

        @Override
        public Integer visit(Type.Bool type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.I8 type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.I16 type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.I32 type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.I64 type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.FP32 type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.FP64 type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.Str type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.Binary type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.Date type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.Time type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.TimestampTZ type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.Timestamp type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.PrecisionTimestamp type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.PrecisionTime type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.PrecisionTimestampTZ type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.IntervalYear type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.IntervalDay type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.IntervalCompound type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.UUID type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.FixedChar type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.VarChar type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.FixedBinary type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.Decimal type) throws RuntimeException {
            return 0;
        }

        @Override
        public Integer visit(Type.Struct type) throws RuntimeException {
            return type.fields().stream().mapToInt(field -> 1 + field.accept(this)).sum();
        }

        @Override
        public Integer visit(Type.ListType type) throws RuntimeException {
            return type.elementType().accept(this);
        }

        @Override
        public Integer visit(Type.Map type) throws RuntimeException {
            return type.key().accept(this) + type.value().accept(this);
        }

        @Override
        public Integer visit(Type.UserDefined type) throws RuntimeException {
            return 0;
        }
    }
}

