/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.substrait.isthmus.FeatureBoard;
import io.substrait.isthmus.SubstraitRelVisitor;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.sql.validate.SqlConformance;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureBoard", generator="Immutables")
@Immutable
public final class ImmutableFeatureBoard
extends FeatureBoard {
    private final boolean allowsSqlBatch;
    private final SqlConformance sqlConformanceMode;
    private final SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureBoard(Builder builder) {
        if (builder.allowsSqlBatchIsSet()) {
            this.initShim.allowsSqlBatch(builder.allowsSqlBatch);
        }
        if (builder.sqlConformanceMode != null) {
            this.initShim.sqlConformanceMode(builder.sqlConformanceMode);
        }
        if (builder.crossJoinPolicy != null) {
            this.initShim.crossJoinPolicy(builder.crossJoinPolicy);
        }
        this.allowsSqlBatch = this.initShim.allowsSqlBatch();
        this.sqlConformanceMode = this.initShim.sqlConformanceMode();
        this.crossJoinPolicy = this.initShim.crossJoinPolicy();
        this.initShim = null;
    }

    private ImmutableFeatureBoard(boolean allowsSqlBatch, SqlConformance sqlConformanceMode, SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy) {
        this.allowsSqlBatch = allowsSqlBatch;
        this.sqlConformanceMode = sqlConformanceMode;
        this.crossJoinPolicy = crossJoinPolicy;
        this.initShim = null;
    }

    @Override
    public boolean allowsSqlBatch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowsSqlBatch() : this.allowsSqlBatch;
    }

    @Override
    public SqlConformance sqlConformanceMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sqlConformanceMode() : this.sqlConformanceMode;
    }

    @Override
    public SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.crossJoinPolicy() : this.crossJoinPolicy;
    }

    public final ImmutableFeatureBoard withAllowsSqlBatch(boolean value) {
        if (this.allowsSqlBatch == value) {
            return this;
        }
        return new ImmutableFeatureBoard(value, this.sqlConformanceMode, this.crossJoinPolicy);
    }

    public final ImmutableFeatureBoard withSqlConformanceMode(SqlConformance value) {
        if (this.sqlConformanceMode == value) {
            return this;
        }
        SqlConformance newValue = Objects.requireNonNull(value, "sqlConformanceMode");
        return new ImmutableFeatureBoard(this.allowsSqlBatch, newValue, this.crossJoinPolicy);
    }

    public final ImmutableFeatureBoard withCrossJoinPolicy(SubstraitRelVisitor.CrossJoinPolicy value) {
        SubstraitRelVisitor.CrossJoinPolicy newValue = Objects.requireNonNull(value, "crossJoinPolicy");
        if (this.crossJoinPolicy == newValue) {
            return this;
        }
        return new ImmutableFeatureBoard(this.allowsSqlBatch, this.sqlConformanceMode, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureBoard && this.equalTo(0, (ImmutableFeatureBoard)another);
    }

    private boolean equalTo(int synthetic, ImmutableFeatureBoard another) {
        return this.allowsSqlBatch == another.allowsSqlBatch && this.sqlConformanceMode.equals(another.sqlConformanceMode) && this.crossJoinPolicy.equals((Object)another.crossJoinPolicy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.allowsSqlBatch);
        h += (h << 5) + this.sqlConformanceMode.hashCode();
        h += (h << 5) + this.crossJoinPolicy.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FeatureBoard").omitNullValues().add("allowsSqlBatch", this.allowsSqlBatch).add("sqlConformanceMode", (Object)this.sqlConformanceMode).add("crossJoinPolicy", (Object)this.crossJoinPolicy).toString();
    }

    public static ImmutableFeatureBoard copyOf(FeatureBoard instance) {
        if (instance instanceof ImmutableFeatureBoard) {
            return (ImmutableFeatureBoard)instance;
        }
        return ImmutableFeatureBoard.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeatureBoard", generator="Immutables")
    private final class InitShim {
        private byte allowsSqlBatchBuildStage = 0;
        private boolean allowsSqlBatch;
        private byte sqlConformanceModeBuildStage = 0;
        private SqlConformance sqlConformanceMode;
        private byte crossJoinPolicyBuildStage = 0;
        private SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy;

        private InitShim() {
        }

        boolean allowsSqlBatch() {
            if (this.allowsSqlBatchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowsSqlBatchBuildStage == 0) {
                this.allowsSqlBatchBuildStage = (byte)-1;
                this.allowsSqlBatch = ImmutableFeatureBoard.super.allowsSqlBatch();
                this.allowsSqlBatchBuildStage = 1;
            }
            return this.allowsSqlBatch;
        }

        void allowsSqlBatch(boolean allowsSqlBatch) {
            this.allowsSqlBatch = allowsSqlBatch;
            this.allowsSqlBatchBuildStage = 1;
        }

        SqlConformance sqlConformanceMode() {
            if (this.sqlConformanceModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sqlConformanceModeBuildStage == 0) {
                this.sqlConformanceModeBuildStage = (byte)-1;
                this.sqlConformanceMode = Objects.requireNonNull(ImmutableFeatureBoard.super.sqlConformanceMode(), "sqlConformanceMode");
                this.sqlConformanceModeBuildStage = 1;
            }
            return this.sqlConformanceMode;
        }

        void sqlConformanceMode(SqlConformance sqlConformanceMode) {
            this.sqlConformanceMode = sqlConformanceMode;
            this.sqlConformanceModeBuildStage = 1;
        }

        SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy() {
            if (this.crossJoinPolicyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.crossJoinPolicyBuildStage == 0) {
                this.crossJoinPolicyBuildStage = (byte)-1;
                this.crossJoinPolicy = Objects.requireNonNull(ImmutableFeatureBoard.super.crossJoinPolicy(), "crossJoinPolicy");
                this.crossJoinPolicyBuildStage = 1;
            }
            return this.crossJoinPolicy;
        }

        void crossJoinPolicy(SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy) {
            this.crossJoinPolicy = crossJoinPolicy;
            this.crossJoinPolicyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.allowsSqlBatchBuildStage == -1) {
                attributes.add("allowsSqlBatch");
            }
            if (this.sqlConformanceModeBuildStage == -1) {
                attributes.add("sqlConformanceMode");
            }
            if (this.crossJoinPolicyBuildStage == -1) {
                attributes.add("crossJoinPolicy");
            }
            return "Cannot build FeatureBoard, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="FeatureBoard", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_ALLOWS_SQL_BATCH = 1L;
        private long optBits;
        private boolean allowsSqlBatch;
        @Nullable
        private SqlConformance sqlConformanceMode;
        @Nullable
        private SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureBoard instance) {
            Objects.requireNonNull(instance, "instance");
            this.allowsSqlBatch(instance.allowsSqlBatch());
            this.sqlConformanceMode(instance.sqlConformanceMode());
            this.crossJoinPolicy(instance.crossJoinPolicy());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allowsSqlBatch(boolean allowsSqlBatch) {
            this.allowsSqlBatch = allowsSqlBatch;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sqlConformanceMode(SqlConformance sqlConformanceMode) {
            this.sqlConformanceMode = Objects.requireNonNull(sqlConformanceMode, "sqlConformanceMode");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crossJoinPolicy(SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy) {
            this.crossJoinPolicy = Objects.requireNonNull(crossJoinPolicy, "crossJoinPolicy");
            return this;
        }

        public ImmutableFeatureBoard build() {
            return new ImmutableFeatureBoard(this);
        }

        private boolean allowsSqlBatchIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

