/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.util.JsonFormat;
import io.substrait.extension.SimpleExtension;
import io.substrait.isthmus.FeatureBoard;
import io.substrait.isthmus.ImmutableFeatureBoard;
import io.substrait.isthmus.SqlExpressionToSubstrait;
import io.substrait.isthmus.SqlToSubstrait;
import io.substrait.isthmus.SubstraitRelVisitor;
import io.substrait.proto.ExtendedExpression;
import io.substrait.proto.Plan;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import picocli.CommandLine;

@CommandLine.Command(name="isthmus", version={"isthmus 0.1"}, description={"Convert SQL Queries and SQL Expressions to Substrait"}, mixinStandardHelpOptions=true)
public class IsthmusEntryPoint
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="0..1", description={"A SQL query"})
    private String sql;
    @CommandLine.Option(names={"-e", "--expression"}, arity="1..*", description={"One or more SQL expressions e.g. col + 1"})
    private String[] sqlExpressions;
    @CommandLine.Option(names={"-c", "--create"}, description={"One or multiple create table statements e.g. CREATE TABLE T1(foo int, bar bigint)"})
    private List<String> createStatements;
    @CommandLine.Option(names={"-m", "--multistatement"}, description={"Allow multiple statements terminated with a semicolon"})
    private boolean allowMultiStatement;
    @CommandLine.Option(names={"--outputformat"}, defaultValue="PROTOJSON", description={"Set the output format for the generated plan: ${COMPLETION-CANDIDATES}"})
    private OutputFormat outputFormat = OutputFormat.PROTOJSON;
    @CommandLine.Option(names={"--sqlconformancemode"}, description={"One of built-in Calcite SQL compatibility modes: ${COMPLETION-CANDIDATES}"})
    private SqlConformanceEnum sqlConformanceMode = SqlConformanceEnum.DEFAULT;
    @CommandLine.Option(names={"--crossjoinpolicy"}, description={"One of built-in Calcite SQL compatibility modes: ${COMPLETION-CANDIDATES}"})
    private SubstraitRelVisitor.CrossJoinPolicy crossJoinPolicy = SubstraitRelVisitor.CrossJoinPolicy.KEEP_AS_CROSS_JOIN;

    public static void main(String ... args) {
        CommandLine commandLine = new CommandLine((Object)new IsthmusEntryPoint());
        commandLine.setCaseInsensitiveEnumValuesAllowed(true);
        CommandLine.ParseResult parseResult = commandLine.parseArgs(args);
        if (parseResult.originalArgs().isEmpty()) {
            commandLine.usage(System.out);
            System.exit(0);
        }
        if (commandLine.isUsageHelpRequested()) {
            commandLine.usage(System.out);
            System.exit(0);
        }
        if (commandLine.isVersionHelpRequested()) {
            commandLine.printVersionHelp(System.out);
            System.exit(0);
        }
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        FeatureBoard featureBoard = this.buildFeatureBoard();
        if (this.sqlExpressions != null) {
            SqlExpressionToSubstrait converter = new SqlExpressionToSubstrait(featureBoard, SimpleExtension.loadDefaults());
            ExtendedExpression extendedExpression = converter.convert(this.sqlExpressions, this.createStatements);
            this.printMessage((Message)extendedExpression);
        } else {
            SqlToSubstrait converter = new SqlToSubstrait(featureBoard);
            Plan plan = converter.execute(this.sql, this.createStatements);
            this.printMessage((Message)plan);
        }
        return 0;
    }

    private void printMessage(Message message) throws IOException {
        switch (this.outputFormat) {
            case PROTOJSON: {
                System.out.println(JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)message));
                break;
            }
            case PROTOTEXT: {
                TextFormat.printer().print((MessageOrBuilder)message, (Appendable)System.out);
                break;
            }
            case BINARY: {
                message.writeTo((OutputStream)System.out);
            }
        }
    }

    @VisibleForTesting
    FeatureBoard buildFeatureBoard() {
        return ImmutableFeatureBoard.builder().allowsSqlBatch(this.allowMultiStatement).sqlConformanceMode((SqlConformance)this.sqlConformanceMode).crossJoinPolicy(this.crossJoinPolicy).build();
    }

    static enum OutputFormat {
        PROTOJSON,
        PROTOTEXT,
        BINARY;

    }
}

