/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.extension.SimpleExtension;
import io.substrait.function.TypeExpression;
import io.substrait.isthmus.FeatureBoard;
import io.substrait.isthmus.ImmutableFeatureBoard;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.calcite.SubstraitOperatorTable;
import io.substrait.type.NamedStruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.jdbc.LookupCalciteSchema;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataHandlerProvider;
import org.apache.calcite.rel.metadata.ProxyingMetadataHandlerProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlKeyConstraint;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.ddl.SqlDdlParserImpl;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.util.Pair;

class SqlConverterBase {
    final RelDataTypeFactory factory = new JavaTypeFactoryImpl();
    final RelOptCluster relOptCluster;
    final CalciteConnectionConfig config = CalciteConnectionConfig.DEFAULT.set(CalciteConnectionProperty.CASE_SENSITIVE, "false");
    final SqlToRelConverter.Config converterConfig = SqlToRelConverter.config().withTrimUnusedFields(true).withExpand(false);
    final SqlParser.Config parserConfig;
    protected static final FeatureBoard FEATURES_DEFAULT;
    final FeatureBoard featureBoard;
    protected static final SimpleExtension.ExtensionCollection EXTENSION_COLLECTION;

    protected SqlConverterBase(FeatureBoard features) {
        VolcanoPlanner planner = new VolcanoPlanner(RelOptCostImpl.FACTORY, Contexts.of((Object)"hello"));
        this.relOptCluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)new RexBuilder(this.factory));
        this.relOptCluster.setMetadataQuerySupplier(() -> {
            ProxyingMetadataHandlerProvider handler = new ProxyingMetadataHandlerProvider((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE);
            return new RelMetadataQuery((MetadataHandlerProvider)handler);
        });
        this.featureBoard = features == null ? FEATURES_DEFAULT : features;
        this.parserConfig = SqlParser.Config.DEFAULT.withParserFactory(SqlDdlParserImpl.FACTORY).withConformance(this.featureBoard.sqlConformanceMode());
    }

    Pair<SqlValidator, CalciteCatalogReader> registerCreateTables(List<String> tables) throws SqlParseException {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)false);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(rootSchema, List.of(), this.factory, this.config);
        Validator validator = Validator.create(this.factory, catalogReader, SqlValidator.Config.DEFAULT);
        if (tables != null) {
            for (String tableDef : tables) {
                List<DefinedTable> tList = this.parseCreateTable(this.factory, (SqlValidator)validator, tableDef);
                for (DefinedTable t : tList) {
                    rootSchema.add(t.getName(), (Table)t);
                }
            }
        }
        return Pair.of((Object)((Object)validator), (Object)catalogReader);
    }

    Pair<SqlValidator, CalciteCatalogReader> registerCreateTables(Function<List<String>, NamedStruct> tableLookup) throws SqlParseException {
        Function<List<String>, Table> lookup = id -> {
            NamedStruct table = (NamedStruct)tableLookup.apply((List<String>)id);
            if (table == null) {
                return null;
            }
            return new DefinedTable((String)id.get(id.size() - 1), this.factory, TypeConverter.DEFAULT.toCalcite(this.factory, (TypeExpression)table.struct(), table.names()));
        };
        CalciteSchema rootSchema = LookupCalciteSchema.createRootSchema(lookup);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(rootSchema, List.of(), this.factory, this.config);
        Validator validator = Validator.create(this.factory, catalogReader, SqlValidator.Config.DEFAULT);
        return Pair.of((Object)((Object)validator), (Object)catalogReader);
    }

    Pair<SqlValidator, CalciteCatalogReader> registerSchema(String name, Schema schema) {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)false);
        if (schema != null) {
            rootSchema.add(name, schema);
            rootSchema = rootSchema.getSubSchema(name, false);
        }
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(rootSchema, List.of(), this.factory, this.config);
        Validator validator = Validator.create(this.factory, catalogReader, SqlValidator.Config.DEFAULT);
        return Pair.of((Object)((Object)validator), (Object)catalogReader);
    }

    protected List<DefinedTable> parseCreateTable(RelDataTypeFactory factory, SqlValidator validator, String sql) throws SqlParseException {
        SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)this.parserConfig);
        ArrayList<DefinedTable> definedTableList = new ArrayList<DefinedTable>();
        SqlNodeList nodeList = parser.parseStmtList();
        for (SqlNode parsed : nodeList) {
            if (!(parsed instanceof SqlCreateTable)) {
                SqlConverterBase.fail("Not a valid CREATE TABLE statement.");
            }
            SqlCreateTable create = (SqlCreateTable)parsed;
            if (create.name.names.size() > 1) {
                SqlConverterBase.fail("Only simple table names are allowed.", create.name.getParserPosition());
            }
            if (create.query != null) {
                SqlConverterBase.fail("CTAS not supported.", create.name.getParserPosition());
            }
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<RelDataType> columnTypes = new ArrayList<RelDataType>();
            for (SqlNode node : create.columnList) {
                if (!(node instanceof SqlColumnDeclaration)) {
                    if (node instanceof SqlKeyConstraint) continue;
                    SqlConverterBase.fail("Unexpected column list construction.", node.getParserPosition());
                }
                SqlColumnDeclaration col = (SqlColumnDeclaration)node;
                if (col.name.names.size() != 1) {
                    SqlConverterBase.fail("Expected simple column names.", col.name.getParserPosition());
                }
                names.add((String)col.name.names.get(0));
                columnTypes.add(col.dataType.deriveType(validator));
            }
            definedTableList.add(new DefinedTable((String)create.name.names.get(0), factory, factory.createStructType(columnTypes, names)));
        }
        return definedTableList;
    }

    protected static SqlParseException fail(String text, SqlParserPos pos) {
        return new SqlParseException(text, pos, null, null, (Throwable)new RuntimeException("fake lineage"));
    }

    protected static SqlParseException fail(String text) {
        return SqlConverterBase.fail(text, SqlParserPos.ZERO);
    }

    static {
        SimpleExtension.ExtensionCollection defaults;
        FEATURES_DEFAULT = ImmutableFeatureBoard.builder().build();
        try {
            defaults = SimpleExtension.loadDefaults();
        }
        catch (IOException e) {
            throw new RuntimeException("Failure while loading defaults.", e);
        }
        EXTENSION_COLLECTION = defaults;
    }

    protected static final class Validator
    extends SqlValidatorImpl {
        private Validator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlValidator.Config config) {
            super(opTab, catalogReader, typeFactory, config);
        }

        public static Validator create(RelDataTypeFactory factory, CalciteCatalogReader catalog, SqlValidator.Config config) {
            return new Validator(SubstraitOperatorTable.INSTANCE, (SqlValidatorCatalogReader)catalog, factory, config);
        }
    }

    protected static final class DefinedTable
    extends AbstractTable {
        private final String name;
        private final RelDataTypeFactory factory;
        private final RelDataType type;

        public DefinedTable(String name, RelDataTypeFactory factory, RelDataType type) {
            this.name = name;
            this.factory = factory;
            this.type = type;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

