/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import com.google.common.annotations.VisibleForTesting;
import io.substrait.extension.ExtensionCollector;
import io.substrait.isthmus.FeatureBoard;
import io.substrait.isthmus.SqlConverterBase;
import io.substrait.isthmus.SubstraitRelVisitor;
import io.substrait.isthmus.TypeConverter;
import io.substrait.proto.Plan;
import io.substrait.proto.PlanRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelRoot;
import io.substrait.relation.RelProtoConverter;
import io.substrait.relation.RelVisitor;
import io.substrait.type.NamedStruct;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.util.Pair;

public class SqlToSubstrait
extends SqlConverterBase {
    public SqlToSubstrait() {
        this(null);
    }

    public SqlToSubstrait(FeatureBoard features) {
        super(features);
    }

    public Plan execute(String sql, Function<List<String>, NamedStruct> tableLookup) throws SqlParseException {
        Pair<SqlValidator, CalciteCatalogReader> pair = this.registerCreateTables(tableLookup);
        return this.executeInner(sql, this.factory, (SqlValidator)pair.left, (CalciteCatalogReader)pair.right);
    }

    public Plan execute(String sql, List<String> tables) throws SqlParseException {
        Pair<SqlValidator, CalciteCatalogReader> pair = this.registerCreateTables(tables);
        return this.executeInner(sql, this.factory, (SqlValidator)pair.left, (CalciteCatalogReader)pair.right);
    }

    public Plan execute(String sql, String name, Schema schema) throws SqlParseException {
        Pair<SqlValidator, CalciteCatalogReader> pair = this.registerSchema(name, schema);
        return this.executeInner(sql, this.factory, (SqlValidator)pair.left, (CalciteCatalogReader)pair.right);
    }

    List<org.apache.calcite.rel.RelRoot> sqlToRelNode(String sql, List<String> tables) throws SqlParseException {
        Pair<SqlValidator, CalciteCatalogReader> pair = this.registerCreateTables(tables);
        return this.sqlToRelNode(sql, (SqlValidator)pair.left, (CalciteCatalogReader)pair.right);
    }

    List<org.apache.calcite.rel.RelRoot> sqlToRelNode(String sql, Function<List<String>, NamedStruct> tableLookup) throws SqlParseException {
        Pair<SqlValidator, CalciteCatalogReader> pair = this.registerCreateTables(tableLookup);
        return this.sqlToRelNode(sql, (SqlValidator)pair.left, (CalciteCatalogReader)pair.right);
    }

    private Plan executeInner(String sql, RelDataTypeFactory factory, SqlValidator validator, CalciteCatalogReader catalogReader) throws SqlParseException {
        Plan.Builder plan = Plan.newBuilder();
        ExtensionCollector functionCollector = new ExtensionCollector();
        RelProtoConverter relProtoConverter = new RelProtoConverter(functionCollector);
        this.sqlToRelNode(sql, validator, catalogReader).forEach(root -> plan.addRelations(PlanRel.newBuilder().setRoot(RelRoot.newBuilder().setInput((Rel)SubstraitRelVisitor.convert(root, EXTENSION_COLLECTION, this.featureBoard).accept((RelVisitor)relProtoConverter)).addAllNames((Iterable)TypeConverter.DEFAULT.toNamedStruct(root.validatedRowType).names()))));
        functionCollector.addExtensionsToPlan(plan);
        return plan.build();
    }

    private List<org.apache.calcite.rel.RelRoot> sqlToRelNode(String sql, SqlValidator validator, CalciteCatalogReader catalogReader) throws SqlParseException {
        SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)this.parserConfig);
        SqlNodeList parsedList = parser.parseStmtList();
        if (!this.featureBoard.allowsSqlBatch() && parsedList.size() > 1) {
            throw new UnsupportedOperationException("SQL must contain only a single statement: " + sql);
        }
        SqlToRelConverter converter = this.createSqlToRelConverter(validator, catalogReader);
        List<org.apache.calcite.rel.RelRoot> roots = parsedList.stream().map(parsed -> SqlToSubstrait.getBestExpRelRoot(converter, parsed)).collect(Collectors.toList());
        return roots;
    }

    @VisibleForTesting
    SqlToRelConverter createSqlToRelConverter(SqlValidator validator, CalciteCatalogReader catalogReader) {
        SqlToRelConverter converter = new SqlToRelConverter(null, validator, (Prepare.CatalogReader)catalogReader, this.relOptCluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, this.converterConfig);
        return converter;
    }

    @VisibleForTesting
    static org.apache.calcite.rel.RelRoot getBestExpRelRoot(SqlToRelConverter converter, SqlNode parsed) {
        org.apache.calcite.rel.RelRoot root = converter.convertQuery(parsed, true, true);
        HepProgram program = HepProgram.builder().build();
        HepPlanner hepPlanner = new HepPlanner(program);
        hepPlanner.setRoot(root.rel);
        root = root.withRel(hepPlanner.findBestExp());
        return root;
    }
}

