/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.extension.SimpleExtension;
import io.substrait.function.TypeExpression;
import io.substrait.isthmus.SqlConverterBase;
import io.substrait.isthmus.SubstraitRelNodeConverter;
import io.substrait.isthmus.TypeConverter;
import io.substrait.relation.AbstractRelVisitor;
import io.substrait.relation.NamedScan;
import io.substrait.relation.Rel;
import io.substrait.relation.RelVisitor;
import io.substrait.type.NamedStruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.LookupCalciteSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Table;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;

public class SubstraitToCalcite {
    protected final SimpleExtension.ExtensionCollection extensions;
    protected final RelDataTypeFactory typeFactory;
    protected final TypeConverter typeConverter;

    public SubstraitToCalcite(SimpleExtension.ExtensionCollection extensions, RelDataTypeFactory typeFactory) {
        this(extensions, typeFactory, TypeConverter.DEFAULT);
    }

    public SubstraitToCalcite(SimpleExtension.ExtensionCollection extensions, RelDataTypeFactory typeFactory, TypeConverter typeConverter) {
        this.extensions = extensions;
        this.typeFactory = typeFactory;
        this.typeConverter = typeConverter;
    }

    protected CalciteSchema toSchema(Rel rel) {
        Map<List<String>, NamedStruct> tableMap = NamedStructGatherer.gatherTables(rel);
        Function<List<String>, Table> lookup = id -> {
            NamedStruct table = (NamedStruct)tableMap.get(id);
            if (table == null) {
                return null;
            }
            return new SqlConverterBase.DefinedTable((String)id.get(id.size() - 1), this.typeFactory, this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)table.struct(), table.names()));
        };
        return LookupCalciteSchema.createRootSchema(lookup);
    }

    protected RelBuilder createRelBuilder(CalciteSchema schema) {
        return RelBuilder.create((FrameworkConfig)Frameworks.newConfigBuilder().defaultSchema(schema.plus()).build());
    }

    protected SubstraitRelNodeConverter createSubstraitRelNodeConverter(RelBuilder relBuilder) {
        return new SubstraitRelNodeConverter(this.extensions, this.typeFactory, relBuilder);
    }

    public RelNode convert(Rel rel) {
        CalciteSchema rootSchema = this.toSchema(rel);
        RelBuilder relBuilder = this.createRelBuilder(rootSchema);
        SubstraitRelNodeConverter converter = this.createSubstraitRelNodeConverter(relBuilder);
        return (RelNode)rel.accept((RelVisitor)converter);
    }

    private static class NamedStructGatherer
    extends AbstractRelVisitor<Void, RuntimeException> {
        Map<List<String>, NamedStruct> tableMap = new HashMap<List<String>, NamedStruct>();

        private NamedStructGatherer() {
        }

        public static Map<List<String>, NamedStruct> gatherTables(Rel rel) {
            NamedStructGatherer visitor = new NamedStructGatherer();
            rel.accept((RelVisitor)visitor);
            return visitor.tableMap;
        }

        public Void visit(NamedScan namedScan) {
            List tableName = namedScan.getNames();
            this.tableMap.put(tableName, namedScan.getInitialSchema());
            return null;
        }

        public Void visitFallback(Rel rel) {
            for (Rel input : rel.getInputs()) {
                input.accept((RelVisitor)this);
            }
            return null;
        }
    }
}

