/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.function.NullableType;
import io.substrait.function.TypeExpression;
import io.substrait.isthmus.SubstraitTypeSystem;
import io.substrait.isthmus.UserTypeMapper;
import io.substrait.type.NamedStruct;
import io.substrait.type.Type;
import io.substrait.type.TypeCreator;
import io.substrait.type.TypeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConverter {
    static final Logger logger = LoggerFactory.getLogger(TypeConverter.class);
    private final UserTypeMapper userTypeMapper;
    public static TypeConverter DEFAULT = new TypeConverter(new UserTypeMapper(){

        @Override
        @Nullable
        public Type toSubstrait(RelDataType relDataType) {
            return null;
        }

        @Override
        @Nullable
        public RelDataType toCalcite(Type.UserDefined type) {
            return null;
        }
    });

    public TypeConverter(UserTypeMapper userTypeMapper) {
        this.userTypeMapper = userTypeMapper;
    }

    public Type toSubstrait(RelDataType type) {
        return this.toSubstrait(type, new ArrayList<String>());
    }

    public NamedStruct toNamedStruct(RelDataType type) {
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            throw new IllegalArgumentException("Expected type of struct.");
        }
        ArrayList<String> names = new ArrayList<String>();
        Type.Struct struct = (Type.Struct)this.toSubstrait(type, names);
        return NamedStruct.of(names, (Type.Struct)struct);
    }

    private Type toSubstrait(RelDataType type, List<String> names) {
        Type type2;
        Type userType = this.userTypeMapper.toSubstrait(type);
        if (userType != null) {
            return userType;
        }
        TypeCreator creator = Type.withNullability((boolean)type.isNullable());
        switch (type.getSqlTypeName()) {
            case BOOLEAN: {
                type2 = creator.BOOLEAN;
                break;
            }
            case TINYINT: {
                type2 = creator.I8;
                break;
            }
            case SMALLINT: {
                type2 = creator.I16;
                break;
            }
            case INTEGER: {
                type2 = creator.I32;
                break;
            }
            case BIGINT: {
                type2 = creator.I64;
                break;
            }
            case FLOAT: {
                type2 = creator.FP32;
                break;
            }
            case DOUBLE: {
                type2 = creator.FP64;
                break;
            }
            case DECIMAL: {
                if (type.getPrecision() > 38) {
                    throw new UnsupportedOperationException("unsupported decimal precision " + type.getPrecision());
                }
                type2 = creator.decimal(type.getPrecision(), type.getScale());
                break;
            }
            case CHAR: {
                type2 = creator.fixedChar(type.getPrecision());
                break;
            }
            case VARCHAR: {
                if (type.getPrecision() == -1) {
                    type2 = creator.STRING;
                    break;
                }
                type2 = creator.varChar(type.getPrecision());
                break;
            }
            case SYMBOL: {
                type2 = creator.STRING;
                break;
            }
            case DATE: {
                type2 = creator.DATE;
                break;
            }
            case TIME: {
                if (type.getPrecision() != 6) {
                    throw new UnsupportedOperationException("unsupported time precision " + type.getPrecision());
                }
                type2 = creator.TIME;
                break;
            }
            case TIMESTAMP: {
                if (type.getPrecision() != 6) {
                    throw new UnsupportedOperationException("unsupported timestamp precision " + type.getPrecision());
                }
                type2 = creator.TIMESTAMP;
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (type.getPrecision() != 6) {
                    throw new UnsupportedOperationException("unsupported timestamptz precision " + type.getPrecision());
                }
                type2 = creator.TIMESTAMP_TZ;
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                type2 = creator.INTERVAL_YEAR;
                break;
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                type2 = creator.INTERVAL_DAY;
                break;
            }
            case VARBINARY: {
                type2 = creator.BINARY;
                break;
            }
            case BINARY: {
                type2 = creator.fixedBinary(type.getPrecision());
                break;
            }
            case MAP: {
                MapSqlType map = (MapSqlType)type;
                type2 = creator.map(this.toSubstrait(map.getKeyType(), names), this.toSubstrait(map.getValueType(), names));
                break;
            }
            case ROW: {
                ArrayList<Type> children = new ArrayList<Type>();
                for (RelDataTypeField field : type.getFieldList()) {
                    names.add(field.getName());
                    children.add(this.toSubstrait(field.getType(), names));
                }
                type2 = creator.struct(children);
                break;
            }
            case ARRAY: {
                type2 = creator.list(this.toSubstrait(type.getComponentType(), names));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to convert the type " + type.toString(), new Object[0]));
            }
        }
        return type2;
    }

    public RelDataType toCalcite(RelDataTypeFactory relDataTypeFactory, TypeExpression typeExpression) {
        return this.toCalcite(relDataTypeFactory, typeExpression, null);
    }

    public RelDataType toCalcite(RelDataTypeFactory relDataTypeFactory, TypeExpression typeExpression, List<String> dfsFieldNames) {
        return (RelDataType)typeExpression.accept((TypeVisitor)new ToRelDataType(relDataTypeFactory, this.userTypeMapper, dfsFieldNames, 0));
    }

    private static class ToRelDataType
    extends TypeVisitor.TypeThrowsVisitor<RelDataType, RuntimeException> {
        private final RelDataTypeFactory typeFactory;
        private final UserTypeMapper userTypeMapper;
        private final List<String> fieldNames;
        private int fieldNamePosition;
        private boolean withinStruct;

        public ToRelDataType(RelDataTypeFactory type, UserTypeMapper userTypeMapper, List<String> fieldNames, int fieldNamePosition) {
            super("Unknown expression type.");
            this.typeFactory = type;
            this.userTypeMapper = userTypeMapper;
            this.fieldNames = fieldNames;
            this.fieldNamePosition = fieldNamePosition;
        }

        public RelDataType visit(Type.Bool expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.BOOLEAN, new Integer[0]);
        }

        public RelDataType visit(Type.I8 expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.TINYINT, new Integer[0]);
        }

        public RelDataType visit(Type.I16 expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.SMALLINT, new Integer[0]);
        }

        public RelDataType visit(Type.I32 expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.INTEGER, new Integer[0]);
        }

        public RelDataType visit(Type.I64 expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.BIGINT, new Integer[0]);
        }

        public RelDataType visit(Type.FP32 expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.FLOAT, new Integer[0]);
        }

        public RelDataType visit(Type.FP64 expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.DOUBLE, new Integer[0]);
        }

        public RelDataType visit(Type.Str expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.VARCHAR, new Integer[0]);
        }

        public RelDataType visit(Type.Binary expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.VARBINARY, new Integer[0]);
        }

        public RelDataType visit(Type.Date expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.DATE, new Integer[0]);
        }

        public RelDataType visit(Type.Time expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.TIME, 6);
        }

        public RelDataType visit(Type.TimestampTZ expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, 6);
        }

        public RelDataType visit(Type.Timestamp expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.TIMESTAMP, 6);
        }

        public RelDataType visit(Type.IntervalYear expr) {
            return this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlIntervalType(SubstraitTypeSystem.YEAR_MONTH_INTERVAL), this.n((NullableType)expr));
        }

        public RelDataType visit(Type.IntervalDay expr) {
            return this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlIntervalType(SubstraitTypeSystem.DAY_SECOND_INTERVAL), this.n((NullableType)expr));
        }

        public RelDataType visit(Type.FixedChar expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.CHAR, expr.length());
        }

        public RelDataType visit(Type.VarChar expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.VARCHAR, expr.length());
        }

        public RelDataType visit(Type.FixedBinary expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.BINARY, expr.length());
        }

        public RelDataType visit(Type.Decimal expr) {
            return this.t(this.n((NullableType)expr), SqlTypeName.DECIMAL, expr.precision(), expr.scale());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RelDataType visit(Type.Struct expr) {
            if (this.withinStruct) {
                throw new IllegalStateException("Visitor can't be re-used for nested structs.");
            }
            this.withinStruct = true;
            try {
                ArrayList<RelDataType> fieldTypes = new ArrayList<RelDataType>();
                ArrayList<Object> localFieldNames = new ArrayList<Object>();
                for (TypeExpression field : expr.fields()) {
                    localFieldNames.add(this.fieldNames == null ? "f" + this.fieldNamePosition : this.fieldNames.get(this.fieldNamePosition));
                    ++this.fieldNamePosition;
                    ToRelDataType childVisitor = new ToRelDataType(this.typeFactory, this.userTypeMapper, this.fieldNames, this.fieldNamePosition);
                    fieldTypes.add((RelDataType)field.accept((TypeVisitor)childVisitor));
                    this.fieldNamePosition = childVisitor.fieldNamePosition;
                }
                RelDataType relDataType = this.n((Type)expr, this.typeFactory.createStructType(fieldTypes, localFieldNames));
                return relDataType;
            }
            finally {
                this.withinStruct = false;
            }
        }

        public RelDataType visit(Type.ListType expr) {
            return this.n((Type)expr, this.typeFactory.createArrayType((RelDataType)expr.elementType().accept((TypeVisitor)this), -1L));
        }

        public RelDataType visit(Type.Map expr) {
            return this.n((Type)expr, this.typeFactory.createMapType((RelDataType)expr.key().accept((TypeVisitor)this), (RelDataType)expr.value().accept((TypeVisitor)this)));
        }

        public RelDataType visit(Type.UserDefined expr) throws RuntimeException {
            RelDataType type = this.userTypeMapper.toCalcite(expr);
            if (type != null) {
                return type;
            }
            throw new UnsupportedOperationException(String.format("Unable to map user-defined type: %s", expr));
        }

        private boolean n(NullableType type) {
            return type.nullable();
        }

        private RelDataType t(boolean nullable, SqlTypeName typeName, Integer ... props) {
            RelDataType relDataType;
            switch (props.length) {
                case 0: {
                    relDataType = this.typeFactory.createSqlType(typeName);
                    break;
                }
                case 1: {
                    relDataType = this.typeFactory.createSqlType(typeName, props[0].intValue());
                    break;
                }
                case 2: {
                    relDataType = this.typeFactory.createSqlType(typeName, props[0].intValue(), props[1].intValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected properties length: " + Arrays.toString((Object[])props));
                }
            }
            RelDataType baseType = relDataType;
            return this.typeFactory.createTypeWithNullability(baseType, nullable);
        }

        private RelDataType n(Type substraitType, RelDataType type) {
            return this.typeFactory.createTypeWithNullability(type, this.n((NullableType)substraitType));
        }
    }
}

