/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import com.google.common.collect.ImmutableList;
import io.substrait.expression.AggregateFunctionInvocation;
import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionCreator;
import io.substrait.expression.FunctionArg;
import io.substrait.extension.SimpleExtension;
import io.substrait.isthmus.AggregateFunctions;
import io.substrait.isthmus.SubstraitRelVisitor;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.expression.FunctionConverter;
import io.substrait.isthmus.expression.FunctionMappings;
import io.substrait.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class AggregateFunctionConverter
extends FunctionConverter<SimpleExtension.AggregateFunctionVariant, AggregateFunctionInvocation, WrappedAggregateCall> {
    @Override
    protected ImmutableList<FunctionMappings.Sig> getSigs() {
        return FunctionMappings.AGGREGATE_SIGS;
    }

    public AggregateFunctionConverter(List<SimpleExtension.AggregateFunctionVariant> functions, RelDataTypeFactory typeFactory) {
        super(functions, typeFactory);
    }

    public AggregateFunctionConverter(List<SimpleExtension.AggregateFunctionVariant> functions, List<FunctionMappings.Sig> additionalSignatures, RelDataTypeFactory typeFactory, TypeConverter typeConverter) {
        super(functions, additionalSignatures, typeFactory, typeConverter);
    }

    @Override
    protected AggregateFunctionInvocation generateBinding(WrappedAggregateCall call, SimpleExtension.AggregateFunctionVariant function, List<FunctionArg> arguments, Type outputType) {
        AggregateCall agg = call.getUnderlying();
        List sorts = agg.getCollation() != null ? agg.getCollation().getFieldCollations().stream().map(r -> SubstraitRelVisitor.toSortField(r, call.inputType)).collect(Collectors.toList()) : Collections.emptyList();
        Expression.AggregationInvocation invocation = agg.isDistinct() ? Expression.AggregationInvocation.DISTINCT : Expression.AggregationInvocation.ALL;
        return ExpressionCreator.aggregateFunction((SimpleExtension.AggregateFunctionVariant)function, (Type)outputType, (Expression.AggregationPhase)Expression.AggregationPhase.INITIAL_TO_RESULT, sorts, (Expression.AggregationInvocation)invocation, arguments);
    }

    public Optional<AggregateFunctionInvocation> convert(RelNode input, Type.Struct inputType, AggregateCall call, Function<RexNode, Expression> topLevelConverter) {
        FunctionConverter.FunctionFinder m = this.getFunctionFinder(call);
        if (m == null) {
            return Optional.empty();
        }
        if (!m.allowedArgCount(call.getArgList().size())) {
            return Optional.empty();
        }
        WrappedAggregateCall wrapped = new WrappedAggregateCall(call, input, this.rexBuilder, inputType);
        return m.attemptMatch(wrapped, topLevelConverter);
    }

    protected FunctionConverter.FunctionFinder getFunctionFinder(AggregateCall call) {
        SqlAggFunction aggFunction = call.getAggregation();
        if (aggFunction == SqlStdOperatorTable.COUNT && call.isDistinct() && call.isApproximate()) {
            aggFunction = SqlStdOperatorTable.APPROX_COUNT_DISTINCT;
        }
        SqlAggFunction lookupFunction = AggregateFunctions.toSubstraitAggVariant(aggFunction).orElse(aggFunction);
        return (FunctionConverter.FunctionFinder)this.signatures.get(lookupFunction);
    }

    static class WrappedAggregateCall
    implements FunctionConverter.GenericCall {
        private final AggregateCall call;
        private final RelNode input;
        private final RexBuilder rexBuilder;
        private final Type.Struct inputType;

        private WrappedAggregateCall(AggregateCall call, RelNode input, RexBuilder rexBuilder, Type.Struct inputType) {
            this.call = call;
            this.input = input;
            this.rexBuilder = rexBuilder;
            this.inputType = inputType;
        }

        @Override
        public Stream<RexNode> getOperands() {
            return this.call.getArgList().stream().map(r -> this.rexBuilder.makeInputRef(this.input, r.intValue()));
        }

        public AggregateCall getUnderlying() {
            return this.call;
        }

        @Override
        public RelDataType getType() {
            return this.call.getType();
        }
    }
}

