/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import com.google.common.collect.ImmutableList;
import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionCreator;
import io.substrait.expression.ImmutableExpression;
import io.substrait.isthmus.CallConverter;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.expression.FieldSelectionConverter;
import io.substrait.isthmus.expression.LiteralConstructorConverter;
import io.substrait.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallConverters {
    static final Logger logger = LoggerFactory.getLogger(CallConverters.class);
    public static Function<TypeConverter, SimpleCallConverter> CAST = typeConverter -> (call, visitor) -> {
        Expression.FailureBehavior failureBehavior;
        switch (call.getKind()) {
            case CAST: {
                failureBehavior = Expression.FailureBehavior.THROW_EXCEPTION;
                break;
            }
            case SAFE_CAST: {
                failureBehavior = Expression.FailureBehavior.RETURN_NULL;
                break;
            }
            default: {
                return null;
            }
        }
        return ExpressionCreator.cast((Type)typeConverter.toSubstrait(call.getType()), (Expression)((Expression)visitor.apply((RexNode)call.getOperands().get(0))), (Expression.FailureBehavior)failureBehavior);
    };
    public static Function<TypeConverter, SimpleCallConverter> REINTERPRET = typeConverter -> (call, visitor) -> {
        if (call.getKind() != SqlKind.REINTERPRET) {
            return null;
        }
        Expression operand = (Expression)visitor.apply((RexNode)call.getOperands().get(0));
        Type type = typeConverter.toSubstrait(call.getType());
        if (operand instanceof Expression.FixedBinaryLiteral) {
            Expression.FixedBinaryLiteral literal = (Expression.FixedBinaryLiteral)operand;
            if (type instanceof Type.UserDefined) {
                Type.UserDefined t = (Type.UserDefined)type;
                return Expression.UserDefinedLiteral.builder().uri(t.uri()).name(t.name()).value(literal.value()).build();
            }
        }
        return null;
    };
    public static SimpleCallConverter CASE = (call, visitor) -> {
        if (call.getKind() != SqlKind.CASE) {
            return null;
        }
        assert (call.getOperands().size() % 2 == 1);
        List caseArgs = call.getOperands().stream().map(visitor).collect(Collectors.toList());
        int last = caseArgs.size() - 1;
        ArrayList<ImmutableExpression.IfClause> caseConditions = new ArrayList<ImmutableExpression.IfClause>();
        for (int i = 0; i < last; i += 2) {
            caseConditions.add(ImmutableExpression.IfClause.builder().condition((Expression)caseArgs.get(i)).then((Expression)caseArgs.get(i + 1)).build());
        }
        Expression defaultResult = (Expression)caseArgs.get(last);
        return ExpressionCreator.ifThenStatement((Expression)defaultResult, caseConditions);
    };
    public static Function<RexBuilder, SimpleCallConverter> CREATE_SEARCH_CONV = rexBuilder -> (call, visitor) -> {
        if (call.getKind() != SqlKind.SEARCH) {
            return null;
        }
        RexNode expandSearch = RexUtil.expandSearch((RexBuilder)rexBuilder, null, (RexNode)call);
        return expandSearch.equals((Object)call) ? null : (Expression)visitor.apply(expandSearch);
    };

    public static List<CallConverter> defaults(TypeConverter typeConverter) {
        return ImmutableList.of((Object)new FieldSelectionConverter(typeConverter), (Object)CASE, (Object)CAST.apply(typeConverter), (Object)REINTERPRET.apply(typeConverter), (Object)new LiteralConstructorConverter(typeConverter));
    }

    public static interface SimpleCallConverter
    extends CallConverter {
        @Nullable
        public Expression apply(RexCall var1, Function<RexNode, Expression> var2);

        @Override
        default public Optional<Expression> convert(RexCall call, Function<RexNode, Expression> topLevelConverter) {
            return Optional.ofNullable(this.apply(call, topLevelConverter));
        }
    }
}

