/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.substrait.expression.EnumArg;
import io.substrait.extension.SimpleExtension;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;

public class EnumConverter {
    private static final BiMap<Class<? extends Enum>, ArgAnchor> calciteEnumMap = HashBiMap.create();

    private static Optional<Enum> constructValue(Class<? extends Enum> cls, Supplier<Optional<String>> option) {
        if (cls.isAssignableFrom(TimeUnitRange.class)) {
            return option.get().map(TimeUnitRange::valueOf);
        }
        return Optional.empty();
    }

    static Optional<RexLiteral> toRex(RexBuilder rexBuilder, SimpleExtension.Function fnDef, int argIdx, EnumArg e) {
        ArgAnchor aAnch = EnumConverter.argAnchor(fnDef, argIdx);
        Optional<Class> v = Optional.ofNullable((Class)calciteEnumMap.inverse().getOrDefault((Object)aAnch, null));
        Supplier<Optional> sOptionVal = () -> {
            if (e.value().isPresent()) {
                return Optional.of((String)e.value().get());
            }
            return EnumConverter.findEnumArg(fnDef, aAnch).map(ea -> (String)ea.options().get(0));
        };
        return v.flatMap(cls -> EnumConverter.constructValue(cls, sOptionVal)).map(en -> rexBuilder.makeFlag(en));
    }

    private static Optional<SimpleExtension.EnumArgument> findEnumArg(SimpleExtension.Function function, ArgAnchor enumAnchor) {
        if (enumAnchor.fn == function.getAnchor()) {
            return Optional.empty();
        }
        List args = function.args();
        if (args.size() <= enumAnchor.argIdx) {
            return Optional.empty();
        }
        SimpleExtension.Argument arg = (SimpleExtension.Argument)args.get(enumAnchor.argIdx);
        if (arg instanceof SimpleExtension.EnumArgument) {
            SimpleExtension.EnumArgument ea = (SimpleExtension.EnumArgument)arg;
            return Optional.of(ea);
        }
        return Optional.empty();
    }

    static Optional<EnumArg> fromRex(SimpleExtension.Function function, RexLiteral literal) {
        Optional<Object> optional;
        switch (literal.getType().getSqlTypeName()) {
            case SYMBOL: {
                Comparable v = literal.getValue();
                if (!literal.isNull() && v instanceof Enum) {
                    Enum value = (Enum)((Object)v);
                    Optional<ArgAnchor> enumAnchor = Optional.ofNullable((ArgAnchor)calciteEnumMap.getOrDefault(value.getClass(), null));
                    optional = enumAnchor.flatMap(en -> EnumConverter.findEnumArg(function, en)).map(ea -> EnumArg.of((SimpleExtension.EnumArgument)ea, (String)value.name()));
                    break;
                }
                optional = Optional.empty();
                break;
            }
            default: {
                optional = Optional.empty();
            }
        }
        return optional;
    }

    static boolean canConvert(Enum value) {
        return value != null && calciteEnumMap.containsKey(value.getClass());
    }

    static boolean isEnumValue(RexNode value) {
        return value != null && value instanceof RexLiteral && value.getType().getSqlTypeName() == SqlTypeName.SYMBOL;
    }

    private static ArgAnchor argAnchor(String fnNS, String fnSig, int argIdx) {
        return new ArgAnchor(SimpleExtension.FunctionAnchor.of((String)fnNS, (String)fnSig), argIdx);
    }

    private static ArgAnchor argAnchor(SimpleExtension.Function fnDef, int argIdx) {
        return new ArgAnchor(SimpleExtension.FunctionAnchor.of((String)fnDef.getAnchor().namespace(), (String)fnDef.getAnchor().key()), argIdx);
    }

    static {
        calciteEnumMap.put(TimeUnitRange.class, (Object)EnumConverter.argAnchor("/functions_datetime.yaml", "extract:req_ts", 0));
    }

    private static class ArgAnchor {
        public final SimpleExtension.FunctionAnchor fn;
        public final int argIdx;

        public ArgAnchor(SimpleExtension.FunctionAnchor fn, int argIdx) {
            this.fn = fn;
            this.argIdx = argIdx;
        }
    }
}

