/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import com.google.common.collect.ImmutableList;
import io.substrait.expression.AbstractExpressionVisitor;
import io.substrait.expression.EnumArg;
import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionVisitor;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.WindowBound;
import io.substrait.extension.SimpleExtension;
import io.substrait.function.TypeExpression;
import io.substrait.isthmus.SubstraitRelNodeConverter;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.expression.EnumConverter;
import io.substrait.isthmus.expression.ScalarFunctionConverter;
import io.substrait.isthmus.expression.WindowFunctionConverter;
import io.substrait.relation.RelVisitor;
import io.substrait.type.StringTypeVisitor;
import io.substrait.type.Type;
import io.substrait.type.TypeVisitor;
import io.substrait.util.DecimalUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;

public class ExpressionRexConverter
extends AbstractExpressionVisitor<RexNode, RuntimeException>
implements FunctionArg.FuncArgVisitor<RexNode, RuntimeException> {
    protected final RelDataTypeFactory typeFactory;
    protected final TypeConverter typeConverter;
    protected final RexBuilder rexBuilder;
    protected final ScalarFunctionConverter scalarFunctionConverter;
    protected final WindowFunctionConverter windowFunctionConverter;
    protected SubstraitRelNodeConverter relNodeConverter;
    private static final SqlIntervalQualifier YEAR_MONTH_INTERVAL = new SqlIntervalQualifier(TimeUnit.YEAR, -1, TimeUnit.MONTH, -1, SqlParserPos.QUOTED_ZERO);
    private static final SqlIntervalQualifier DAY_SECOND_INTERVAL = new SqlIntervalQualifier(TimeUnit.DAY, -1, TimeUnit.SECOND, 3, SqlParserPos.QUOTED_ZERO);
    private static final long MICROS_IN_DAY = java.util.concurrent.TimeUnit.DAYS.toMicros(1L);

    public ExpressionRexConverter(RelDataTypeFactory typeFactory, ScalarFunctionConverter scalarFunctionConverter, WindowFunctionConverter windowFunctionConverter, TypeConverter typeConverter) {
        this.typeFactory = typeFactory;
        this.typeConverter = typeConverter;
        this.rexBuilder = new RexBuilder(typeFactory);
        this.scalarFunctionConverter = scalarFunctionConverter;
        this.windowFunctionConverter = windowFunctionConverter;
    }

    public void setRelNodeConverter(SubstraitRelNodeConverter substraitRelNodeConverter) {
        this.relNodeConverter = substraitRelNodeConverter;
    }

    public RexNode visit(Expression.NullLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral(null, this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.UserDefinedLiteral expr) throws RuntimeException {
        RexLiteral binaryLiteral = this.rexBuilder.makeBinaryLiteral(new ByteString(expr.value().toByteArray()));
        return this.rexBuilder.makeReinterpretCast(this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), (RexNode)binaryLiteral, null);
    }

    public RexNode visit(Expression.BoolLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral(expr.value().booleanValue());
    }

    public RexNode visit(Expression.I8Literal expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.I16Literal expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.I32Literal expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.I64Literal expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.FP32Literal expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)Float.valueOf(expr.value()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.FP64Literal expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.FixedCharLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral(expr.value());
    }

    public RexNode visit(Expression.StrLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), true);
    }

    public RexNode visit(Expression.VarCharLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), true);
    }

    public RexNode visit(Expression.FixedBinaryLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)new ByteString(expr.value().toByteArray()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), true);
    }

    public RexNode visit(Expression.BinaryLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)new ByteString(expr.value().toByteArray()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), true);
    }

    public RexNode visit(Expression.TimeLiteral expr) throws RuntimeException {
        long microSec = expr.value();
        long seconds = java.util.concurrent.TimeUnit.MICROSECONDS.toSeconds(microSec);
        int fracSecondsInNano = (int)(java.util.concurrent.TimeUnit.MICROSECONDS.toNanos(microSec) - java.util.concurrent.TimeUnit.SECONDS.toNanos(seconds));
        TimeString timeString = TimeString.fromMillisOfDay((int)((int)java.util.concurrent.TimeUnit.SECONDS.toMillis(seconds))).withNanos(fracSecondsInNano);
        return this.rexBuilder.makeLiteral((Object)timeString, this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.SingleOrList expr) throws RuntimeException {
        RexNode lhs = (RexNode)expr.condition().accept((ExpressionVisitor)this);
        return this.rexBuilder.makeIn(lhs, expr.options().stream().map(e -> (RexNode)e.accept((ExpressionVisitor)this)).collect(Collectors.toList()));
    }

    public RexNode visit(Expression.DateLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.TimestampLiteral expr) throws RuntimeException {
        long microSec = expr.value();
        long seconds = java.util.concurrent.TimeUnit.MICROSECONDS.toSeconds(microSec);
        int fracSecondsInNano = (int)(java.util.concurrent.TimeUnit.MICROSECONDS.toNanos(microSec) - java.util.concurrent.TimeUnit.SECONDS.toNanos(seconds));
        TimestampString tsString = TimestampString.fromMillisSinceEpoch((long)java.util.concurrent.TimeUnit.SECONDS.toMillis(seconds)).withNanos(fracSecondsInNano);
        return this.rexBuilder.makeLiteral((Object)tsString, this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.IntervalYearLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeIntervalLiteral(new BigDecimal(expr.years() * 12 + expr.months()), YEAR_MONTH_INTERVAL);
    }

    public RexNode visit(Expression.IntervalDayLiteral expr) throws RuntimeException {
        return this.rexBuilder.makeIntervalLiteral(new BigDecimal(((long)expr.days() * MICROS_IN_DAY + (long)expr.seconds() * 1000000L + (long)expr.microseconds()) / 1000L), DAY_SECOND_INTERVAL);
    }

    public RexNode visit(Expression.DecimalLiteral expr) throws RuntimeException {
        byte[] value = expr.value().toByteArray();
        BigDecimal decimal = DecimalUtil.getBigDecimalFromBytes((byte[])value, (int)expr.scale(), (int)16);
        return this.rexBuilder.makeLiteral((Object)decimal, this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.ListLiteral expr) throws RuntimeException {
        List args = expr.values().stream().map(l -> (RexNode)l.accept((ExpressionVisitor)this)).collect(Collectors.toList());
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, args);
    }

    public RexNode visit(Expression.EmptyListLiteral expr) throws RuntimeException {
        RelDataType calciteType = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType());
        return this.rexBuilder.makeCall(calciteType, (SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, Collections.emptyList());
    }

    public RexNode visit(Expression.MapLiteral expr) throws RuntimeException {
        List args = expr.values().entrySet().stream().flatMap(entry -> Stream.of((RexNode)((Expression.Literal)entry.getKey()).accept((ExpressionVisitor)this), (RexNode)((Expression.Literal)entry.getValue()).accept((ExpressionVisitor)this))).collect(Collectors.toList());
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, args);
    }

    public RexNode visit(Expression.IfThen expr) throws RuntimeException {
        Stream ifThenArgs = expr.ifClauses().stream().flatMap(clause -> Stream.of((RexNode)clause.condition().accept((ExpressionVisitor)this), (RexNode)clause.then().accept((ExpressionVisitor)this)));
        Stream<RexNode> elseArg = Stream.of((RexNode)expr.elseClause().accept((ExpressionVisitor)this));
        List args = Stream.concat(ifThenArgs, elseArg).collect(Collectors.toList());
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, args);
    }

    public RexNode visit(Expression.Switch expr) throws RuntimeException {
        RexNode match = (RexNode)expr.match().accept((ExpressionVisitor)this);
        Stream caseThenArgs = expr.switchClauses().stream().flatMap(clause -> Stream.of(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{match, (RexNode)clause.condition().accept((ExpressionVisitor)this)}), (RexNode)clause.then().accept((ExpressionVisitor)this)));
        Stream<RexNode> defaultArg = Stream.of((RexNode)expr.defaultClause().accept((ExpressionVisitor)this));
        List args = Stream.concat(caseThenArgs, defaultArg).collect(Collectors.toList());
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, args);
    }

    public RexNode visit(Expression.ScalarFunctionInvocation expr) throws RuntimeException {
        SqlOperator operator = this.scalarFunctionConverter.getSqlOperatorFromSubstraitFunc(expr.declaration().key(), expr.outputType()).orElseThrow(() -> new IllegalArgumentException(this.callConversionFailureMessage("scalar", expr.declaration().name(), expr.arguments())));
        List eArgs = expr.arguments();
        List args = IntStream.range(0, expr.arguments().size()).mapToObj(i -> (RexNode)((FunctionArg)eArgs.get(i)).accept((SimpleExtension.Function)expr.declaration(), i, (FunctionArg.FuncArgVisitor)this)).collect(Collectors.toList());
        return this.rexBuilder.makeCall(operator, args);
    }

    private String callConversionFailureMessage(String functionType, String name, List<FunctionArg> args) {
        return String.format("Unable to convert %s function %s(%s).", functionType, name, args.stream().map(this::convert).collect(Collectors.joining(", ")));
    }

    public RexNode visit(Expression.WindowFunctionInvocation expr) throws RuntimeException {
        boolean bl;
        boolean bl2;
        SqlOperator operator = this.windowFunctionConverter.getSqlOperatorFromSubstraitFunc(expr.declaration().key(), expr.outputType()).orElseThrow(() -> new IllegalArgumentException(this.callConversionFailureMessage("window", expr.declaration().name(), expr.arguments())));
        RelDataType outputType = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.outputType());
        List eArgs = expr.arguments();
        List args = IntStream.range(0, expr.arguments().size()).mapToObj(i -> (RexNode)((FunctionArg)eArgs.get(i)).accept((SimpleExtension.Function)expr.declaration(), i, (FunctionArg.FuncArgVisitor)this)).collect(Collectors.toList());
        List partitionKeys = expr.partitionBy().stream().map(e -> (RexNode)e.accept((ExpressionVisitor)this)).collect(Collectors.toList());
        ImmutableList orderKeys = (ImmutableList)expr.sort().stream().map(sf -> {
            Set<SqlKind> set;
            switch (sf.direction()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ASC_NULLS_FIRST: {
                    set = Set.of(SqlKind.NULLS_FIRST);
                    break;
                }
                case ASC_NULLS_LAST: {
                    set = Set.of(SqlKind.NULLS_LAST);
                    break;
                }
                case DESC_NULLS_FIRST: {
                    set = Set.of(SqlKind.DESCENDING, SqlKind.NULLS_FIRST);
                    break;
                }
                case DESC_NULLS_LAST: {
                    set = Set.of(SqlKind.DESCENDING, SqlKind.NULLS_LAST);
                    break;
                }
                case CLUSTERED: {
                    throw new IllegalArgumentException("SORT_DIRECTION_CLUSTERED is not supported");
                }
            }
            Set<SqlKind> direction = set;
            return new RexFieldCollation((RexNode)sf.expr().accept((ExpressionVisitor)this), direction);
        }).collect(ImmutableList.toImmutableList());
        RexWindowBound lowerBound = ToRexWindowBound.lowerBound(this.rexBuilder, expr.lowerBound());
        RexWindowBound upperBound = ToRexWindowBound.upperBound(this.rexBuilder, expr.upperBound());
        switch (expr.boundsType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ROWS: {
                bl2 = true;
                break;
            }
            case RANGE: {
                bl2 = false;
                break;
            }
            case UNSPECIFIED: {
                throw new IllegalArgumentException("bounds type on window function must be specified");
            }
        }
        boolean rowMode = bl2;
        switch (expr.invocation()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UNSPECIFIED: 
            case ALL: {
                bl = false;
                break;
            }
            case DISTINCT: {
                bl = true;
            }
        }
        boolean distinct = bl;
        boolean ignoreNulls = false;
        boolean nullWhenCountZero = false;
        boolean allowPartial = true;
        return this.rexBuilder.makeOver(outputType, (SqlAggFunction)operator, args, partitionKeys, orderKeys, lowerBound, upperBound, rowMode, allowPartial, nullWhenCountZero, distinct, ignoreNulls);
    }

    public RexNode visit(Expression.InPredicate expr) throws RuntimeException {
        List needles = expr.needles().stream().map(e -> (RexNode)e.accept((ExpressionVisitor)this)).collect(Collectors.toList());
        RelNode rel = (RelNode)expr.haystack().accept((RelVisitor)this.relNodeConverter);
        return RexSubQuery.in((RelNode)rel, (ImmutableList)ImmutableList.copyOf(needles));
    }

    private String convert(FunctionArg a) {
        String v;
        if (a instanceof EnumArg) {
            EnumArg ea = (EnumArg)a;
            v = ea.value().toString();
        } else if (a instanceof Expression) {
            Expression e = (Expression)a;
            v = (String)e.getType().accept((TypeVisitor)new StringTypeVisitor());
        } else if (a instanceof Type) {
            Type t = (Type)a;
            v = (String)t.accept((TypeVisitor)new StringTypeVisitor());
        } else {
            throw new IllegalStateException("Unexpected value: " + a);
        }
        return v;
    }

    public RexNode visit(Expression.Cast expr) throws RuntimeException {
        boolean safeCast = expr.failureBehavior() == Expression.FailureBehavior.RETURN_NULL;
        return this.rexBuilder.makeAbstractCast(this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), (RexNode)expr.input().accept((ExpressionVisitor)this), safeCast);
    }

    public RexNode visit(FieldReference expr) throws RuntimeException {
        if (expr.isSimpleRootReference()) {
            FieldReference.ReferenceSegment segment = (FieldReference.ReferenceSegment)expr.segments().get(0);
            if (!(segment instanceof FieldReference.StructField)) {
                throw new IllegalArgumentException("Unhandled type: " + segment);
            }
            FieldReference.StructField f = (FieldReference.StructField)segment;
            RexInputRef rexInputRef = new RexInputRef(f.offset(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
            return rexInputRef;
        }
        return this.visitFallback((Expression)expr);
    }

    public RexNode visitFallback(Expression expr) {
        throw new UnsupportedOperationException(String.format("Expression %s of type %s not handled by visitor type %s.", expr, expr.getClass().getCanonicalName(), ((Object)((Object)this)).getClass().getCanonicalName()));
    }

    public RexNode visitExpr(SimpleExtension.Function fnDef, int argIdx, Expression e) throws RuntimeException {
        return (RexNode)e.accept((ExpressionVisitor)this);
    }

    public RexNode visitType(SimpleExtension.Function fnDef, int argIdx, Type t) throws RuntimeException {
        throw new UnsupportedOperationException(String.format("FunctionArg %s not handled by visitor type %s.", t, ((Object)((Object)this)).getClass().getCanonicalName()));
    }

    public RexNode visitEnumArg(SimpleExtension.Function fnDef, int argIdx, EnumArg e) throws RuntimeException {
        return (RexNode)EnumConverter.toRex(this.rexBuilder, fnDef, argIdx, e).orElseThrow(() -> new UnsupportedOperationException(String.format("EnumArg(value=%s) not handled by visitor type %s.", e.value(), ((Object)((Object)this)).getClass().getCanonicalName())));
    }

    static class ToRexWindowBound
    implements WindowBound.WindowBoundVisitor<RexWindowBound, RuntimeException> {
        private final RexBuilder rexBuilder;
        private final RexWindowBound unboundedVariant;

        static RexWindowBound lowerBound(RexBuilder rexBuilder, WindowBound bound) {
            return (RexWindowBound)bound.accept((WindowBound.WindowBoundVisitor)new ToRexWindowBound(rexBuilder, RexWindowBounds.UNBOUNDED_PRECEDING));
        }

        static RexWindowBound upperBound(RexBuilder rexBuilder, WindowBound bound) {
            return (RexWindowBound)bound.accept((WindowBound.WindowBoundVisitor)new ToRexWindowBound(rexBuilder, RexWindowBounds.UNBOUNDED_FOLLOWING));
        }

        private ToRexWindowBound(RexBuilder rexBuilder, RexWindowBound unboundedVariant) {
            this.rexBuilder = rexBuilder;
            this.unboundedVariant = unboundedVariant;
        }

        public RexWindowBound visit(WindowBound.Preceding preceding) {
            BigDecimal offset = BigDecimal.valueOf(preceding.offset());
            return RexWindowBounds.preceding((RexNode)this.rexBuilder.makeBigintLiteral(offset));
        }

        public RexWindowBound visit(WindowBound.Following following) {
            BigDecimal offset = BigDecimal.valueOf(following.offset());
            return RexWindowBounds.following((RexNode)this.rexBuilder.makeBigintLiteral(offset));
        }

        public RexWindowBound visit(WindowBound.CurrentRow currentRow) {
            return RexWindowBounds.CURRENT_ROW;
        }

        public RexWindowBound visit(WindowBound.Unbounded unbounded) {
            return this.unboundedVariant;
        }
    }
}

