/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionCreator;
import io.substrait.expression.FieldReference;
import io.substrait.isthmus.CallConverter;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.expression.LiteralConverter;
import java.util.Optional;
import java.util.function.Function;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSelectionConverter
implements CallConverter {
    static final Logger logger = LoggerFactory.getLogger(FieldSelectionConverter.class);
    private final TypeConverter typeConverter;

    public FieldSelectionConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public Optional<Expression> convert(RexCall call, Function<RexNode, Expression> topLevelConverter) {
        if (call.getKind() != SqlKind.ITEM) {
            return Optional.empty();
        }
        RexNode toDereference = (RexNode)call.getOperands().get(0);
        RexNode reference = (RexNode)call.getOperands().get(1);
        if (reference.getKind() != SqlKind.LITERAL || !(reference instanceof RexLiteral)) {
            logger.warn("Found item operator without literal kind/type. This isn't handled well. Reference was {} with toString {}.", (Object)reference.getKind().name(), (Object)reference);
            return Optional.empty();
        }
        Expression.Literal literal = new LiteralConverter(this.typeConverter).convert((RexLiteral)reference);
        Expression input = topLevelConverter.apply(toDereference);
        switch (toDereference.getType().getSqlTypeName()) {
            case ROW: {
                Optional<Integer> index = this.toInt(literal);
                if (index.isEmpty()) {
                    return Optional.empty();
                }
                if (input instanceof FieldReference) {
                    return Optional.of(((FieldReference)input).dereferenceStruct(index.get().intValue()));
                }
                return Optional.of(FieldReference.newStructReference((int)index.get(), (Expression)input));
            }
            case ARRAY: {
                Optional<Integer> index = this.toInt(literal);
                if (index.isEmpty()) {
                    return Optional.empty();
                }
                if (input instanceof FieldReference) {
                    return Optional.of(((FieldReference)input).dereferenceList(index.get().intValue()));
                }
                return Optional.of(FieldReference.newListReference((int)index.get(), (Expression)input));
            }
            case MAP: {
                Optional<String> mapKey = this.toString(literal);
                if (mapKey.isEmpty()) {
                    return Optional.empty();
                }
                Expression.StrLiteral keyLiteral = ExpressionCreator.string((boolean)false, (String)mapKey.get());
                if (input instanceof FieldReference) {
                    return Optional.of(((FieldReference)input).dereferenceMap((Expression.Literal)keyLiteral));
                }
                return Optional.of(FieldReference.newMapReference((Expression.Literal)keyLiteral, (Expression)input));
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> toInt(Expression.Literal l) {
        if (l instanceof Expression.I8Literal) {
            Expression.I8Literal i8 = (Expression.I8Literal)l;
            return Optional.of(i8.value());
        }
        if (l instanceof Expression.I16Literal) {
            Expression.I16Literal i16 = (Expression.I16Literal)l;
            return Optional.of(i16.value());
        }
        if (l instanceof Expression.I32Literal) {
            Expression.I32Literal i32 = (Expression.I32Literal)l;
            return Optional.of(i32.value());
        }
        if (l instanceof Expression.I64Literal) {
            Expression.I64Literal i64 = (Expression.I64Literal)l;
            return Optional.of((int)i64.value());
        }
        logger.warn("Literal expected to be int type but was not. {}.", (Object)l);
        return Optional.empty();
    }

    public Optional<String> toString(Expression.Literal l) {
        if (!(l instanceof Expression.FixedCharLiteral)) {
            logger.warn("Literal expected to be char type but was not. {}", (Object)l);
            return Optional.empty();
        }
        return Optional.of(((Expression.FixedCharLiteral)l).value());
    }
}

