/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import com.google.common.collect.ImmutableList;
import io.substrait.isthmus.AggregateFunctions;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class FunctionMappings {
    public static final ImmutableList<Sig> SCALAR_SIGS = ImmutableList.builder().add((Object[])new Sig[]{FunctionMappings.s((SqlOperator)SqlStdOperatorTable.PLUS, "add"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.MINUS, "subtract"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, "negate"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.MULTIPLY, "multiply"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.DIVIDE, "divide"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.ABS, "abs"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.MOD, "modulus"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.POWER, "power"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.EXP, "exp"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.SIN, "sin"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.COS, "cos"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.TAN, "tan"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.ASIN, "asin"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.ACOS, "acos"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.ATAN, "atan"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.ATAN2, "atan2"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.SIGN, "sign"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LOG10, "log10"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LN, "ln"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.AND), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.OR), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.NOT), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LESS_THAN, "lt"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, "lte"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.GREATER_THAN, "gt"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, "gte"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.EQUALS, "equal"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.BIT_XOR, "xor"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.IS_NULL, "is_null"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, "is_not_null"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, "not_equal"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.MINUS_DATE, "subtract"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, "add"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.EXTRACT, "extract"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.CEIL, "ceil"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.FLOOR, "floor"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.ROUND, "round"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LIKE), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.REPLACE, "replace"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.SUBSTRING, "substring"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.CONCAT, "concat"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, "char_length"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LOWER, "lower"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.UPPER, "upper"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.BETWEEN), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, "is_not_distinct_from"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.COALESCE, "coalesce")}).build();
    public static final ImmutableList<Sig> AGGREGATE_SIGS = ImmutableList.builder().add((Object[])new Sig[]{FunctionMappings.s((SqlOperator)AggregateFunctions.MIN, "min"), FunctionMappings.s((SqlOperator)AggregateFunctions.MAX, "max"), FunctionMappings.s((SqlOperator)AggregateFunctions.SUM, "sum"), FunctionMappings.s((SqlOperator)AggregateFunctions.SUM0, "sum0"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.COUNT, "count"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.APPROX_COUNT_DISTINCT, "approx_count_distinct"), FunctionMappings.s((SqlOperator)AggregateFunctions.AVG, "avg")}).build();
    public static final ImmutableList<Sig> WINDOW_SIGS = ImmutableList.builder().add((Object[])new Sig[]{FunctionMappings.s((SqlOperator)SqlStdOperatorTable.ROW_NUMBER, "row_number"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LAG, "lag"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LEAD, "lead"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.RANK, "rank"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.DENSE_RANK, "dense_rank"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.PERCENT_RANK, "percent_rank"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.CUME_DIST, "cume_dist"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.NTILE, "ntile"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.FIRST_VALUE, "first_value"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.LAST_VALUE, "last_value"), FunctionMappings.s((SqlOperator)SqlStdOperatorTable.NTH_VALUE, "nth_value")}).addAll(AGGREGATE_SIGS).build();
    public static final Map<SqlOperator, TypeBasedResolver> OPERATOR_RESOLVER = Map.of(SqlStdOperatorTable.PLUS, FunctionMappings.resolver((SqlOperator)SqlStdOperatorTable.PLUS, Set.of("i8", "i16", "i32", "i64", "fp32", "fp64", "dec")), SqlStdOperatorTable.DATETIME_PLUS, FunctionMappings.resolver((SqlOperator)SqlStdOperatorTable.PLUS, Set.of("date", "time", "timestamp")), SqlStdOperatorTable.MINUS, FunctionMappings.resolver((SqlOperator)SqlStdOperatorTable.MINUS, Set.of("i8", "i16", "i32", "i64", "fp32", "fp64", "dec")), SqlStdOperatorTable.MINUS_DATE, FunctionMappings.resolver((SqlOperator)SqlStdOperatorTable.MINUS_DATE, Set.of("date", "timestamp_tz", "timestamp")));

    public static void main(String[] args) {
        SCALAR_SIGS.forEach(System.out::println);
    }

    public static Sig s(SqlOperator operator, String substraitName) {
        return new Sig(operator, substraitName.toLowerCase(Locale.ROOT));
    }

    public static Sig s(SqlOperator operator) {
        return FunctionMappings.s(operator, operator.getName().toLowerCase(Locale.ROOT));
    }

    public static TypeBasedResolver resolver(SqlOperator operator, Set<String> outTypes) {
        return new TypeBasedResolver(operator, outTypes);
    }

    public static class Sig {
        public final SqlOperator operator;
        public final String name;

        public Sig(SqlOperator operator, String name) {
            this.operator = operator;
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public SqlOperator operator() {
            return this.operator;
        }
    }

    public static class TypeBasedResolver {
        public final SqlOperator operator;
        public final Set<String> types;

        public TypeBasedResolver(SqlOperator operator, Set<String> types) {
            this.operator = operator;
            this.types = types;
        }

        public SqlOperator operator() {
            return this.operator;
        }

        public Set<String> types() {
            return this.types;
        }
    }
}

