/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionCreator;
import io.substrait.isthmus.CallConverter;
import io.substrait.isthmus.TypeConverter;
import io.substrait.type.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlArrayValueConstructor;
import org.apache.calcite.sql.fun.SqlMapValueConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralConstructorConverter
implements CallConverter {
    static final Logger logger = LoggerFactory.getLogger(LiteralConstructorConverter.class);
    private final TypeConverter typeConverter;

    public LiteralConstructorConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public Optional<Expression> convert(RexCall call, Function<RexNode, Expression> topLevelConverter) {
        SqlOperator operator = call.getOperator();
        if (operator instanceof SqlArrayValueConstructor) {
            return call.getOperands().isEmpty() ? this.toEmptyListLiteral(call) : this.toNonEmptyListLiteral(call, topLevelConverter);
        }
        if (operator instanceof SqlMapValueConstructor) {
            return this.toMapLiteral(call, topLevelConverter);
        }
        return Optional.empty();
    }

    private Optional<Expression> toMapLiteral(RexCall call, Function<RexNode, Expression> topLevelConverter) {
        List literals = call.operands.stream().map(t -> (Expression.Literal)topLevelConverter.apply((RexNode)t)).collect(Collectors.toList());
        HashMap<Expression.Literal, Expression.Literal> items = new HashMap<Expression.Literal, Expression.Literal>();
        assert (literals.size() % 2 == 0);
        for (int i = 0; i < literals.size(); i += 2) {
            items.put((Expression.Literal)literals.get(i), (Expression.Literal)literals.get(i + 1));
        }
        return Optional.of(ExpressionCreator.map((boolean)false, items));
    }

    private Optional<Expression> toNonEmptyListLiteral(RexCall call, Function<RexNode, Expression> topLevelConverter) {
        return Optional.of(ExpressionCreator.list((boolean)call.getType().isNullable(), (Iterable)call.operands.stream().map(t -> (Expression.Literal)topLevelConverter.apply((RexNode)t)).collect(Collectors.toList())));
    }

    private Optional<Expression> toEmptyListLiteral(RexCall call) {
        RelDataType calciteElementType = call.getType().getComponentType();
        Type substraitElementType = this.typeConverter.toSubstrait(calciteElementType);
        return Optional.of(ExpressionCreator.emptyList((boolean)call.getType().isNullable(), (Type)substraitElementType));
    }
}

