/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionCreator;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.expression.EnumConverter;
import io.substrait.type.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralConverter {
    static final Logger logger = LoggerFactory.getLogger(LiteralConverter.class);
    private final TypeConverter typeConverter;
    private static final long MICROS_IN_DAY = TimeUnit.DAYS.toMicros(1L);
    static final DateTimeFormatter CALCITE_LOCAL_DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    static final DateTimeFormatter CALCITE_LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final DateTimeFormatter CALCITE_LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(CALCITE_LOCAL_DATE_FORMATTER).appendLiteral(' ').append(CALCITE_LOCAL_TIME_FORMATTER).toFormatter();
    private static final DateTimeFormatter CALCITE_TIMESTAMP_WITH_ZONE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(CALCITE_LOCAL_DATE_FORMATTER).appendLiteral(' ').append(CALCITE_LOCAL_TIME_FORMATTER).appendLiteral(' ').appendZoneId().toFormatter();
    private static final ZoneOffset SYSTEM_TIMEZONE = OffsetDateTime.now(ZoneId.systemDefault()).getOffset();

    public LiteralConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    private Expression nullOf(RexLiteral literal) {
        return null;
    }

    private static BigDecimal i(RexLiteral literal) {
        return LiteralConverter.bd(literal).setScale(0, RoundingMode.HALF_UP);
    }

    private static String s(RexLiteral literal) {
        return ((NlsString)literal.getValue()).getValue();
    }

    private static BigDecimal bd(RexLiteral literal) {
        return (BigDecimal)literal.getValue();
    }

    public Expression.Literal convert(RexLiteral literal) {
        Expression.I8Literal i8Literal;
        Type type = this.typeConverter.toSubstrait(literal.getType());
        boolean n = type.nullable();
        if (literal.isNull()) {
            return ExpressionCreator.typedNull((Type)type);
        }
        switch (literal.getType().getSqlTypeName()) {
            case TINYINT: {
                i8Literal = ExpressionCreator.i8((boolean)n, (int)LiteralConverter.i(literal).intValue());
                break;
            }
            case SMALLINT: {
                i8Literal = ExpressionCreator.i16((boolean)n, (int)LiteralConverter.i(literal).intValue());
                break;
            }
            case INTEGER: {
                i8Literal = ExpressionCreator.i32((boolean)n, (int)LiteralConverter.i(literal).intValue());
                break;
            }
            case BIGINT: {
                i8Literal = ExpressionCreator.i64((boolean)n, (long)LiteralConverter.i(literal).longValue());
                break;
            }
            case BOOLEAN: {
                i8Literal = ExpressionCreator.bool((boolean)n, (boolean)((Boolean)literal.getValue()));
                break;
            }
            case CHAR: {
                Comparable val = literal.getValue();
                if (val instanceof NlsString) {
                    NlsString nls = (NlsString)val;
                    i8Literal = ExpressionCreator.fixedChar((boolean)n, (String)nls.getValue());
                    break;
                }
                throw new UnsupportedOperationException("Unable to handle char type: " + val);
            }
            case DOUBLE: {
                i8Literal = ExpressionCreator.fp64((boolean)n, (double)LiteralConverter.bd(literal).doubleValue());
                break;
            }
            case FLOAT: {
                i8Literal = ExpressionCreator.fp32((boolean)n, (float)LiteralConverter.bd(literal).floatValue());
                break;
            }
            case DECIMAL: {
                BigDecimal bd = LiteralConverter.bd(literal);
                i8Literal = ExpressionCreator.decimal((boolean)n, (BigDecimal)bd, (int)literal.getType().getPrecision(), (int)literal.getType().getScale());
                break;
            }
            case VARCHAR: {
                if (literal.getType().getPrecision() == -1) {
                    i8Literal = ExpressionCreator.string((boolean)n, (String)LiteralConverter.s(literal));
                    break;
                }
                i8Literal = ExpressionCreator.varChar((boolean)n, (String)LiteralConverter.s(literal), (int)literal.getType().getPrecision());
                break;
            }
            case BINARY: {
                i8Literal = ExpressionCreator.fixedBinary((boolean)n, (com.google.protobuf.ByteString)com.google.protobuf.ByteString.copyFrom((byte[])LiteralConverter.padRightIfNeeded((ByteString)literal.getValueAs(ByteString.class), literal.getType().getPrecision())));
                break;
            }
            case VARBINARY: {
                i8Literal = ExpressionCreator.binary((boolean)n, (com.google.protobuf.ByteString)com.google.protobuf.ByteString.copyFrom((byte[])((byte[])literal.getValueAs(byte[].class))));
                break;
            }
            case SYMBOL: {
                Comparable value = literal.getValue();
                if (value instanceof NlsString) {
                    NlsString s = (NlsString)value;
                    i8Literal = ExpressionCreator.string((boolean)n, (String)s.getValue());
                    break;
                }
                if (value instanceof Enum) {
                    Enum v = (Enum)((Object)value);
                    Optional r = EnumConverter.canConvert(v) ? Optional.of(ExpressionCreator.string((boolean)n, (String)v.name())) : Optional.empty();
                    i8Literal = (Expression.Literal)r.orElseThrow(() -> new UnsupportedOperationException("Unable to handle symbol: " + value));
                    break;
                }
                throw new UnsupportedOperationException("Unable to handle symbol: " + value);
            }
            case DATE: {
                DateString date = (DateString)literal.getValueAs(DateString.class);
                LocalDate localDate = LocalDate.parse(date.toString(), CALCITE_LOCAL_DATE_FORMATTER);
                i8Literal = ExpressionCreator.date((boolean)n, (int)((int)localDate.toEpochDay()));
                break;
            }
            case TIME: {
                TimeString time = (TimeString)literal.getValueAs(TimeString.class);
                LocalTime localTime = LocalTime.parse(time.toString(), CALCITE_LOCAL_TIME_FORMATTER);
                i8Literal = ExpressionCreator.time((boolean)n, (long)TimeUnit.NANOSECONDS.toMicros(localTime.toNanoOfDay()));
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                TimestampString timestamp = (TimestampString)literal.getValueAs(TimestampString.class);
                LocalDateTime ldt = LocalDateTime.parse(timestamp.toString(), CALCITE_LOCAL_DATETIME_FORMATTER);
                i8Literal = ExpressionCreator.timestamp((boolean)n, (LocalDateTime)ldt);
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                long intervalLength = ((BigDecimal)literal.getValueAs(BigDecimal.class)).longValue();
                long years = intervalLength / 12L;
                long months = intervalLength - years * 12L;
                i8Literal = ExpressionCreator.intervalYear((boolean)n, (int)((int)years), (int)((int)months));
                break;
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                int scale = literal.getType().getScale();
                long intervalLength = ((BigDecimal)literal.getValueAs(BigDecimal.class)).longValue();
                long adjustedLength = scale > 6 ? intervalLength / (long)((int)Math.pow(10.0, scale - 6)) : intervalLength * (long)((int)Math.pow(10.0, 6 - scale));
                long days = adjustedLength / MICROS_IN_DAY;
                long totalMicroseconds = adjustedLength - days * MICROS_IN_DAY;
                long seconds = totalMicroseconds / 1000000L;
                long microseconds = totalMicroseconds - 1000000L * seconds;
                i8Literal = ExpressionCreator.intervalDay((boolean)n, (int)((int)days), (int)((int)seconds), (int)((int)microseconds));
                break;
            }
            case ROW: {
                List literals = (List)((Object)literal.getValue());
                i8Literal = ExpressionCreator.struct((boolean)n, (Iterable)literals.stream().map(this::convert).collect(Collectors.toList()));
                break;
            }
            case ARRAY: {
                List literals = (List)((Object)literal.getValue());
                i8Literal = ExpressionCreator.list((boolean)n, (Iterable)literals.stream().map(this::convert).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to convert the value of %s of type %s to a literal.", literal, literal.getType().getSqlTypeName()));
            }
        }
        return i8Literal;
    }

    public static byte[] padRightIfNeeded(ByteString bytes, int length) {
        return LiteralConverter.padRightIfNeeded(bytes.getBytes(), length);
    }

    public static byte[] padRightIfNeeded(byte[] value, int length) {
        if (length < value.length) {
            throw new IllegalArgumentException("Byte values should either be at or below the expected length.");
        }
        if (length == value.length) {
            return value;
        }
        byte[] newArray = new byte[length];
        System.arraycopy(value, 0, newArray, 0, value.length);
        return newArray;
    }
}

