/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.FieldReference;
import io.substrait.isthmus.CallConverter;
import io.substrait.isthmus.SubstraitRelVisitor;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.expression.CallConverters;
import io.substrait.isthmus.expression.LiteralConverter;
import io.substrait.isthmus.expression.WindowFunctionConverter;
import io.substrait.relation.Rel;
import io.substrait.type.StringTypeVisitor;
import io.substrait.type.Type;
import io.substrait.type.TypeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexExpressionConverter
implements RexVisitor<Expression> {
    static final Logger logger = LoggerFactory.getLogger(RexExpressionConverter.class);
    private final List<CallConverter> callConverters;
    private final SubstraitRelVisitor relVisitor;
    private final TypeConverter typeConverter;
    private WindowFunctionConverter windowFunctionConverter;

    public RexExpressionConverter(SubstraitRelVisitor relVisitor, CallConverter ... callConverters) {
        this(relVisitor, Arrays.asList(callConverters), null, TypeConverter.DEFAULT);
    }

    public RexExpressionConverter(CallConverter ... callConverters) {
        this(null, Arrays.asList(callConverters), null, TypeConverter.DEFAULT);
    }

    public RexExpressionConverter(SubstraitRelVisitor relVisitor, List<CallConverter> callConverters, WindowFunctionConverter windowFunctionConverter, TypeConverter typeConverter) {
        this.callConverters = callConverters;
        this.relVisitor = relVisitor;
        this.windowFunctionConverter = windowFunctionConverter;
        this.typeConverter = typeConverter;
    }

    public RexExpressionConverter() {
        this(null, CallConverters.defaults(TypeConverter.DEFAULT), null, TypeConverter.DEFAULT);
    }

    public Expression visitInputRef(RexInputRef inputRef) {
        return FieldReference.newRootStructReference((int)inputRef.getIndex(), (Type)this.typeConverter.toSubstrait(inputRef.getType()));
    }

    public Expression visitCall(RexCall call) {
        for (CallConverter c : this.callConverters) {
            Optional<Expression> out = c.convert(call, rexNode -> (Expression)rexNode.accept((RexVisitor)this));
            if (!out.isPresent()) continue;
            return out.get();
        }
        throw new IllegalArgumentException(this.callConversionFailureMessage(call));
    }

    private String callConversionFailureMessage(RexCall call) {
        return String.format("Unable to convert call %s(%s).", call.getOperator().getName(), call.getOperands().stream().map(t -> (String)((Expression)t.accept((RexVisitor)this)).getType().accept((TypeVisitor)new StringTypeVisitor())).collect(Collectors.joining(", ")));
    }

    public Expression visitLiteral(RexLiteral literal) {
        return new LiteralConverter(this.typeConverter).convert(literal);
    }

    public Expression visitOver(RexOver over) {
        if (over.ignoreNulls()) {
            throw new IllegalArgumentException("IGNORE NULLS cannot be expressed in Substrait");
        }
        return (Expression)this.windowFunctionConverter.convert(over, rexNode -> (Expression)rexNode.accept((RexVisitor)this), this).orElseThrow(() -> new IllegalArgumentException(this.callConversionFailureMessage((RexCall)over)));
    }

    public Expression visitCorrelVariable(RexCorrelVariable correlVariable) {
        throw new UnsupportedOperationException("RexCorrelVariable not supported");
    }

    public Expression visitDynamicParam(RexDynamicParam dynamicParam) {
        throw new UnsupportedOperationException("RexDynamicParam not supported");
    }

    public Expression visitRangeRef(RexRangeRef rangeRef) {
        throw new UnsupportedOperationException("RexRangeRef not supported");
    }

    public Expression visitFieldAccess(RexFieldAccess fieldAccess) {
        SqlKind kind = fieldAccess.getReferenceExpr().getKind();
        switch (kind) {
            case CORREL_VARIABLE: {
                int stepsOut = this.relVisitor.getFieldAccessDepth(fieldAccess);
                return FieldReference.newRootStructOuterReference((int)fieldAccess.getField().getIndex(), (Type)this.typeConverter.toSubstrait(fieldAccess.getType()), (int)stepsOut);
            }
            case ITEM: 
            case INPUT_REF: 
            case FIELD_ACCESS: {
                Expression expression = (Expression)fieldAccess.getReferenceExpr().accept((RexVisitor)this);
                if (expression instanceof FieldReference) {
                    FieldReference nestedReference = (FieldReference)expression;
                    return nestedReference.dereferenceStruct(fieldAccess.getField().getIndex());
                }
                return FieldReference.newStructReference((int)fieldAccess.getField().getIndex(), (Expression)expression);
            }
        }
        throw new UnsupportedOperationException(String.format("RexFieldAccess for SqlKind %s not supported", kind));
    }

    public Expression visitSubQuery(RexSubQuery subQuery) {
        Rel rel = this.relVisitor.apply(subQuery.rel);
        if (subQuery.getOperator() == SqlStdOperatorTable.EXISTS) {
            return Expression.SetPredicate.builder().predicateOp(Expression.PredicateOp.PREDICATE_OP_EXISTS).tuples(rel).build();
        }
        if (subQuery.getOperator() == SqlStdOperatorTable.UNIQUE) {
            return Expression.SetPredicate.builder().predicateOp(Expression.PredicateOp.PREDICATE_OP_UNIQUE).tuples(rel).build();
        }
        if (subQuery.getOperator() == SqlStdOperatorTable.SCALAR_QUERY) {
            return Expression.ScalarSubquery.builder().input(rel).type(this.typeConverter.toSubstrait(subQuery.getType())).build();
        }
        if (subQuery.getOperator() == SqlStdOperatorTable.IN) {
            ArrayList<Expression> needles = new ArrayList<Expression>();
            for (RexNode inOperand : subQuery.getOperands()) {
                needles.add((Expression)inOperand.accept((RexVisitor)this));
            }
            return Expression.InPredicate.builder().needles(needles).haystack(rel).build();
        }
        throw new UnsupportedOperationException("RexSubQuery not supported");
    }

    public Expression visitTableInputRef(RexTableInputRef fieldRef) {
        throw new UnsupportedOperationException("RexTableInputRef not supported");
    }

    public Expression visitLocalRef(RexLocalRef localRef) {
        throw new UnsupportedOperationException("RexLocalRef not supported");
    }

    public Expression visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        throw new UnsupportedOperationException("RexPatternFieldRef not supported");
    }
}

