/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.Expression;
import io.substrait.isthmus.expression.RexExpressionConverter;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;

public class SortFieldConverter {
    public static Expression.SortField toSortField(RexFieldCollation rexFieldCollation, RexExpressionConverter rexExpressionConverter) {
        Expression.SortDirection sortDirection;
        Expression expr = (Expression)((RexNode)rexFieldCollation.left).accept((RexVisitor)rexExpressionConverter);
        RelFieldCollation.Direction rexDirection = rexFieldCollation.getDirection();
        switch (rexDirection) {
            case ASCENDING: {
                if (rexFieldCollation.getNullDirection() == RelFieldCollation.NullDirection.LAST) {
                    sortDirection = Expression.SortDirection.ASC_NULLS_LAST;
                    break;
                }
                sortDirection = Expression.SortDirection.ASC_NULLS_FIRST;
                break;
            }
            case DESCENDING: {
                if (rexFieldCollation.getNullDirection() == RelFieldCollation.NullDirection.LAST) {
                    sortDirection = Expression.SortDirection.DESC_NULLS_LAST;
                    break;
                }
                sortDirection = Expression.SortDirection.DESC_NULLS_FIRST;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected RelFieldCollation.Direction:%s enum at the RexFieldCollation!", rexDirection));
            }
        }
        Expression.SortDirection direction = sortDirection;
        return Expression.SortField.builder().expr(expr).direction(direction).build();
    }
}

